@extends('layouts.app')
@section('title', $voucher_type->name . ' - '. $sale_invoice->main_invoice_no . ' - '. ($sale_invoice->invoice_date ? formatedDate($sale_invoice->invoice_date) : '') . ' - ' . ($sale_invoice->getPatient->name ?? ''))
@section('pages')
<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />
@php $pageTitle =  $sale_invoice->main_invoice_no . ' - ' .($sale_invoice->getPatient->name ?? '').'-'. ($sale_invoice->invoice_date ?
formatedDate($sale_invoice->invoice_date) : '') ; @endphp
<div  class="card-header py-3">
    <div class="row gx-2">
        <div class="col-lg-8 col-md-8 col-8">
            <div class="position-relative">
                <h5>IPD Invoice of {!! $sale_invoice->getPatient->account_title->name ?? '' !!} {!! $sale_invoice->getPatient->name ?? '' !!} (
                    {!! $sale_invoice->getPatient->code ?? '' !!}) Batch NO: {!! $sale_invoice->getSaleInvoiceDetails[0]->getBatch->invoice_batch_no ?? '' !!}
                </h5>
            </div>
        </div>
        <div class="col-lg-4 col-md-4">
            <div class="ms-auto float-md-end">
                <div class="btn-group">
                    @if(isset($sale_invoice->ipd_admission_id))
                    <a href="{{ route('ipd-admissions.show',$sale_invoice->ipd_admission_id) }}" class="btn btn-outline-secondary me-1">
                        <i class="bx bx-arrow-back ms-0 me-1"></i>Back
                    </a>
                    @else
                    <a href="{{ route('ipd-admissions.index') }}" class="btn btn-outline-secondary me-1">
                        <i class="bx bx-arrow-back ms-0 me-1"></i>Back
                    </a>
                    @endif
                    {{-- @if(in_array('ipd-admission-create', $authRolePermissions))
                      <a href="{{ route('ipd-admissions.create') }}" class="btn btn-primary"><i class="bx bx-plus"></i> New Admission</a>
                    @endif --}}
                    {{-- <div class="float-md-end" style="margin-right: 10px">
                        <a href="{{ route('ipd-billings.create', $ipd_id ?? '') }}" class="btn btn-info new-bill">
                            <i class="bx bx-plus text-white"></i> New Intent
                        </a>
                    </div> --}}
                </div>
            </div>
        </div>
    </div>
</div>
    <div id="print_div">
        <div class="pathology-bill">
            <div class="row mt-2">
                <div class="col-md-12 col-xs-12 p-1">
                    <div class="card border-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <table class="table table-borderless report-container">
                                    @php $company = @$sale_invoice->getCompany;@endphp
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell" style="font-weight: normal;">
                                                <x-CompanyLetterHead :company="$company" />
                                                @php $voucherType = 'PATHOLOGY_LAB_BILLING'; @endphp
                                                @php $saleInvoice = $sale_invoice; @endphp
                                                @php $voucherTitle = $voucher_type->voucher_title; @endphp
                                                @include('components.ipd-specific-print-voucher-details')
                                            </th>
                                        </tr>
                                    </thead>
                                    <tfoot class="report-footer">
                                        <tr>
                                            <td class="report-footer-cell">
                                            </td>
                                        </tr>
                                    </tfoot>
                                        <tbody class="report-content">
                                            <tr>
                                                <td class="report-content-cell  text-left">
                                                    <x-Ipd.VoucherItemDetails :saleInvoice="$sale_invoice" :voucherTypeDetails="$voucher_type"/>
                                                    <div class="row mt-n2">
                                                    <div class="col-4">
                                                    <p><b>Print Date and Time</b>: {!! formatedDateTime(date('Y-m-d H:i:s')) !!}<br>
                                                        <b>Note: Digitally Generated
                                                            Voucher, Signature Not Required</b>
                                                    </p>
                                                    </div>
                                                    <div class="col-4">
                                                    </div>
                                                    <x-VoucherSummary :transactionSummery="$transactionSummery"/>
                                                    <x-IPDBillFooter :saleInvoice="$sale_invoice"/>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="text-center">
    <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Invoice </button>
</div>
@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            // printInvoice(page_title);
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
</script>
@endsection
