@extends('layouts.app')
@section('title', $voucher_type->name . ' - '. $sale_invoice->main_invoice_no . ' - '. ($sale_invoice->invoice_date ? formatedDate($sale_invoice->invoice_date) : '') . ' - ' . ($sale_invoice->getPatient->name ?? ''))
@section('pages')
<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />

@php $pageTitle =  $sale_invoice->main_invoice_no . ' - ' .($sale_invoice->getPatient->name ?? '').'-'. ($sale_invoice->invoice_date ?
formatedDate($sale_invoice->invoice_date) : '') ; @endphp

<div id="btn_back" class="card-header py-3">
    <div class="row gx-2">
        <div class="col-lg-6 col-md-6 col-6">
            <div class="position-relative">
                <h5>IPD Invoice of {!! $sale_invoice->getPatient->account_title->name ?? '' !!} {!! $sale_invoice->getPatient->name ?? '' !!} ({!! $sale_invoice->getPatient->code ?? '' !!})</h5>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="ms-auto float-md-end">
                <div class="btn-group">
                    <a href="{{ request()->get('redirect_route') != '' ? route(request()->get('redirect_route')) : route('ipd-billings.index') }}" class="btn btn-outline-secondary me-1"><i
                            class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                    @if(in_array('pathology-lab-billing-create', $authRolePermissions))
                        <a href="{!! route('lab-billings.create') !!}" class="btn btn-primary"><i class="bx bx-plus"></i> New Invoice</a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
    <div id="print_div">
        <div class="pathology-bill">
            <div class="row mt-2">
                <div class="col-md-12 col-xs-12 p-1">
                    <div class="card border-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <table class="table table-borderless report-container">
                                    @php $company = @$sale_invoice->getCompany;@endphp
                                        <x-CompanyLetterHead :company="$company"/>

                                        <tbody class="report-content">
                                            <tr>
                                                <td class="report-content-cell  text-left">
                                                    {{--<div class="row border border-dark border-bottom-0 m-0 pb-1 mt-2" style="border:1px solid #000;">
                                                        <div class="col-4 font-12"><b>Invoice No :</b> {!! $sale_invoice->main_invoice_no ?? '' !!}</div>
                                                        <div class="col-4 text-left font-12"><b>Invoice Date :</b> {!! $sale_invoice->invoice_date ? formatedDate($sale_invoice->invoice_date) : '' !!}</div>
                                                        <div class="col-4"><b style="margin-left:144px">Payment Terms :</b> {!! $sale_invoice->getPaymentTerm->payment_term_name ?? '' !!}</div>
                                                    </div>
                                                    @php
                                                        $date_of_birth = $sale_invoice->getPatient->account_contact->date_of_birth ?? '';
                                                        $age           = $date_of_birth != '' ? age($sale_invoice->getPatient->account_contact->date_of_birth) : 0;
                                                    @endphp
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="row border border-dark py-1 m-0" style="line-height:1.2;">
                                                                <div class="col-4 border-right border-dark" style="font-size:12px;">
                                                                    <span style="font-size: 13px;border-bottom:1px solid #555;">
                                                                    Patient Details:
                                                                    </span>
                                                                    <p class="mb-0 pt-1"><b>{!! $sale_invoice->getPatient->account_title->name ?? '' !!} {!! $sale_invoice->getPatient->name ?? '' !!} ({!! $sale_invoice->getPatient->code ?? '' !!})</b></p>
                                                                    <p class="mb-0 ">Gender : {!! $sale_invoice->getPatient->account_contact->gender->name ?? '' !!}</p>
                                                                    <p class="mb-0 ">Age : {!! $age !!} Years</p>
                                                                    <p class="mb-0 ">{!! $sale_invoice->getPatient->first_account_address->address_line1 ?? '' !!}</p>
                                                                    <p class="mb-0 ">State Name : {!! $sale_invoice->getPatient->first_account_address->state->name ?? '' !!}</p>
                                                                </div>
                                                                <div class="col-4 border-right border-dark" style="font-size:12px;">
                                                                    <p class="mb-0 ">Phone No : {!! $sale_invoice->getPatient->account_contact->phone_no ?? '' !!}</p>
                                                                    <p class="mb-0 ">Email : {!! $sale_invoice->getPatient->account_contact->email ?? '' !!}</p>
                                                                    <p class="mb-0">Reff No. : {!! $sale_invoice->reff_no ?? '' !!}</p>
                                                                    <p class="mb-0">Delivery Date : {!! $sale_invoice->getSaleInvoiceDelivery->delivery_date ?? '' !!}</p>
                                                                    <p class="mb-0">Delivery Agent : Self</p>
                                                                </div>
                                                                <div class="col-4 text-center pt-1 pb-1" style="width:auto !important; margin-left:96px">
                                                                    <div class="mb-3">
                                                                        {!! DNS1D::getBarcodeHTML($sale_invoice->main_invoice_no, 'C93') !!}
                                                                        <br>
                                                                        <h4>{!! $sale_invoice->main_invoice_no ?? '' !!}</h4>
                                                                    </div>
                                                            </div>
                                                            </div>
                                                            <table class="table table-borderless table-sm" id="account_to">
                                                                <tbody>
                                                                    <tr>

                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                    <div class="row mt-n3">
                                                        <div class="col-12 text-center">
                                                            <h4 class="text-bold">{!! $voucher_type->voucher_title ?? '' !!}
                                                                <input type="hidden" name="saleid" value="{!! $sale_invoice->main_invoice_no !!}" id="saleid">
                                                            </h4>
                                                        </div>
                                                    </div>--}}

                                                    <x-VoucherDetails :saleInvoice="$sale_invoice" voucherType="IPD_ADMISSION" :voucherTitle="$voucher_type->voucher_title"/>
                                                    <x-VoucherItemDetails :saleInvoice="$sale_invoice" :voucherTypeDetails="$voucher_type"/>

                                                    {{--<div class="row">
                                                        <div class="col-12">
                                                            <table class="table table-bordered-print w-100" id="quotation_products" border='1' style="border:1px solid #000;">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Sl.No</th>
                                                                        <th>ITEM DETAILS </th>
                                                                        <th>HSN/SAC</th>
                                                                        <th style="text-align: right !important;">MRP</th>
                                                                        <th style="text-align: right !important;">QTY</th>
                                                                        <th style="text-align: right !important;">Dis(%)</th>
                                                                        <th style="text-align: right !important;">PRICE</th>
                                                                        <th style="text-align: right !important;">GST%</th>
                                                                        <th style="text-align: right !important;">IGST</th>
                                                                        <th style="text-align: right !important;">CGST</th>
                                                                        <th style="text-align: right !important;">SGST</th>
                                                                        <th style="text-align: right !important;">CESS</th>
                                                                        <th style="text-align: right !important;">BASIC</th>
                                                                        <th style="text-align: right !important;">TOTAL</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>

                                                                    @php
                                                                        $total_gst_amount = 0;
                                                                        $IGST = $CGST = $SGST = 0;
                                                                    @endphp
                                                                    @foreach($sale_invoice->getSaleInvoiceDetails as $key => $value)
                                                                        <tr>
                                                                            <td>{!! $key + 1 !!}</td>
                                                                            <td>{!! $value->getProduct->name ?? '' !!}</td>
                                                                            <td>{!! $value->getProduct->hsncode ?? '' !!}</td>
                                                                            <td style="text-align: right !important;">
                                                                                {!! isset($value->getProduct->getProductPrice->mrp) ? convertDecimelPoint($value->getProduct->getProductPrice->mrp) : '' !!}</td>
                                                                            <td style="text-align: right !important;">
                                                                                {!! isset($value->main_qty) && $value->main_qty>0 ? convertDecimelPoint($value->main_qty) : 1 !!}
                                                                            </td>
                                                                            <td style="text-align: right !important;">
                                                                                {!! isset($value->discount_amount) ? convertDecimelPoint($value->discount_amount) : '' !!} ({!! $value->discount_percentage ?? '' !!})</td>
                                                                            <td style="text-align: right !important;">
                                                                                {!! convertDecimelPoint($value->basic_amount) !!}</td>
                                                                            @php
                                                                                $gst = $value->getProduct->getTaxMaster->total_percentage ?? 0;
                                                                                $gst_amount = ($gst > 0 ? (($gst / 100) * $value->total_amount) : 00);
                                                                                $total_gst_amount +=$gst_amount
                                                                            @endphp
                                                                            <td style="text-align: right !important;">{!! $gst !!}% ({!! convertDecimelPoint($gst_amount) !!})</td>
                                                                            @php
                                                                                if (isset($value->getProduct->getTaxMaster->getTaxMasterSub)) {
                                                                                    foreach($value->getProduct->getTaxMaster->getTaxMasterSub as $tax) {
                                                                                        if ($tax->name == 'IGST') {
                                                                                            $IGST = $tax->percentage ?? 0;
                                                                                        } else if ($tax->name == 'CGST') {
                                                                                            $CGST = $tax->percentage ?? 0;
                                                                                        } else if ($tax->name == 'SGST') {
                                                                                            $SGST = $tax->percentage ?? 0;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            @endphp
                                                                            <td style="text-align: right !important;">{!! $IGST !!}%</td>
                                                                            <td style="text-align: right !important;">{!! $CGST !!}%</td>
                                                                            <td style="text-align: right !important;">{!! $SGST !!}%</td>
                                                                            <td style="text-align: right !important;">{!! convertDecimelPoint($value->tax_cess_amount) ?? '' !!}</td>
                                                                            <td style="text-align: right !important;">
                                                                                {!! convertDecimelPoint($value->total_amount) ?? '' !!}</td>
                                                                            <td style="text-align: right !important;">
                                                                                {!! convertDecimelPoint($value->total_amount + $gst_amount) ?? '' !!}</td>
                                                                        </tr>
                                                                    @endforeach
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>--}}
                                                    <div class="row mt-n2">
                                                    <x-TransactionSummary :transactionHistory="$transactionHistory"/>
                                                    <div class="col-4">
                                                    </div>
                                                    <x-VoucherSummary :transactionSummery="$transactionSummery"/>
                                                    <x-BillFooter :saleInvoice="$sale_invoice"/>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="text-center">
    <button id="btn_print" type="button" class="btn btn-primary btn-lg"> Print Document <i class="bi bi-printer text-white"></i></button>
</div>
@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            // printInvoice(page_title);
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
</script>
@endsection
