@extends('layouts.app')
@section('title', $accountJournal->voucher_no . ' - '. ($accountJournal->transaction_date ? formatedDate($accountJournal->transaction_date) : '') . ' - ' . ($accountJournal->accountReceiptDetail->account->name ?? ''))
@section('pages')

<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />

@php $pageTitle =  $accountJournal->voucher_no . ' - ' .($accountJournal->accountReceiptDetail->account->name ?? '').'-'. ($accountJournal->transaction_date ?
formatedDate($accountJournal->transaction_date) : '') ; @endphp

<div id="" class="card-header py-3">
  <div class="row gx-2">

    <div class="col-lg-6 col-md-6 col-6">
        <div class="position-relative">
            <h5>{!! $accountJournal->voucherMaster->voucherType->voucher_title ?? 'JOURNAL VOUCHER' !!} | {!! $accountJournal->voucher_no !!}</h5>
        </div>
    </div>
    <div class="col-lg-6 col-md-6">
      <div class="ms-auto float-md-end">
      <div class="btn-group">
            @if(auth()->user()->can('journal-voucher-create'))
              <a href="{{ route('journal-voucher.create') }}" class="btn btn-primary"><i class="bx bx-plus"></i> Add New</a>
            @endif
        </div>
        <div class="btn-group">
            <a href="{{ route('journal-voucher.index') }}" class="btn btn-outline-secondary me-2"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            <!-- <button id="btn_pdf" type="button" class="btn btn-primary btn-lg"> Download PDF <i class="bi bi-download text-white"></i></button> -->
        </div>
        
      </div>
    </div>
  </div>
</div>

<div id="print_div">
    <div class="pathology-bill">
        <div class="row">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                    @php $company = $accountJournal->company; @endphp
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell" style="font-weight: normal;">
                                                <x-CompanyLetterHead :company="$company"/>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tfoot class="report-footer">
                                        <tr>
                                            <td class="report-footer-cell">
                                            </td>
                                        </tr>
                                    </tfoot>

                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell">
                                                <x-VoucherDetails :saleInvoice="$accountJournal" voucherType="JOURNAL" :voucherTitle="$accountJournal->voucherMaster->voucherType->voucher_title"/>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                                            <thead>
                                                                <tr class="text-uppercase">
                                                                    <th style="text-align: left; width: 5%">Sl.No</th>
                                                                    <th style="text-align: left;">Date</th>
                                                                    <th style="text-align: left;">Account</th>
                                                                    <th style="text-align: right;">Debit</th>
                                                                    <th style="text-align: right;">Credit</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                              @php $i = 1; @endphp
                                                              @if(isset($accountJournal->accountJournalTransaction)&&count($accountJournal->accountJournalTransaction)>0)
                                                                @foreach($accountJournal->accountJournalTransaction as $key => $transactions)
                                                                  <tr>
                                                                    <td style="text-align: left;">{{ $i }}</td>
                                                                    <td style="text-align: left;">{{ formatedDate($transactions->transaction_date) }}</td>
                                                                    <td style="text-align: left;">{!! isset($transactions->transaction_type)&&$transactions->transaction_type=='CREDIT' ? "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" : "" !!} {{$transactions->account->name}}</td>
                                                                    <td style="text-align: right;">{{isset($transactions->transaction_type)&&$transactions->transaction_type=='DEBIT' ? convertDecimelPoint($transactions->amount) : "" }}</td>
                                                                    <td style="text-align: right;">{{isset($transactions->transaction_type)&&$transactions->transaction_type=='CREDIT' ? convertDecimelPoint($transactions->amount) : "" }}</td>
                                                                  </tr>
                                                                  @php
                                                                    $i += 1;
                                                                  @endphp
                                                                @endforeach
                                                              @endif
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>

                                    <tfoot class="report-footer">
                                        <tr>
                                            <td class="report-footer-cell">
                                                <div class="row mt-n3">
                                                    <div class="col-6 text-left">
                                                        @if($accountJournal->description != '')
                                                            <p>
                                                                <b>Narration:</b><br>
                                                                {!! $accountJournal->description ?? '' !!}
                                                            </p>
                                                        @endif
                                                        @if(isset($accountJournal->voucherTerm))
                                                            {!! $accountJournal->voucherTerm->terms_and_condition ?? '' !!}
                                                        @endif
                                                        <br>
                                                    </div>
                                                    <div class="col-6 text-right" style="text-align: right;">
                                                        <p>
                                                            <span style="font-size: 16px;text-align: right;">
                                                                <b>{!! $accountJournal->company->name ?? '' !!}</b>
                                                            </span>
                                                            <br> <br>
                                                            Authorized Signatory <br>
                                                            Prepared by: {!! $accountJournal->user->name ?? '' !!}<br>
                                                            <b style="font-size: 10px">Note: Digitally Generated Voucher, Signature Not Required</b>
                                                        </p>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
   
</div>
<div style="width:100%; text-align: center; ">
        <button id="btn_print" type="button" class="btn btn-primary btn-lg"> Print Document <i class="bi bi-printer text-white"></i></button>
</div>
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            // printInvoice(page_title);
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
    </script>
@endsection
