@extends('layouts.app')
@section('title', @$voucher_type->voucher_title .' STATEMENT')
@section('css')
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />
@endsection
@section('pages')
@php $pageTitle=@$voucher_type->voucher_title; @endphp
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> {!! @$voucher_type->voucher_title !!} STATEMENT</div>

    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{ route('journal-voucher.index') }}" class="btn btn-outline-secondary me-2"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="card style_table shadow-none radius-5 min-height">
  <x-FinancialAccounting.StatementSearchForm />  
</div>

<div id="tables">
</div>
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>

<script>
    $(document).ready(function() {

        function fetch_data(branch, account, from_date, to_date,created_by,payment_mode,voucher_type) {
            $('#submit').prop('disabled',true);
            $('#submit').html('Loading Please Wait.');
            $('.print-buttons').hide();
            $.ajax({
                url: "?branch=" + branch + "&account=" + account + "&from_date=" + from_date + "&to_date=" + to_date + "&created_by=" + created_by+"&payment_mode="+payment_mode+"&voucher_type="+voucher_type,
                success: function(data) {
                    $('#tables').html('');
                    $('#tables').html(data);
                    $('#submit').prop('disabled',false);
                    $('#submit').html('<i class="bi bi-search"></i> Search');
                }
            })
        }


        $("body").on("click", '#submit', function(event) {
            var branch = $('#branch').val();
            var account  = $('[name="account"]').val();
            var from_date = $('#from_date').val();
            var to_date = $('#to_date').val();
            var created_by =  $('#created_by').val();
            var payment_mode = $('#payment_mode').val();
            var voucher_type = $('#voucher_type').val();

            fetch_data(branch, account, from_date, to_date, created_by,payment_mode,voucher_type);
        });

        $("body").on("click", '.export-statement', function(event) {
        var branch = $("#branch").val();
        var account  = $('[name="account"]').val();
        var from_date  = $('#from_date').val();
        var to_date   = $('#to_date').val();
        var created_by    = $('#created_by').val();
        var payment_mode = $('#payment_mode').val();
        var voucher_type = $('#voucher_type').val();
        var queryStr = "branch="+branch+"&account="+account+"&from_date="+from_date+"&to_date="+to_date+"&created_by="+created_by+"&payment_mode="+payment_mode+"&voucher_type="+voucher_type+"&type=excel";

        //window.open(url + "?" + queryStr);
        window.location.href="{!! route('journal-voucher-statement-export') !!}?"+queryStr; 
    });


        $('[name="from_date"]').datepicker({
        format: "{!! $companyDateFormate??'dd-mm-yyyy' !!}",
        autoclose: true,
        //startDate: financialYearDates.fromDate,//optional
        //endDate: financialYearDates.toDate//optional
        }).datepicker("setDate", new Date());
    $('[name="to_date"]').datepicker({
    format: "{!! $companyDateFormate??'dd-mm-yyyy' !!}",
    autoclose: true,
    //startDate: financialYearDates.fromDate,//optional
    //endDate: financialYearDates.toDate//optional
    }).datepicker("setDate", new Date());
    })

       
</script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            // printInvoice(page_title);
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
</script>
@endsection