@extends('layouts.app')
@section('title', $voucher_type->name . ' - '. $sale_invoice->main_invoice_no . ' - '. ($sale_invoice->invoice_date ? formatedDate($sale_invoice->invoice_date) : '') . ' - ' . ($sale_invoice->getPatient->name ?? ''))
@section('pages')

<div id="btn_back" class="card-header py-3">
  <div class="row gx-2">
    <div class="col-lg-6 col-md-6 col-6">
        <div class="position-relative">
            <h5>{!! $voucher_type->voucher_title ?? '' !!} | {!! $sale_invoice->main_invoice_no !!}</h5>
        </div>
    </div>
    <div class="col-lg-6 col-md-6">
      <div class="ms-auto float-md-end">
        <div class="btn-group">
            <a href="{{ route('lab-billings.index') }}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
      </div>
    </div>
  </div>
</div>

<div id="print_div">
    @include('invoice-formats.partials.style')
    <div>
        <div class="row">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                    @php $company = @$sale_invoice->getCompany; @endphp

                                    @include('invoice-formats.partials.header-company')

                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell">
                                                <div class="row border border-dark border-bottom-0 text-uppercase" style="padding-top: 2px; padding-bottom: 2px;margin-right:0px;margin-left:0px;">
                                                    <div class="col-4 font-12" style="text-align: left;"><b>Invoice No :  {!! $sale_invoice->main_invoice_no ?? '' !!}</b></div>
                                                    <div class="col-4 text-center font-12"><b>Date  : {!! $sale_invoice->invoice_date ? formatedDate($sale_invoice->invoice_date) : '' !!}</b></div>
                                                    <div class="col-4 text-center font-12"><b>Reff No. : {!! $sale_invoice->reff_no ?? '' !!}</b></div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <table class="table table-borderless table-sm mb-1" id="account_to">
                                                            <tbody>
                                                                <tr>
                                                                    @php
                                                                        $date_of_birth = $sale_invoice->getPatient->account_contact->date_of_birth ?? '';
                                                                        $age           = $date_of_birth != '' ? age($sale_invoice->getPatient->account_contact->date_of_birth) : 0;
                                                                    @endphp
                                                                    <td>
                                                                        <div class="row border border-dark" style="padding-top: 2px; padding-bottom: 0px;line-height:1.2; margin-right:0px;margin-left:0px">
                                                                            <div class="col-8 border-right border-dark" style="font-size:12px;">

                                                                                <table class="table table-borderless mb-1 w-100">
                                                                                    <tbody>
                                                                                        <tr class="font-weight-bold">
                                                                                             <td style="text-align: left;">Patient Details</td>
                                                                                            <td>:</td>
                                                                                            <td colspan="3" style="text-align: left; padding-left: 2px">
                                                                                                {!! $sale_invoice->getPatient->name ?? '' !!}
                                                                                                @if($sale_invoice->getPatient->primary_account != '1')
                                                                                                    ({!! $sale_invoice->getPatient->code ?? '' !!})
                                                                                                @endif
                                                                                            </td>
                                                                                        </tr>
                                                                                        @php
                                                                                            $gender      = $sale_invoice->getPatient->account_contact->gender->name ?? '';
                                                                                            $state       = $sale_invoice->getPatient->first_account_address->state->name ?? '';
                                                                                            $city        = $sale_invoice->getPatient->first_account_address->city->name ?? '';
                                                                                            $country     = $sale_invoice->getPatient->first_account_address->country->name ?? '';
                                                                                            $whatsapp_no = $sale_invoice->getPatient->account_contact->whatsapp_no ?? '';
                                                                                        @endphp
                                                                                        @if($gender != '')
                                                                                            <tr>
                                                                                                <td style="text-align: left;">Gender</td>
                                                                                                <td>:</td>
                                                                                                <td style="text-align: left; padding-left: 2px">{!! $gender ?? '' !!}
                                                                                                    @if($age > 0)
                                                                                                        , Age : {!! $age !!} Years
                                                                                                    @endif
                                                                                                </td>
                                                                                            </tr>
                                                                                        @endif
                                                                                        @foreach(accountLicenses($paymentVoucher->paymentVoucherDetail->account->id) as $value)
                                                                                            <tr>
                                                                                                <td style="text-align: left;">{!! $value->name !!}</td>
                                                                                                <td>:</td>
                                                                                                <td style="text-align: left; padding-left: 2px">{!! $value->license_number !!}</td>
                                                                                            </tr>
                                                                                        @endforeach
                                                                                        <tr>
                                                                                            <td style="text-align: left;">Address</td>
                                                                                            <td>:</td>
                                                                                            <td style="text-align: left; padding-left: 2px">{!! $sale_invoice->getPatient->first_account_address->address_line1 ?? '' !!}{!! $city != '' ? ', '.$city : '' !!}{!! $state != '' ? ', '.$state : '' !!}{!! $country != '' ? ', '.$country : '' !!}</td>
                                                                                        </tr>
                                                                                        <tr class="font-weight-bold">
                                                                                             <td style="text-align: left;">Phone No</td>
                                                                                            <td>:</td>
                                                                                            <td colspan="3" style="text-align: left; padding-left: 2px"> {!! $sale_invoice->getPatient->account_contact->phone_no ?? '' !!} @if($whatsapp_no != '') WhatsApp : {!! $whatsapp_no !!} @endif</td>
                                                                                        </tr>
                                                                                        <tr class="font-weight-bold">
                                                                                             <td style="text-align: left;">Email</td>
                                                                                            <td>:</td>
                                                                                            <td colspan="3" style="text-align: left; padding-left: 2px"> {!! $sale_invoice->getPatient->account_contact->email ?? '' !!}</td>
                                                                                        </tr>
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                            <div class="col-4 border-right border-dark" style=" font-size:12px; margin-top: 10px; display: flex; justify-content: flex-end;">
                                                                                <div style="text-align: center;">
                                                                                @php
                                                                                    $generatorPNG = new Picqer\Barcode\BarcodeGeneratorPNG();
                                                                                @endphp
                                                                                <img class="barcodeStyle" src="data:image/png;base64,{{ base64_encode($generatorPNG->getBarcode($sale_invoice->main_invoice_no ?? '', $generatorPNG::TYPE_CODE_128)) }}" height="120" width="200">
                                                                                <br>
                                                                                <h6><b>{!! $sale_invoice->main_invoice_no ?? '' !!}</b></h6></div>
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="row mt-n3">
                                                    <div class="col-12 text-center">
                                                        <h4 class="text-bold my-auto">{!! $voucher_type->voucher_title ?? '' !!}
                                                        </h4>
                                                    </div>
                                                </div>
                                                                                    
                                                <div class="row">
                                                    <div class="col-12">
                                                        <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                                            <thead>
                                                                <tr class="text-uppercase">
                                                                    <th style="text-align: left;">Sl.No</th>
                                                                    <th style="text-align: left;">ITEM NAME & DETAILS </th>
                                                                    @if($voucher_type && $voucher_type->tax_applicable == '1')
                                                                    <th style="text-align: left;">HSN/SAC</th>
                                                                    @endif
                                                                    <th style="text-align: right;">MRP</th>
                                                                    <th style="text-align: left;">QTY</th>
                                                                    <th style="text-align: left;">Dis(%)</th>
                                                                    <th style="text-align: right;">PRICE</th>
                                                                    @if(isset($voucher_type) && $voucher_type->tax_applicable == '1')
                                                                        <th style="text-align: right;">GST%</th>
                                                                        <th style="text-align: right;">IGST</th>
                                                                        <th style="text-align: right;">CGST</th>
                                                                        <th style="text-align: right;">SGST</th>
                                                                        <th style="text-align: right;">CESS</th>
                                                                        <th style="text-align: right;">BASIC</th>
                                                                    @endif
                                                                    <th style="text-align: right;">TOTAL</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @php
                                                                    $total_gst_amount = 0;
                                                                    $IGST = $CGST = $SGST = 0;
                                                                @endphp
                                                                @foreach($sale_invoice->getSaleInvoiceDetails as $key => $value)
                                                                    <tr>
                                                                        <td>{!! $key + 1 !!}</td>
                                                                        <td>{!! $value->getProduct->name ?? '' !!}</td>
                                                                        @if($voucher_type && $voucher_type->tax_applicable == '1')
                                                                        <td>{!! $value->getProduct->hsncode ?? '' !!}</td>
                                                                        @endif
                                                                        <td style="text-align: right !important;">
                                                                            {!! isset($value->getProduct->getProductPrice->mrp) ? convertDecimelPoint($value->getProduct->getProductPrice->mrp) : '' !!}</td>
                                                                        <td style="text-align: right !important;">
                                                                            {!! isset($value->main_qty) ? convertDecimelPoint($value->main_qty) : '' !!}
                                                                        </td>
                                                                        <td style="text-align: right !important;">
                                                                            {!! isset($value->discount_amount) ? convertDecimelPoint($value->discount_amount) : '' !!} ({!! $value->discount_percentage ?? '' !!})</td>
                                                                        <td style="text-align: right !important;">
                                                                            {!! convertDecimelPoint($value->basic_amount) !!}</td>
                                                                        @php
                                                                            $gst = $value->getProduct->getTaxMaster->total_percentage ?? 0;
                                                                            $gst_amount = ($gst > 0 ? (($gst / 100) * $value->total_amount) : 00);
                                                                            $total_gst_amount +=$gst_amount
                                                                        @endphp
                                                                        @if($voucher_type && $voucher_type->tax_applicable == '1')
                                                                        <td style="text-align: right !important;">{!! $gst !!}% ({!! convertDecimelPoint($gst_amount) !!})</td>
                                                                        @php
                                                                            if (isset($value->getProduct->getTaxMaster->getTaxMasterSub)) {
                                                                                foreach($value->getProduct->getTaxMaster->getTaxMasterSub as $tax) {
                                                                                    if ($tax->name == 'IGST') {
                                                                                        $IGST = $tax->percentage ?? 0;
                                                                                    } else if ($tax->name == 'CGST') {
                                                                                        $CGST = $tax->percentage ?? 0;
                                                                                    } else if ($tax->name == 'SGST') {
                                                                                        $SGST = $tax->percentage ?? 0;
                                                                                    }
                                                                                }
                                                                            }
                                                                        @endphp
                                                                        <td style="text-align: right !important;">{!! $IGST !!}%</td>
                                                                        <td style="text-align: right !important;">{!! $CGST !!}%</td>
                                                                        <td style="text-align: right !important;">{!! $SGST !!}%</td>
                                                                        <td style="text-align: right !important;">{!! convertDecimelPoint($value->tax_cess_amount) ?? '' !!}</td>
                                                                        <td style="text-align: right !important;">
                                                                            {!! convertDecimelPoint($value->total_amount) ?? '' !!}</td>
                                                                        @endif
                                                                        <td style="text-align: right !important;">
                                                                            {!! convertDecimelPoint($value->total_amount + $gst_amount) ?? '' !!}</td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="row mt-n2">
                                                    <div class="col-4">
                                                        <table class="table tr" id="bank_details">
                                                            <tbody>
                                                                <tr>
                                                                    <td colspan="2"><b>BANK DETAILS</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>ACCOUNT NAME</td>
                                                                    <td style="text-align: right !important;">{!! $sale_invoice->getCompany->getCompanybank->account_holder_name ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>ACCOUNT NUMBER</td>
                                                                    <td style="text-align: right !important;">{!! $sale_invoice->getCompany->getCompanybank->account_number ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>IFSC</td>
                                                                    <td style="text-align: right !important;">{!! $sale_invoice->getCompany->getCompanybank->ifsc_code ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>BANK NAME</td>
                                                                    <td style="text-align: right !important;">{!! $sale_invoice->getCompany->getCompanybank->bank_name ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>BRANCH NAME</td>
                                                                    <td style="text-align: right !important;">{!! $sale_invoice->getCompany->getCompanybank->bank_branch ?? '' !!}</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <div class="col-4">
                                                        <table class="table tr" id="bank_details">
                                                            <tbody>
                                                                <tr>
                                                                    <td colspan="2"><b>PAYMENT SUMMARY</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>TOTAL BILLING AMOUNT</td>
                                                                    <td style="text-align: right !important;">{!! isset($sale_invoice->billing_amount) ? convertDecimelPoint($sale_invoice->billing_amount) : '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>TOTAL RECEIVED AMOUNT</td>
                                                                    <td style="text-align: right !important;">{!! isset($sale_invoice->received_amount) ? convertDecimelPoint($sale_invoice->received_amount) : '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>SPECIAL DISCOUNT</td>
                                                                    <td style="text-align: right !important;">{!! isset($sale_invoice->discount_amount) ? convertDecimelPoint($sale_invoice->discount_amount) : '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>BALANCE</td>
                                                                    <td style="text-align: right !important;">{!! isset($sale_invoice->due_amount) ? convertDecimelPoint($sale_invoice->due_amount) : '' !!}</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    <div class="col-4">
                                                        <table class="table tr" id="bank_details">
                                                            <tbody>
                                                                <tr>
                                                                    <td colspan="2"><b>BILLING SUMMARY</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>BASIC AMOUNT</td>
                                                                    <td style="text-align: right !important;">{!! isset($sale_invoice->billing_amount) ? convertDecimelPoint($sale_invoice->billing_amount) : '' !!}</td>
                                                                </tr>
                                                                @php
                                                                    $gst_amount = $gst_amount ?? 0;
                                                                @endphp
                                                                <tr>
                                                                    <td>TOTAL TAX</td>
                                                                    <td style="text-align: right !important;">{!! convertDecimelPoint($gst_amount) ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td><b>SUBTOTAL</b></td>
                                                                    <td style="text-align: right !important;">{!! convertDecimelPoint($sale_invoice->billing_amount + $gst_amount) ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td>SPECIAL DISCOUNT</td>
                                                                    <td style="text-align: right !important;">{!! convertDecimelPoint($sale_invoice->discount_amount) ?? '' !!}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td><b>GRAND TOTAL</b></td>
                                                                    @php
                                                                        $grand_total = $sale_invoice->billing_amount + $gst_amount - $sale_invoice->discount_amount ?? 0;
                                                                    @endphp
                                                                    <td style="text-align: right !important;"><b>{!! convertDecimelPoint($grand_total) !!}</b></td>
                                                                </tr>
                                                                <tr>
                                                                    <td colspan="2">
                                                                        <sub>Amount (in words) : {!! convertAmountToWords($grand_total) !!}</sub></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>

                                    <tfoot class="report-footer">
                                        <tr>
                                            <td class="report-footer-cell">
                                                <div class="row mt-n3">
                                                    <div class="col-6 text-left">
                                                        <p>Amount (in words) : {!! convertAmountToWords($grand_total) !!}</p>
                                                        @if(isset($paymentVoucher->paymentVoucherDetail->voucherTerm))
                                                            {!! $paymentVoucher->paymentVoucherDetail->voucherTerm->terms_and_condition ?? '' !!}
                                                        @endif
                                                        <br>
                                                    </div>
                                                    <div class="col-6 text-right" style="text-align: right;">
                                                        <p>
                                                            <span style="font-size: 16px;text-align: right;">
                                                                <b>{!! $sale_invoice->getCompany->name ?? '' !!}</b>
                                                            </span>
                                                            <br> <br>
                                                            Authorised Signatory <br>
                                                            <b style="font-size: 10px">Note: Digitally Generated Invoice, Signature Not Required</b>
                                                        </p>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div style="width:100%; text-align: center; ">
        <button id="btn_print" type="button" class="btn btn-primary btn-lg"> Print Document <i class="bi bi-printer text-white"></i></button>
    </div>
</div>
@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click','#btn_print',function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click','#btn_pdf',function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });
</script>
@endsection