@extends('layouts.app')
@section('title', $voucher_type->name . ' - '. $sale_invoice->booking_no . ' - '. ($sale_invoice->booking_date_time ? formatedDate($sale_invoice->booking_date_time) : '') . ' - ' . ($sale_invoice->getPatient->name ?? ''))
@section('pages')
<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />

@php $pageTitle =  $sale_invoice->booking_no . ' - ' .($sale_invoice->getPatient->name ?? '').'-'. ($sale_invoice->booking_date_time ?
formatedDate($sale_invoice->booking_date_time) : '') ; @endphp

<div class="card-header py-3">
    <div class="row gx-2">
        <div class="col-lg-6 col-md-6 col-6">
            <div class="position-relative">
                <h5>{!! $voucher_type->voucher_title ?? '' !!} | {!! $sale_invoice->booking_no !!}</h5>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="ms-auto float-md-end">
                <div class="btn-group">
                    {{--<a href="{{ route('opd-bookings.patient-head-print',$sale_invoice->id) }}" class="btn btn-outline-info me-1"><i class="bi bi-printer ms-0 me-1"></i>Print Letter Head</a>--}}
                    <a href="{{ route('opd-bookings.prescription-print',$sale_invoice->id) }}" class="btn btn-primary me-1"><i class="bi bi-eye ms-0 me-1"></i> View Prescription</a>
                    <a href="{{ route('opd-appointment.index') }}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="print_div">
    <div class="pathology-bill">
        <div class="row">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                @php $company = @$sale_invoice->getCompany;@endphp
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell" style="font-weight: normal;">
                                                
                                                @if(
                                                request()->segment(2) != 'prescription-print'
                                                )
                                                <div class="row mb-1">
                                                    <div class="col-12 text-center">
                                                        <span class="text-bold my-auto font-14">{!! $voucher_type->page_title ?? '' !!}
                                                        </span>
                                                    </div>
                                                </div>
                                                @endif
                                                <x-CompanyLetterHead :company="$company" :letterHead="$letter_heads" />
                                                <x-VoucherDetails :saleInvoice="$sale_invoice" voucherType="OPD_BOOKING" :voucherTitle="$voucher_type->voucher_title" />
                                            </th>
                                        </tr>
                                    </thead>
                                    <tfoot class="report-footer">
                                        <tr>
                                            <td class="report-footer-cell">
                                            </td>
                                        </tr>
                                    </tfoot>

                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell">
                                                <x-OPDItemDetails :saleInvoice="$sale_invoice" :voucherTypeDetails="$voucher_type"/>
                                                <div class="row mt-n2">
                                                    <div class="col-4">
                                                        <x-TransactionSummary :transactionSummery="$transactionSummery" :transactionHistory="$transactionHistory" />
                                                    </div>
                                                    <div class="col-4">

                                                    </div>
                                                    <x-VoucherSummary :transactionSummery="$transactionSummery"/>
                                                    <x-BillFooter :saleInvoice="$sale_invoice"/>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
</div>
<div style="width:100%; text-align: center; ">
    <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Appointment Slip </button>
</div>
@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            // printInvoice(page_title);
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
</script>
@endsection