@extends('layouts.app')
@section('title', 'Patient Head-'. $sale_invoice->booking_no .'-'. ($sale_invoice->booking_date_time ? formatedDate($sale_invoice->booking_date_time) : '') . '-' . ($sale_invoice->getPatient->name ?? ''))
@section('pages')

<div class="card-header py-3">
    <div class="row gx-2">
        <div class="col-lg-6 col-md-6 col-6">
            <div class="position-relative">
                <h5>{!! $voucher_type->voucher_title ?? '' !!} | {!! $sale_invoice->booking_no !!}</h5>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="ms-auto float-md-end">
                <div class="btn-group">
                    <a href="javascript:history.back()" class="btn btn-primary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="print_div">
    @include('invoice-formats.partials.style')
    @php
    $date_of_birth = $sale_invoice->getPatient->account_contact->date_of_birth ?? '';
    $age = $date_of_birth != '' ? age($sale_invoice->getPatient->account_contact->date_of_birth) : 0;
    @endphp
    <div style="background-color: #fff;height:1078px">
        <div class="card-header py-3">
            <div class="row gx-2" style="margin-top: 110px; margin-left: -25px;";>
                <div class="row py-1 m-0">
                    <div class="col-6 row border-right border-dark">
                        <table>
                            <tbody>
                                <tr style="font-size:16px;">
                                    <td>Patient Name </td>
                                    <td>: <b>{!! ucfirst($sale_invoice->getPatient->name) ?? '' !!} </b></td>
                                </tr>
                                @if(isset($sale_invoice->getPatient->unique_register_no))
                                <tr>
                                    <td style="text-align: left;">ABHA No/UHID</td>
                                    <td style="text-align: left;">: <b>{!! $sale_invoice->getPatient->unique_register_no ?? '' !!}</b></td>
                                </tr>
                                @endif
                                <tr>
                                    <td>Sex/Age </td>
                                    <td>: <b>{!! $sale_invoice->getPatient->account_contact->gender->name ?? '' !!}
                                            @if($age > 0)
                                            , Age : {!! $age !!} Years
                                            @endif</b></td>
                                </tr>

                                <tr>
                                    <td>Booking ID </td>
                                    <td>: <b>{!! $sale_invoice->booking_no ?? '' !!}</b></td>
                                </tr>
                                
                                <tr>
                                    <td>Appointment Date </td>
                                    <td>: <b>{!! ($sale_invoice->appointment_date_time ? formatedDate($sale_invoice->appointment_date_time) : '') !!}  |  Time:  {!! ($sale_invoice->appointment_date_time ? date('h:i A',strtotime($sale_invoice->appointment_date_time)) : '') !!}</b></td>
                                </tr>
                                <tr>
                                    <td>Serial No </td>
                                    <td>: <b>[{!! $sale_invoice->appointment_serial_no ?? '' !!}]</b></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-3 row">
                        <table>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                    <div class="col-2 text-center pt-1" style="width:auto !important;">
                        <div class="mt-2 float-center" style="">
                          
                        </div>
                    </div>
                </div>
            </div>
			<div class="row py-1 m-0" >
				<div class="col-10">
				</div>
				<div class="col-2" style="margin-top: -15px;">
				
			  @php
                            $generatorPNG = new Picqer\Barcode\BarcodeGeneratorPNG();
                            @endphp
                            <img class="barcodeStyle" src="data:image/png;base64,{{ base64_encode($generatorPNG->getBarcode($sale_invoice->booking_no ?? '', $generatorPNG::TYPE_CODE_128)) }}" height="120" width="200">
                            <h5>{!! $sale_invoice->booking_no ?? '' !!}</h5>
					</div>
			</div>	
				
				
        </div>
        <div style="width:100%; text-align: center; " class="mt-3">
        <button id="btn_print" type="button" class="btn btn-primary btn-lg"> Print Document <i class="bi bi-printer text-white"></i></button>
    </div>
    </div>
    
</div>
@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });
</script>
@endsection