@extends('layouts.app')
@section('title', 'Prescription')
@section('pages')
<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />
@php $pageTitle =  $sale_invoice->booking_no . ' - ' .($sale_invoice->getPatient->name ?? '').'-'. ($sale_invoice->booking_date_time ?
formatedDate($sale_invoice->booking_date_time) : '') ; @endphp
<style>

</style>
<div class="card-header py-3">
    <div class="row gx-2">
        <div class="col-lg-6 col-md-6 col-6">
            <div class="position-relative">
                <h5>Prescription | {!! $sale_invoice->booking_no !!}</h5>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="ms-auto float-md-end">
                <div class="btn-group">
                    <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Prescription </button>
                    &nbsp;
                    &nbsp;
                    {{--<a href="{{ route('opd-bookings.patient-head-print',$sale_invoice->id) }}" class="btn btn-outline-info me-1"><i class="bi bi-printer ms-0 me-1"></i>Print Letter Head</a>--}}
                    <a href="{!! route('opd-appointment.index') !!}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="print_div">
    <div class="pathology-bill">
        <div class="row">
            <div class="col-md-12 col-xs-12">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                    @if(empty($prescriptionImageHeader))
                                    @php $company = @$sale_invoice->getCompany; @endphp
                                     <x-CompanyLetterHead :company="$company"/>
                                    @else
                                   
                                    @if($prescriptionImageHeader->position=='Header')
                                    <style type="text/css">
                                    .prescription_letter_head {
                                        height: {!! $prescriptionImageHeader->height ?? '' !!}px !important;
                                        width: {!! $prescriptionImageHeader->width ?? '' !!}px !important;
                                        {!! isset($prescriptionImageHeader->top_margin) && $prescriptionImageHeader->top_margin != '' ? 'margin-top:' . $prescriptionImageHeader->top_margin . 'px;' : '' !!}
                                        {!! isset($prescriptionImageHeader->bottom_margin) && $prescriptionImageHeader->bottom_margin != '' ? 'margin-bottom:' . $prescriptionImageHeader->bottom_margin . 'px;' : '' !!}
                                        {!! isset($prescriptionImageHeader->left_margin) && $prescriptionImageHeader->left_margin != '' ? 'margin-left:' . $prescriptionImageHeader->left_margin . 'px;' : '' !!}
                                        {!! isset($prescriptionImageHeader->right_margin) && $prescriptionImageHeader->right_margin != '' ? 'margin-right:' . $prescriptionImageHeader->right_margin . 'px;' : '' !!}
                                        {!! isset($prescriptionImageHeader->top_padding) && $prescriptionImageHeader->top_padding != '' ? 'padding-top:' . $prescriptionImageHeader->top_padding . 'px;' : '' !!}
                                        {!! isset($prescriptionImageHeader->bottom_padding) && $prescriptionImageHeader->bottom_padding != '' ? 'padding-bottom:' . $prescriptionImageHeader->bottom_padding . 'px;' : '' !!}
                                        {!! isset($prescriptionImageHeader->left_padding) && $prescriptionImageHeader->left_padding != '' ? 'padding-left:' . $prescriptionImageHeader->left_padding . 'px;' : '' !!}
                                        {!! isset($prescriptionImageHeader->right_padding) && $prescriptionImageHeader->right_padding != '' ? 'padding-right:' . $prescriptionImageHeader->right_padding . 'px;' : '' !!}
                                    }
                                </style>
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell" style="font-weight: normal;">
                                                <div class="row" id="header" style="width:100%;border: ; padding:0 0 0 0;">
                                                    <div class="col-12 letter-head-company-details" style="line-height: 1.2;padding-bottom:5px;text-align: left;margin-left: 14px;">
                                                        <img src="{!! getTempUrl($prescriptionImageHeader->image_url) !!}" class="img-thumbnail border-0 prescription_letter_head" style="max-height: 100%;">
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                    </thead>
                                    @endif
                                   
                                    @endif
                                    @foreach($prescriptionImage as $row)
                                    @if($row->position=='Watermark')
                                    @php $wetermarkImage = $row->image_url; @endphp
                                    @endif
                                    @endforeach
                                    @php $footerImage = '';@endphp
                                    @foreach($prescriptionImage as $row)
                                    @if($row->position=='Footer' && !isset($prescriptionImageHeader))
                                    @php $footerImage="Yes"; @endphp
                                    @endif
                                    @endforeach

                                    @php $leftSideImage = ''; @endphp
                                    @foreach($prescriptionImage as $row)
                                    @if($row->position=='Left Side Image')
                                    @php $leftSideImage=$row->image_url; @endphp
                                    <style type="text/css">
                                    .prescription_left_side_image {
                                        height: {!! $row->height ?? '' !!}px !important;
                                        width: {!! $row->width ?? '' !!}px !important;
                                        {!! isset($row->top_margin) && $row->top_margin != '' ? 'margin-top:' . $row->top_margin . 'px;' : '' !!}
                                        {!! isset($row->bottom_margin) && $row->bottom_margin != '' ? 'margin-bottom:' . $row->bottom_margin . 'px;' : '' !!}
                                        {!! isset($row->left_margin) && $row->left_margin != '' ? 'margin-left:' . $row->left_margin . 'px;' : '' !!}
                                        {!! isset($row->right_margin) && $row->right_margin != '' ? 'margin-right:' . $row->right_margin . 'px;' : '' !!}
                                        {!! isset($row->top_padding) && $row->top_padding != '' ? 'padding-top:' . $row->top_padding . 'px;' : '' !!}
                                        {!! isset($row->bottom_padding) && $row->bottom_padding != '' ? 'padding-bottom:' . $row->bottom_padding . 'px;' : '' !!}
                                        {!! isset($row->left_padding) && $row->left_padding != '' ? 'padding-left:' . $row->left_padding . 'px;' : '' !!}
                                        {!! isset($row->right_padding) && $row->right_padding != '' ? 'padding-right:' . $row->right_padding . 'px;' : '' !!}
                                    }
                                </style>
                                    @endif
                                    @endforeach
                                    <tbody class="report-content mt-n3">
                                        <tr>
                                            <td class="report-content-cell">
                                             <x-VoucherDetails :saleInvoice="$sale_invoice" voucherType="OPD_BOOKING" :voucherTitle="$voucher_type->voucher_title"/>

                                                <div class="row mt-n3">
                                                    <div class="col-12">
                                                        <table class="table borderless" id="quotation_products" style="height: {!! $footerImage=='Yes'?'770px;':'730px' !!};border:1px solid #fff">
                                                        <thead>
                                                            <th style="width: 40%;border:1px solid #aaa;"></th>
                                                            <th style="width: 60%;border:1px solid #aaa;"></th>
                                                        </thead>
                                                        <tbody style="background-image: url('{!! isset($wetermarkImage)?getTempUrl($wetermarkImage):'' !!}'); 
                                                                    background-repeat: no-repeat, repeat;
                                                                    background-position: center;
                                                                    background-size: cover;
                                                                    border-bottom:1px solid #aaa">
                                                            <tr>
                                                                <td style="border-left: 1px solid #aaa;border-right: 1px solid #aaa;border-bottom: none;">
                                                                <div class="col-12 font-12" style="text-align: left;"><b><u>Clinical History :</u></b>
                                                                <br>
                                                                <img src="{!! isset($leftSideImage)?getTempUrl($leftSideImage):'' !!}" class="prescription_left_side_image" style="width: 300px;">

                                                                </div>
                                                            </td>
                                                                <td style="border-right: 1px solid #aaa;border-bottom: none;">
                                                                <div class="col-12 font-12" style="text-align: left;"><b>Rx.</b></div>
                                                            </td>
                                                            </tr>
                                                           

                                                        </tbody>
                                                            
                                                        @foreach($prescriptionImage as $row)
                                                        @if($row->position=='Footer')
                                                        <style type="text/css">
                                                            .company_footer_image {
                                                                height: {!! $row->height ?? '' !!}px !important;
                                                                width: {!! $row->width ?? '' !!}px !important;
                                                                {!! isset($row->top_margin) && $row->top_margin != '' ? 'margin-top:' . $row->top_margin . 'px;' : '' !!}
                                                                {!! isset($row->bottom_margin) && $row->bottom_margin != '' ? 'margin-bottom:' . $row->bottom_margin . 'px;' : '' !!}
                                                                {!! isset($row->left_margin) && $row->left_margin != '' ? 'margin-left:' . $row->left_margin . 'px;' : '' !!}
                                                                {!! isset($row->right_margin) && $row->right_margin != '' ? 'margin-right:' . $row->right_margin . 'px;' : '' !!}
                                                                {!! isset($row->top_padding) && $row->top_padding != '' ? 'padding-top:' . $row->top_padding . 'px;' : '' !!}
                                                                {!! isset($row->bottom_padding) && $row->bottom_padding != '' ? 'padding-bottom:' . $row->bottom_padding . 'px;' : '' !!}
                                                                {!! isset($row->left_padding) && $row->left_padding != '' ? 'padding-left:' . $row->left_padding . 'px;' : '' !!}
                                                                {!! isset($row->right_padding) && $row->right_padding != '' ? 'padding-right:' . $row->right_padding . 'px;' : '' !!}
                                                            }
                                                        </style>
                                                        <tfoot class="report-footer">
                                                            <tr>
                                                                <td class="report-footer-cell" colspan="2" style="font-weight: normal;">
                                                                    <div class="row" id="footer" style="width:100%; padding:0 0 0 0;">
                                                                        <div class="col-12 letter-head-company-details" style="line-height: 1.2;text-align: left;margin-left: 14px;">
                                                                            <img src="{!! getTempUrl($row->image_url) !!}" class="img-thumbnail border-0 company_footer_image" style="max-height: 100%;">
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        </tfoot>
                                                        @endif
                                                        @endforeach
                                                        </table>
                                                    </div>
                                                </div>

                                            </td>
                                        </tr>
                                    </tbody>
                                    
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- <div style="width:100%; text-align: center; bottom:20px;position:fixed; bottom:50;">
    <button id="btn_print" type="button" class="btn btn-primary btn-lg"> Print Document <i class="bi bi-printer text-white"></i></button>
</div> -->

@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            // printInvoice(page_title);
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
</script>
@endsection