@extends('layouts.app')
@section('title', $paymentVoucher->receipt_no . ' - '. ($paymentVoucher->receipt_date ? formatedDate($paymentVoucher->receipt_date) : '') . ' - ' . ($paymentVoucher->paymentVoucherDetail->account->name?? ''))
@section('pages')
<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />

@php $pageTitle =  $paymentVoucher->receipt_no . ' - ' .($paymentVoucher->paymentVoucherDetail->account->name ?? '').'-'. ($paymentVoucher->receipt_date ?
formatedDate($paymentVoucher->receipt_date) : '') ; @endphp

<div id="" class="card-header py-3">
  <div class="row gx-2">
    <div class="col-lg-6 col-md-6 col-6">
        <div class="position-relative">
            <h5>{!! $paymentVoucher->paymentVoucherDetail->voucherType->voucher_title ?? 'Payment Voucher' !!} | {!! $paymentVoucher->receipt_no !!}</h5>
        </div>
    </div>
    <div class="col-lg-6 col-md-6">
      <div class="ms-auto float-md-end">
      <div class="btn-group">
            @if(auth()->user()->can('payment-voucher-create'))
                <a href="{{ route('payment-voucher.create') }}" class="btn btn-primary"><i class="bx bx-plus"></i> Add New</a>
            @endif
        </div>
        <div class="btn-group">
            <a href="{{ route('payment-voucher.index') }}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
        
      </div>
    </div>
  </div>
</div>

<div id="print_div">
    <div class="pathology-bill">
        <div class="row">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                    @php $company = @$paymentVoucher->company; @endphp
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell" style="font-weight: normal;">
                                                <x-CompanyLetterHead :company="$company"/>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tfoot class="report-footer">
                                        <tr>
                                            <td class="report-footer-cell">
                                            </td>
                                        </tr>
                                    </tfoot>

                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell">
                                                <div class="row border border-dark border-bottom-0 text-uppercase info-table" style="padding-top: 2px; padding-bottom: 2px;margin-right:0px;margin-left:0px;">
                                                    <div class="col-4 font-12" style="text-align: left;"><b>Voucher No : {!! $paymentVoucher->receipt_no ?? '' !!}</b></div>
                                                    <div class="col-4"></div><div class="col-4 font-12" style="text-align:right"><b>Date  : {!! $paymentVoucher->receipt_date ? formatedDate($paymentVoucher->receipt_date) : '' !!}</b></div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <table class="table table-borderless table-sm mb-1" id="account_to">
                                                            <tbody>
                                                                <tr>
                                                                    @php
                                                                        $date_of_birth = $paymentVoucher->paymentVoucherDetail->account->account_contact->date_of_birth ?? '';
                                                                        $age           = $date_of_birth != '' ? age($date_of_birth) : 0;
                                                                    @endphp
                                                                    <td>
                                                                        <div class="row border border-dark" style="padding-top: 2px; padding-bottom: 0px;line-height:1.2; margin-right:0px;margin-left:0px">
                                                                            <div class="col-8 border-right border-dark" style="font-size:12px;">

                                                                                <table class="table table-borderless mb-1 w-100">
                                                                                    <tbody>
                                                                                        <tr class="font-weight-bold">
                                                                                             <td style="text-align: left;">Paid to</td>
                                                                                            <td>:</td>
                                                                                            <td colspan="3" style="text-align: left; padding-left: 2px">
                                                                                                {!! $paymentVoucher->paymentVoucherDetail->account->name ?? '' !!}
                                                                                                @if($paymentVoucher->paymentVoucherDetail->account->primary_account != '1')
                                                                                                    ({!! $paymentVoucher->paymentVoucherDetail->account->code ?? '' !!})
                                                                                                @endif
                                                                                            </td>
                                                                                        </tr>
                                                                                            @php $gender      = $paymentVoucher->paymentVoucherDetail->account->account_contact->gender->name ?? ''; @endphp
                                                                                            @php $state       = $paymentVoucher->paymentVoucherDetail->account->first_account_address->state->name ?? ''; @endphp
                                                                                            @php $city        = $paymentVoucher->paymentVoucherDetail->account->first_account_address->city->name ?? ''; @endphp
                                                                                            @php $country     = $paymentVoucher->paymentVoucherDetail->account->first_account_address->country->name ?? ''; @endphp
                                                                                            @php $whatsapp_no = $paymentVoucher->paymentVoucherDetail->account->account_contact->whatsapp_no ?? ''; @endphp
                                                                                        @if($gender != '')
                                                                                            <tr>
                                                                                                <td style="text-align: left;">Gender</td>
                                                                                                <td>:</td>
                                                                                                <td style="text-align: left; padding-left: 2px">{!! $gender ?? '' !!}
                                                                                                    @if($age > 0)
                                                                                                        , Age : {!! $age !!} Years
                                                                                                    @endif
                                                                                                </td>
                                                                                            </tr>
                                                                                        @endif
                                                                                        @foreach(accountLicenses($paymentVoucher->paymentVoucherDetail->account->id) as $value)
                                                                                            <tr>
                                                                                                <td style="text-align: left;">{!! $value->name !!}</td>
                                                                                                <td>:</td>
                                                                                                <td style="text-align: left; padding-left: 2px">{!! $value->license_number !!}</td>
                                                                                            </tr>
                                                                                        @endforeach
                                                                                        <tr>
                                                                                            <td style="text-align: left;">Address</td>
                                                                                            <td>:</td>
                                                                                            <td style="text-align: left; padding-left: 2px">{!! $paymentVoucher->paymentVoucherDetail->account->first_account_address->address_line1 ?? '' !!}{!! $city != '' ? ', '.$city : '' !!}{!! $state != '' ? ', '.$state : '' !!}{!! $country != '' ? ', '.$country : '' !!}</td>
                                                                                        </tr>
                                                                                        <tr class="font-weight-bold">
                                                                                             <td style="text-align: left;">Phone No</td>
                                                                                            <td>:</td>
                                                                                            <td colspan="3" style="text-align: left; padding-left: 2px"> {!! $paymentVoucher->paymentVoucherDetail->account->account_contact->phone_no ?? '' !!} @if($whatsapp_no != '') WhatsApp : {!! $whatsapp_no !!} @endif</td>
                                                                                        </tr>
                                                                                        <tr class="font-weight-bold">
                                                                                             <td style="text-align: left;">Email</td>
                                                                                            <td>:</td>
                                                                                            <td colspan="3" style="text-align: left; padding-left: 2px"> {!! $paymentVoucher->paymentVoucherDetail->account->account_contact->email ?? '' !!}</td>
                                                                                        </tr>
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                            <div class="col-4 border-right border-dark" style=" font-size:12px; margin-top: 10px; display: flex; justify-content: flex-end;">
                                                                                <div style="text-align: center;">
                                                                                @php
                                                                                    $generatorPNG = new Picqer\Barcode\BarcodeGeneratorPNG();
                                                                                @endphp
                                                                                <img class="barcodeStyle" src="data:image/png;base64,{{ base64_encode($generatorPNG->getBarcode($paymentVoucher->receipt_no ?? '', $generatorPNG::TYPE_CODE_128)) }}" height="120" width="200">
                                                                                <br>
                                                                                <h6><b>{!! $paymentVoucher->receipt_no ?? '' !!}</b></h6></div>
                                                                            </div>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="row mt-n3">
                                                    <div class="col-12 text-center">
                                                        <h4 class="text-bold my-auto">{!! $paymentVoucher->paymentVoucherDetail->voucherType->voucher_title ?? 'Money Receipt' !!}
                                                        </h4>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-12">
                                                        <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                                            <thead>
                                                                <tr class="text-uppercase">
                                                                    <th style="text-align: left;">Sl.No</th>
                                                                    <th style="text-align: left;">Date </th>
                                                                    <th style="text-align: left;">Transaction Mode </th>
                                                                    <th style="text-align: left;">Payment Mode </th>
                                                                    <th style="text-align: left;"> Referrence </th>
                                                                    <th style="text-align: right;">Amount</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @if(isset($paymentVoucher->paymentVoucherDetails)&&count($paymentVoucher->paymentVoucherDetails)>0)
                                                                    @php $grand_total = 0; @endphp
                                                                    @php $i = 1; @endphp
                                                                    @foreach($paymentVoucher->paymentVoucherDetails as $key => $transactions)
                                                                        @php
                                                                            if($transactions->transaction_type == 'DEBIT') {
                                                                                continue;
                                                                            }

                                                                            if($transactions->amount < 1) {
                                                                                continue;
                                                                            }
                                                                        @endphp
                                                                        <tr>
                                                                          <td style="text-align: left;">{{ $i }}</td>
                                                                          <td style="text-align: left;">{{ $transactions->transaction_date ?? '' }}</td>
                                                                          <td style="text-align: left;">{{ $transactions->account->name ?? '' }}</td>
                                                                          <td style="text-align: left;">{{ $transactions->payment_mode->mode ?? '' }}</td>
                                                                          <td style="text-align: left;">{{ $transactions->transaction_referrence ?? '' }}</td>
                                                                          <td style="text-align: right;">{{ isset($transactions->amount) && $transactions->amount > 0 ? convertDecimelPoint($transactions->amount) : "0" }}</td>
                                                                        </tr>
                                                                        @php
                                                                            $grand_total = $grand_total + $transactions->amount;
                                                                            $i += 1;
                                                                        @endphp
                                                                    @endforeach
                                                                    <tr>
                                                                        <td colspan="5"  style="text-align: right;"><strong>Total</strong></td>
                                                                        <td style="text-align: right;"><strong>{{ convertDecimelPoint($grand_total) ?? "" }}</strong></td>
                                                                    </tr>
                                                                @endif
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>

                                    <tfoot class="report-footer">
                                        <tr>
                                            <td class="report-footer-cell">
                                                <div class="row mt-n3">
                                                    <div class="col-6 text-left">
                                                        <p>Amount (in words) : {!! convertAmountToWords($grand_total) !!}</p>
                                                        <p><b style="font-size: 10px">Note: Digitally Generated Voucher, Signature Not Required</b></p>
                                                        @if($paymentVoucher->remarks != '')
                                                            <p>
                                                                <b>Narration:</b><br>
                                                                {!! $paymentVoucher->remarks ?? '' !!}
                                                            </p>
                                                        @endif

                                                        @if(isset($paymentVoucher->paymentVoucherDetail->voucherTerm))
                                                            {!! $paymentVoucher->paymentVoucherDetail->voucherTerm->terms_and_condition ?? '' !!}
                                                        @endif
                                                        <br>
                                                    </div>
                                                    <div class="col-6 text-right" style="text-align: right;">
                                                        <p>
                                                            <span style="font-size: 16px;text-align: right;">
                                                                <b>{!! $paymentVoucher->company->name ?? '' !!}</b>
                                                            </span>
                                                            <br> <br>
                                                            Authorized Signatory <br>
                                                            Prepared by: {!! $paymentVoucher->user->name ?? '' !!}<br>
                                                            {{--<b style="font-size: 10px">Note: Digitally Generated Voucher, Signature Not Required</b>--}}
                                                        </p>
                                                    </div>
                                                    <div class="col-12">
                                                    
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
</div>
<div style="width:100%; text-align: center; ">
        <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Payment Voucher</button>
</div>
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>
<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            // printInvoice(page_title);
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
    </script>
@endsection