<div id="print_div">
    <div class="pathology-bill">
<div class="row">
<div class="col-2" style="width: 20%">
    <p>Date : {!! formatedDate(date('Y-m-d')) !!}</p>
</div>
<div class="col-7" style="text-align: center;">
    <p style="color:#0b5ed7;font-size:18px;margin-bottom: -4px !important"><b>{!! $company->name ?? '' !!}</b></p>
    <p style="font-size: 14px;"><b>Item Wise Purchase Statement</b></p>
    <p style="padding-bottom: 5px;font-size: 11px;"><b><span style="color: #698aff;">Report</span> List</b>
    <b>From <span style="color:#698aff;" id="">{{$from_date?formatedDate($from_date):formatedDate(date('Y-m-d H:i:s'))}}</span> TO <span style="color:#698aff;" id="">{{$to_date?formatedDate($to_date):formatedDate(date('Y-m-d H:i:s')) }}</span>
            </b></p>
</div>
<div class="col-2" style="text-align: right; width:20%">
    <p>Time : {!! formatedTime(date('H:i:s')) !!}</p>
</div>
</div>

<div>
    <table class="table table-borderless report-container">
        <tbody class="report-content">
            <tr>
                <td class="report-content-cell">
                    <div class="row">
                        <div class="col-12">

                            <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                <thead>
                                  <tr class="text-uppercase">
                                    <th style="text-align: left;">Sl.</th>
                                    <th style="text-align: left;">Invoice</th>
                                    <!-- <th style="text-align: left;">Batch</th> -->
                                    <th style="text-align: left;">Bill To</th>
                                    <th style="text-align: left;">Consultant</th>
                                    <th style="text-align: left;">Voucher</th>
                                    <!-- <th style="text-align: left;">Transaction Mode</th> -->
                                    <th style="text-align: left;">Item Name</th>
                                    <th style="text-align: left;">Category</th>
                                    <th style="text-align: left;">HSN</th>
                                    <th style="text-align: left;">QTY (Pack)</th>
                                    <th style="text-align: left;">QTY (Loose)</th>
                                    <th style="text-align: center;">Tax (%)</th>
                                    <th style="text-align: center;">Basic Amt.</th>
                                    <th style="text-align: right;">Total Tax</th>
                                    <th style="text-align: center;">Total Amt.</th>
                                  </tr>
                                </thead>
                                <tbody>
                                  @if(isset($saleInvoices) && count($saleInvoices) > 0)
                                    @php
                                      $i = 1;
                                      $total_amount = $total_pack = $total_loose = $total_basic = $total_tax = 0;
                                    @endphp
                                    @foreach($saleInvoices as $invoice)
                                      <tr class="border-1">
                                        <td style="text-align: left;">{!! $i !!}</td>
                                        <td style="text-align: left;">{!! $invoice->supplier_invoice_number ?? '' !!}<br>{!! ($invoice->invoice_date ? formatedDate($invoice->invoice_date) : '') !!}</td>
                                        <!-- <td style="text-align: left;">{!! $invoice->invoice_batch_no ?? '' !!}</td> -->
                                        @if(!empty($invoice->bill_to_name))
                                        <td style="text-align: left;">{!! $invoice->bill_to_name ?? '' !!}</td>
                                        @else
                                        <td style="text-align: left;">{!! $invoice->account_name ?? '' !!}<br>
                                          {!! $invoice->account_code ?? '' !!}</td>
                                        @endif
                                        <td style="text-align: left;">@if(!empty($invoice->doctor_name)) Dr {!! $invoice->doctor_name ?? '' !!} @else Self @endif</td>
                                        <td style="text-align: left;">{!! $invoice->voucher_type_name ?? '' !!}</td>
                                        <td style="text-align: left;"><a href="{!! route('purchase.single-product-statement', $invoice->product_id) !!}">{!! $invoice->product_name ?? '' !!}</a></td>
                                        <td style="text-align: left;">{!! $invoice->product_category ?? '' !!}</td>
                                        <td style="text-align: left;">{!! $invoice->hsncode ?? '' !!}</td>
                                        <td style="text-align: right;">{!! convertDecimelPoint($invoice->main_qty) ?? '' !!}</td>
                                        <td style="text-align: right;">{!! convertDecimelPoint($invoice->alt_qty) ?? '' !!}</td>

                                        @php
                                          $tax_per = $invoice->tax != 'Tax Free' ? preg_replace('/[^0-9]/', '', $invoice->tax ?? 0,) : 0;
                                          $quantity = !empty($invoice->main_qty) ? $invoice->main_qty : $invoice->alt_qty;

                                          if ($invoice->tax_calculation == 'EXCLUSIVE') {
                                            $basic_amount = $quantity * $invoice->basic_amount;
                                            $tax = $invoice->basic_amount - $invoice->total_amount;
                                          } else {
                                            $basic_amount = $quantity * $invoice->basic_amount;
                                            $tax = $invoice->total_amount - $invoice->basic_amount;
                                          }
                                        @endphp

                                        <td style="text-align: right;">{!! convertDecimelPoint($tax_per) ?? '' !!}%</td>

                                        <td style="text-align: right;">{!! convertDecimelPoint($invoice->basic_amount) !!}</td>
                                        <td style="text-align: right;">{!! convertDecimelPoint($tax) !!}</td>
                                        <td style="text-align: right;">{!! convertDecimelPoint($invoice->total_amount) !!}</td>
                                      </tr>
                                      @php
                                        $i += 1;
                                        $total_amount += $invoice->total_amount;
                                        $total_pack   += $invoice->main_qty ?? 0;
                                        $total_loose  += $invoice->alt_qty ?? 0;
                                        $total_basic  += $invoice->basic_amount ?? 0;
                                        $total_tax    += $tax;
                                      @endphp
                                    @endforeach
                                    <tr>
                                      <td colspan="8" style="text-align: center;"><b>Total</b></td>
                                      <td style="text-align: right;">{{ convertDecimelPoint($total_pack) }}</td>
                                      <td style="text-align: right;">{{ convertDecimelPoint($total_loose) }}</td>
                                      <td style="text-align: right;"></td>
                                      <td style="text-align: right;">{{ convertDecimelPoint($total_basic) }}</td>
                                      <td style="text-align: right;">{{ convertDecimelPoint($total_tax) }}</td>
                                      <td style="text-align: right;">{{ convertDecimelPoint($total_amount) }}</td>
                                    </tr>
                                  @else
                                    <tr>
                                      <td colspan="14" style="text-align: center;">No Records Found</td>
                                    </tr>
                                  @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
</div>
</div>
</div>
@if(isset($saleInvoices) && count($saleInvoices)>0)
<div class="row">
  <div class="col-md-6" style="text-align: right;">
      <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Statement </button>
  </div>

  <div class="col-md-6" style="text-align: left;">
      <a href="javascript:;" class="btn btn-outline-primary export-statement"><i class="bi bi-download"></i> Export</a>
  </div>
</div>
@endif
