@extends('layouts.app')
@section('title', $accountReceipt->receipt_no . ' - '. ($accountReceipt->receipt_date ? formatedDate($accountReceipt->receipt_date) : '') . ' - ' . ($accountReceipt->accountReceiptDetail->account->name ?? ''))
@section('pages')

<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />

@php $pageTitle =  $accountReceipt->receipt_no . ' - ' .($accountReceipt->accountReceiptDetail->account->name ?? '') ; @endphp
<div id="" class="card-header py-3">
  <div class="row gx-2">

    <div class="col-lg-6 col-md-6 col-6">
        <div class="position-relative">
            <h5>Money Receipt | {!! $accountReceipt->receipt_no !!}</h5>
        </div>
    </div>
    <div class="col-lg-6 col-md-6">
      <div class="ms-auto float-md-end">
      <div class="btn-group">
            @if(auth()->user()->can('receipt-voucher-create'))
                <a href="{{ route('receipt-voucher.create') }}" class="btn btn-primary"><i class="bx bx-plus"></i> Add New</a>
            @endif
        </div>
        <div class="btn-group">
        @php
            $redirectUrl = request()->redirect ?? 'receipt-voucher' ;
        @endphp
            @if ($redirect != '' && $redirect == 'lab-billings')
            <a href="{{ route('lab-billings.index') }}" class="btn btn-outline-secondary me-2"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            @else
            <a href="{{ url($redirectUrl) }}" class="btn btn-outline-secondary me-2"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            @endif
            <!-- <button id="btn_pdf" type="button" class="btn btn-primary btn-lg"> Download PDF <i class="bi bi-download text-white"></i></button> -->
        </div>
       
      </div>
    </div>
  </div>
</div>

<div id="print_div">
    <div>
        <style type="text/css">
            .table>tbody>tr>td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th, .table>thead>tr>td, .table>thead>tr>th {
                padding: 4px;
                padding-bottom: 0px;
                padding-top: 0px;
                color: #3a3a3a;
                font-size: 12px !important;
            }
        </style>
        <div class="row">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                    @php $company = $accountReceipt->company; @endphp
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell" style="font-weight: normal;">

                                                <x-CompanyLetterHead :company="$company" />
                                                <!-- <x-CompanyLetterHead :company="$company"/> -->
                                            </th>
                                        </tr>
                                    </thead>
                                    <tfoot class="report-footer">
                                        <tr>
                                            <td class="report-footer-cell">
                                            </td>
                                        </tr>
                                    </tfoot>

                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell">
                                                @include('components.ac-receipt.voucher-details')
                                                <div class="row mt-n3">
                                                    <div class="col-12 text-center">
                                                        <h4 class="text-bold my-auto">
                                                            {{-- {!! $accountReceipt->accountReceiptDetail->voucherType->voucher_title ?? 'Money Receipt' !!} --}}
                                                            Money Receipt 
                                                            <span style="font-weight: 100;">
                                                            @if($accountReceipt->advance_received=='Yes' && $accountReceipt->settlement_status=='Yes')
                                                            ({{ 'Advance Adjusted' }})  
                                                            @elseif($accountReceipt->advance_received=='Yes')
                                                                ({{ $accountReceipt->advance_received=='Yes'?'Advance Receipt':'' }})   
                                                            @endif
                                                            </span> 
                                                        </h4>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="col-12">
                                                        <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                                            <thead>
                                                                <tr class="text-uppercase">
                                                                    <th style="text-align: left;">Sl.No</th>
                                                                    <th style="text-align: left;">Mode </th>
                                                                    <th style="text-align: left;">Receive Mode </th>
                                                                    <th style="text-align: left;">Referrence </th>
                                                                    <th style="text-align: right;">Amount</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @if(isset($accountReceipt->accountReceiptTransaction)&&count($accountReceipt->accountReceiptTransaction)>0)
                                                                    @php $grand_total = 0; @endphp
                                                                    @php $i = 1; @endphp
                                                                   
                                                                    @foreach($accountReceipt->accountReceiptTransaction as $key => $transactions)
                                                                    @php
                                                                        if($transactions->transaction_type == 'CREDIT') {
                                                                            continue;
                                                                        }

                                                                        if($transactions->amount < 1) {
                                                                            continue;
                                                                        }
                                                                    @endphp
                                                                        <tr>
                                                                          <td style="text-align: left;">{{ $i }}</td>
                                                                          <td style="text-align: left;">{{ $transactions->account->name ?? '' }}</td>
                                                                          <td style="text-align: left;">{{ $transactions->payment_mode->mode ?? '' }}</td>
                                                                          <td style="text-align: left;">{{ $transactions->transaction_referrence ?? '' }}</td>
                                                                          <td style="text-align: right;">{{ isset($transactions->amount) && $transactions->amount > 0 ? convertDecimelPoint($transactions->amount) : "0" }}</td>
                                                                        </tr>
                                                                    @php $grand_total = $grand_total + $transactions->amount;
                                                                        $i += 1;
                                                                    @endphp
                                                                    @endforeach
                                                                    <tr>
                                                                        <td colspan="4"  style="text-align: right;"><strong>Total</strong></td>
                                                                        <td style="text-align: right;"><strong>{{ convertDecimelPoint($grand_total) ?? "" }}</strong></td>
                                                                    </tr>
                                                                @endif
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="report-footer-cell">
                                                <div class="row mt-n3">
                                                    <div class="col-6 text-left">
                                                        <p>Amount (in words) : {!! convertAmountToWords($grand_total) !!}</p>
                                                        <p><b style="font-size: 10px">Note: Digitally Generated Voucher, Signature Not Required</b></p>
                                                        @if($accountReceipt->remarks != '')
                                                            <p>
                                                                <b>Narration:</b><br>
                                                                {!! $accountReceipt->remarks ?? '' !!}
                                                            </p>
                                                        @endif

                                                        @if(isset($accountReceipt->accountReceiptDetail->voucherTerm))
                                                            {!! $accountReceipt->accountReceiptDetail->voucherTerm->terms_and_condition ?? '' !!}
                                                        @endif
                                                        <br>
                                                    </div>
                                                    <div class="col-6 text-right" style="text-align: right;">
                                                        <p>
                                                            <span style="font-size: 16px;text-align: right;">
                                                                <b>{!! $accountReceipt->company->name ?? '' !!}</b>
                                                            </span>
                                                            <br> <br>
                                                            Authorized Signatory <br>
                                                            Prepared by: {!! $accountReceipt->user->name ?? '' !!}<br>
                                                            
                                                        </p>
                                                    </div>
                                                    <div class="col-12">
                                                    
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>

                                    <tfoot class="report-footer">
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div style="width:100%; text-align: center; ">
    <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Receipt Voucher </button>
</div>
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            // printInvoice(page_title);
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents = document.getElementById('print_div').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
    </script>
@endsection