<div id="print_div">
    <div class="pathology-bill">
        <div class="row">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <x-MiniLetterHead :fromDate="($from_date ?? '')" :toDate="($to_date ?? '')" :companyName="($company->name ?? '')" :voucherTitle="@$voucher_type->voucher_title" />
                            <div class="col-12">
                                <table class="table table-borderless report-container" id="receiptdatatable">
                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell">
                                                <div class="row page_break">
                                                    <div class="col-12">
                                                        <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                                            <thead>
                                                                <tr class="text-uppercase">
                                                                    <th style="text-align: left;">Sl no</th>
                                                                    <th style="text-align: left;">Receipt No</th>
                                                                    <th style="text-align: left;">Date</th>
                                                                    <th style="text-align: left;">Account Name</th>
                                                                    <th style="text-align: left;">Voucher Type</th>
                                                                    <th style="text-align: left;">Prepared By</th>
                                                                    <th style="text-align: left;">Ref. Voucher No.</th>
                                                                    <th style="text-align: left;">Voucher Date</th>
                                                                    <th style="text-align: left;">Transaction Mode </th>
                                                                    <th style="text-align: left;">Payment Mode </th>
                                                                    <th style="text-align: right;">Amount</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody id="receipt-table-body">
                                                                @if(isset($accountReceipt) && count($accountReceipt) > 0)
                                                                @php $i = 1; 
                                                                    $totalByTransactionMode = []; 
                                                                @endphp
                                                                
                                                                @php $grand_total = 0; $totalCash = $totalNeft = $totalCheque = $totalUPI =  $totalPaymentGateway = $totalOther = 0;  @endphp
                                                                @foreach($accountReceipt as $receipt)
                                                                @if(isset($receipt->accountReceiptTransaction)&&count($receipt->accountReceiptTransaction)>0)

                                                                    @foreach($receipt->accountReceiptTransaction as $key => $transactions)

                                                                        @if($transactions->transaction_type == 'CREDIT')
                                                                            @php continue; @endphp
                                                                        @endif


                                                                        @php
                                                                            $totalByTransactionMode[$transactions->account->name??''][$transactions->payment_mode->mode??''] = ($totalByTransactionMode[$transactions->account->name??''][$transactions->payment_mode->mode??''] ?? 0) + $transactions->amount;
                                                                        @endphp

                                                                        <tr>
                                                                            @if($key == 1)
                                                                                @php
                                                                                    $count = @count($receipt->accountReceiptTransaction->where('transaction_type','<>','CREDIT')) ?? 0;
                                                                                @endphp
                                                                                <td style="text-align: left;" rowspan="{{$count}}">{{ $i }}  </td>
                                                                                <td style="text-align: left;" rowspan="{{$count}}">{!! $receipt->receipt_no !!}</td>
                                                                                <td style="text-align: left;" rowspan="{{$count}}">{!! ($receipt->receipt_date ? formatedDateTime($receipt->receipt_date . '  ' . $receipt->receipt_time) : '') !!}</td>
                                                                                <td style="text-align: left;" rowspan="{{$count}}">
                                                                                    {!! $receipt->accountReceiptDetail->account->account_title->name??null !!}
                                                                                    {!! $receipt->accountReceiptDetail->account->name ?? '' !!}
                                                                                </td>
                                                                                <td style="text-align: left;" rowspan="{{$count}}">
                                                                                    {!! $receipt->accountReceiptDetail->voucherType->name ?? '' !!}
                                                                                </td>
                                                                                <td style="text-align: left;" rowspan="{{$count}}">
                                                                                    @if(isset($receipt->prepared_by))
                                                                                    <b>By:</b> {{ $receipt->prepared_by ?? '' }}
                                                                                     @endif
                                                                                </td>

                                                                                <td style="text-align: left;" rowspan="{{$count}}">
                                                                                    @if($receipt->accountReceiptDetail->voucherType->name=="OPD Booking")
                                                                                        {{ $receipt->opdBooking->booking_no ?? '' }}
                                                                                    @else
                                                                                        {!! $receipt->salesVoucher->main_invoice_no??'' !!}
                                                                                    @endif
                                                                                </td>

                                                                                <td style="text-align: left;" rowspan="{{$count}}">
                                                                                    @if($receipt->accountReceiptDetail->voucherType->name=="OPD Booking")
                                                                                        {{ isset($receipt->opdBooking->booking_date_time)?formatedDate($receipt->opdBooking->booking_date_time) : '' }}
                                                                                    @else
                                                                                        {{ formatedDate(@$receipt->salesVoucher->created_at) ?? '' }}
                                                                                    @endif
                                                                                </td>

                                                                                @php $i += 1; @endphp
                                                                            @endif
                                                                            <td style="text-align: left;">{{ $transactions->account->name ?? '' }}</td>
                                                                            <td style="text-align: left;">
                                                                                @if(isset($transactions->payment_mode->mode))
                                                                                  {{ $transactions->payment_mode->mode ?? '' }}
                                                                                @endif
                                                                            </td>
                                                                            <td style="text-align: right;">
                                                                                {{ isset($transactions->amount) && $transactions->amount > 0 ? convertDecimelPoint($transactions->amount) : "0" }}
                                                                            </td>
                                                                        </tr>
                                                                        @php
                                                                        $grand_total = $grand_total + $transactions->amount;
                                                                        $i + 1;
                                                                        @endphp
                                                                    @endforeach
                                                                @endif
                                                                @endforeach
                                                                
                                                                @foreach ($totalByTransactionMode as $transactionMode => $paymentModes)
                                                                    <tr>
                                                                        <td colspan="10" style="text-align: right; text-transform: uppercase;border-right:none !important"><b>{{ $transactionMode }} SUMMARY</b></td>
                                                                        <td style="border-left:none !important"></td>
                                                                    </tr>
                                                                    @foreach ($paymentModes as $paymentMode => $total)
                                                                        <tr>
                                                                            <td colspan="10"  style="text-align: right; text-transform: uppercase;">TOTAL {{ $paymentMode }}</td>
                                                                            <td style="text-align: right;"><b>{{$total}}</b></td>
                                                                        </tr>
                                                                    @endforeach
                                                                @endforeach

                                                                <tr>
                                                                    <td colspan="10" style="text-align: right;text-transform: uppercase;"><b>Grand TOTAL</b></td>
                                                                    <td style="text-align: right;"><b>{!! convertDecimelPoint($grand_total) !!}</b></td>
                                                                </tr>

                                                                @else
                                                                <tr>
                                                                    <td colspan="11" style="text-align: center;">No Records Found</td>
                                                                </tr>
                                                                @endif
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <p style="text-align: center;display: none;" id="endofstatement"> *** End Of Statement ***</p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@if(isset($accountReceipt) && count($accountReceipt) > 0)
<div class="row">
    <div class="col-md-6" style="text-align: right;">
        <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Statement </button>
    </div>

    <div class="col-md-6" style="text-align: left;">
        <a href="javascript:;" class="btn btn-outline-primary export-statement"><i class="bi bi-download"></i> Export</a>
    </div>
</div>
@endif