<div id="print_div">
    <div class="pathology-bill">
        <div class="row">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            @php $voucher_title = 'TRANSACTION'; @endphp
                            <x-MiniLetterHead :fromDate="$from_date" :toDate="$to_date" :companyName="$company->name" :voucherTitle="@$voucher_title" />
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell">
                                                <div class="row">
                                                    <div class="col-12">
                                                        <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">

                                                            <thead>
                                                                <tr class="text-uppercase">
                                                                    <th class="thbutton">Sl No</th>
                                                                    <th>Transactions No.</th>
                                                                    <th>Transactions Date</th>
                                                                    <th>Voucher No</th>
                                                                    <th>Voucher Type</th>
                                                                    <th>Receipt No</th>
                                                                    <th>Account Name</th>
                                                                    <th style="text-align: right;">Debit Amount</th>
                                                                    <th style="text-align: right;">Credit Amount</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @php $i=1; $totalCredit =  $totalDebit = 0;@endphp
                                                                @if(count($data)>0)
                                                                @foreach($data as $key=> $list)
                                                                <tr>
                                                                    <td>{!! $i !!}</td>
                                                                    <td>
                                                                        {!! $list->transactions_no ?? '' !!}
                                                                    </td>
                                                                    <td>
                                                                        {!! formatedDate($list->transaction_date) !!}<br>
                                                                    </td>
                                                                    <td>

                                                                    @if($list->module_code === 'CONTRA')
                                                                        {!! $list->contraVoucher->voucher_no ?? '' !!}
                                                                    @elseif($list->module_code === 'PAYMENT_VOUCHER')
                                                                        {!! $list->paymentVoucher->receipt_no ?? '' !!}
                                                                    @elseif($list->module_code === 'JOURNAL_VOUCHER')
                                                                        {!! $list->journalVoucher->voucher_no ?? '' !!}
                                                                    @elseif($list->module_code === 'Receipt_VOUCHER')
                                                                        {!! $list->receiptVoucher->receipt_no ?? '' !!}
                                                                    @elseif($list->module_code === 'PATHOLOGY_LAB_BILLING' || $list->module_code === 'Pathology' || $list->module_code === 'PATHOLOGY')
                                                                        @if($list->voucher_type=='RECEIPT')
                                                                            {!! $list->receiptVoucher->salesVoucher->voucher_type_invoice_no ?? '' !!}
                                                                        @else
                                                                            {!! $list->pathologyVoucher->voucher_type_invoice_no ?? '' !!}
                                                                        @endif
                                                                    @elseif($list->module_code === 'OPD_BOOKING')
                                                                        @if($list->voucher_type=='RECEIPT')
                                                                            {!! $list->receiptVoucher->opdBooking->booking_no ?? '' !!}  
                                                                        @else
                                                                            {!! $list->OpdVoucher->booking_no ?? '' !!}
                                                                        @endif
                                                                        
                                                                    @elseif($list->module_code === 'IPD_ADMISSION' || $list->module_code === 'IPD_INVOICE')
                                                                        {!! $list->IPDAdmissionVoucher->ipd_admission_no ?? '' !!}
                                                                    @elseif($list->module_code === 'SALES')
                                                                        @if($list->voucher_type=='RECEIPT')
                                                                            {!! $list->receiptVoucher->salesVoucher->voucher_type_invoice_no ?? '' !!}
                                                                        @else
                                                                            {!! $list->SalesVoucher->voucher_type_invoice_no ?? '' !!}
                                                                        @endif
                                                                    @endif
                                                                    </td>

                                                                    <td>
                                                                        {!! $list->VoucherType->name ?? '' !!}<br>
                                                                    </td>
                                                                    <td>
                                                                        @if($list->voucher_type=='RECEIPT')
                                                                        {!! $list->receiptVoucher->receipt_no??'' !!}
                                                                        @endif
                                                                    </td>

                                                                    @if($list->transaction_type=='DEBIT')
                                                                    <td>{!! $list->Account->name ?? '' !!} A/C {!! $list->transaction_type !!}</td>
                                                                    @else
                                                                    <td style="text-align: right;">To {!! $list->Account->name ?? '' !!} A/C {!! $list->transaction_type !!}</td>
                                                                    @endif

                                                                    <td style="text-align: right; font-size: 14px;">
                                                                        @if($list->transaction_type=='DEBIT')
                                                                        {!! isset($list->amount) && $list->amount > 0 ? convertDecimelPoint($list->amount) : 0 !!}<br>
                                                                        @php $totalDebit+=$list->amount; @endphp
                                                                        @endif
                                                                    </td>
                                                                    <td style="text-align: right; font-size: 14px;">
                                                                        @if($list->transaction_type=='CREDIT')
                                                                        {!! isset($list->amount) && $list->amount > 0 ? convertDecimelPoint($list->amount) : 0 !!}<br>
                                                                        @php $totalCredit+=$list->amount; @endphp
                                                                        @endif
                                                                    </td>
                                                                    @php $i++; @endphp
                                                                    @endforeach
                                                                    <tr>
                                                                        <td colspan="7" class="text-end"><b>Total:</b></td>
                                                                        <td class="text-end"><b>{!! $totalDebit??0 !!}</b></td>
                                                                        <td class="text-end"><b>{!! $totalCredit??0 !!}</b></td>
                                                                    </tr>
                                                                    @else
                                                                <tr>
                                                                    <td colspan="9">No Data Found</td>
                                                                </tr>
                                                                @endif
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@if(isset($data) && count($data) > 0)
<div class="row">
<div class="col-md-6" style="text-align: right;">
    <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Statement </button>
</div>

<div class="col-md-6" style="text-align: left;">
    <a href="javascript:;" class="btn btn-outline-primary export-statement"><i class="bi bi-download"></i> Export</a>
</div>
</div>
@endif