@extends('layouts.app')
@section('title','Invoice Serial Setting')
@section('pages')


<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
  <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Settings</div>
  <div class="ps-3">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb mb-0 p-0">
        
        <li class="breadcrumb-item active" aria-current="page">Update Invoice Serial Setting</li>
      </ol>
    </nav>
  </div>
  <div class="ms-auto">
    <div class="btn-group">
      <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
    </div>
  </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 auto-width row" action="{{ route('invoice-setting.update',$InvoiceSerialSetting->id)}}" method="post" enctype='multipart/form-data'>
            <!-- For validation comment on -->
              @csrf
              @method('PUT')
              <div class="card col-md-4 col-sm-12">
              <div class="card-body g-3 row">
              <h5 class="mb-0">Invoice Serial Setting</h5>
              <hr class="mb-0">
              <div class="col-md-12">
                <label for="validationCustom01" class="form-label">Module Type <span class="text-danger"><b>*</b></span></label>
                <select class="single-select" name="module_type" required>
                <option value="">--select--</option>
                  <option value="Book Issue" @if($InvoiceSerialSetting->module_type=='Book Issue'){{'selected'}}@endif>Book Issue</option>
                  <option value="Book Return" @if($InvoiceSerialSetting->module_type=='Book Return'){{'selected'}}@endif>Book Return</option>
                  <option value="Admission" @if($InvoiceSerialSetting->module_type=='Admission'){{'selected'}}@endif>Admission</option>
                </select>
                @if ($errors->has('module_type'))
                <span class="text-danger">{{ $errors->first('module_type') }}</span>
                @endif
              </div>	
              <div class="col-md-12">
                <label class="form-label">Prefix<span class="text-danger"><b>*</b></span></label>
                <input type="text" class="form-control"  placeholder="Ex.- BI" name="prefix" value="@if(isset($InvoiceSerialSetting->prefix)){{$InvoiceSerialSetting->prefix}}@endif" required>
                @if ($errors->has('prefix'))
                <span class="text-danger">{{ $errors->first('prefix') }}</span>
                @endif
              </div>
              <div class="col-md-12">
                <label class="form-label">Start From<span class="text-danger"><b>*</b></span></label>
                <input type="text" class="form-control"  placeholder="Ex.- 001" name="startfrom" value="@if(isset($InvoiceSerialSetting->prefix)){{$InvoiceSerialSetting->startfrom}}@endif"  required>
                @if ($errors->has('startfrom'))
                <span class="text-danger">{{ $errors->first('startfrom') }}</span>
                @endif
              </div>
              <div class="col-md-12">
                <label class="form-label">Financial Year <span class="text-danger"><b>*</b></span></label>
                <select class="single-select" name="financial_id" required>
                  <option value="">--select--</option>
                  @foreach($financialyears as $list)
                  <option value="{{ $list->financialyearid }}" @if($InvoiceSerialSetting->financial_id==$list->financialyearid){{'selected'}}@endif>{{ $list->financial_year_name }}</option>
                  @endforeach
                </select>
                @if ($errors->has('financial_id'))
                <span class="text-danger">{{ $errors->first('financial_id') }}</span>
                @endif
              </div>							
              <div class="d-grid gap-2">
                <button class="btn btn-primary" type="submit"><i class="bx bx-save"></i> Update Invoice Serial Setting</button>
              </div>
</div>
</div>
            </form>
          </div>
        </div>
      </div>

    </div>
  </div>
  <!--end row-->
  @endsection