@extends('layouts.app')
@section('title', 'IPD Admission')
@section('pages')

<style type="text/css">
  
.breadcrumb-title {
  border-right: none;
}

tr td {
  vertical-align: middle !important;    
}

.btn{
  padding: 8px 30px;
  margin-left: 30px
      
}


.col-lg-7{
  margin: auto;
  display: flex;
}


</style>




    <!--breadcrumb-->
    <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
      <div class="breadcrumb-title col-md-6"> Beds Available
      </div>
      <div class="col-md-6">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb justify-content-md-end mb-0">
            <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="93" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
            <li class="breadcrumb-item active" aria-current="page">IPD-In Patient </li>
            <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> IPD Admission</li>
          </ol>
        </nav>
      </div>
    </div>
    <!--end breadcrumb-->

    <div class="card style_table shadow-none radius-5 min-height">
          <div class="card-header py-3">
            @include('layouts.partials.nav-menu')
            <div class="row gx-2">

			
                <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
                  <i class="bi bi-funnel"></i>
                  <select class="form-select" id="search_company" name="search_company" aria-controls="example">
                      <option value="">Select Company</option>
                      @foreach($companies as $company)
                      <option value="{{ $company->id }}">{{$company->name}}</option>
                      @endforeach
                      
                  </select>
                </div>

                <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
                  <i class="bi bi-funnel"></i>
                  <select class="form-select" id="search_building" name="search_building" aria-controls="example">
                      <option value="">Select Building</option>
                       @foreach($buildings as $building)
                      <option value="{{ $building->id }}">{{$building->name}}</option>
                      @endforeach
                  </select>
                </div>


               


             <!--  <div class="col-lg-3 col-md-3 col-8">
                  <div class="position-relative">
                      <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                      <input class="form-control ps-5" type="search" id="search" placeholder="Search" autofocus>
                  </div>
              </div> -->



              <div class="col-lg-8 col-md-8">
                <div class="ms-auto float-md-end"> 
              		<div class="btn-group">
                    <a href="{{route('beds.index')}}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                  	</div>
                </div>
              </div>



            </div>
          </div>  
        <div class="card-body" id="tables">

@include('ipd-admission-bed-available.table')

      <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
      <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
      <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>



<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script>
 function fetch_data(company_id, building_id) {
    $.ajax({
        url: "?company_id=" + company_id + "&building_id=" + building_id,
        success: function(data) {
            $('#tables').html(data);
        },
    });
}

	$(document).on('change', '#search_company, #search_building', function() {
	    var company_id = $('#search_company').val();
	    var building_id = $('#search_building').val();
	    fetch_data(company_id, building_id);
	});


</script>

   
@endsection
