<style type="text/css">
    .new-bill {
        width: 95px !important;
        height: auto !important;
        line-height: 1.5 !important;
        padding: 0.275rem 0.5rem !important;
    }

    .card {
        padding: 5px;
    }

    .container2 {
        display: flex;
        justify-content: space-between;
        flex-wrap: wrap; 
    }

    .bed-icon {
        height: 60px;
        width: 60px;
    }

    .text-success {
        color: #63ef63;
    }

    .text-info {
        color: #0B5ED7; 
    }
</style>

@if(count($data) > 0)
    @foreach($data as $list)
        <div class="card">
            <div class="card-content">
                <h5 class="text-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24">
                        <path fill="currentColor" d="M19 2H9c-1.103 0-2 .897-2 2v6H5c-1.103 0-2 .897-2 2v9a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1V4c0-1.103-.897-2-2-2M5 12h6v8H5zm14 8h-6v-8c0-1.103-.897-2-2-2H9V4h10z"/>
                        <path fill="currentColor" d="M11 6h2v2h-2zm4 0h2v2h-2zm0 4.031h2V12h-2zM15 14h2v2h-2zm-8 .001h2v2H7z"/>
                    </svg>
                    {{$list['floor']}}
                </h5>
                <div class="container">
                    @foreach($list['data'] as $list2)
                        <div>
                            <p class="fs-6 text-center"><b>{{$list2['bed_group']}}</b></p>
                            <hr>
                            <div class="container2">
                                @foreach($list2['data'] as $list3)
                                    <div>
                                        @if($list3->bed_available)
                                            <svg class="bed-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512">
                                                <path d="M32 32c17.7 0 32 14.3 32 32V320H288V160c0-17.7 14.3-32 32-32H544c53 0 96 43 96 96V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V416H352 320 64v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V64C0 46.3 14.3 32 32 32zm144 96a80 80 0 1 1 0 160 80 80 0 1 1 0-160z" style="fill: #63ef63;"></path>
                                            </svg>
                                            <p class="fs-6 text-success text-center">{{$list3->bed_name}}</p>
                                        @else
                                            <svg class="bed-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512">
                                                <path d="M32 32c17.7 0 32 14.3 32 32V320H288V160c0-17.7 14.3-32 32-32H544c53 0 96 43 96 96V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V416H352 320 64v32c0 17.7-14.3 32-32 32s-32-14.3-32-32V64C0 46.3 14.3 32 32 32zm144 96a80 80 0 1 1 0 160 80 80 0 1 1 0-160z" style="fill: #0B5ED7;"></path>
                                            </svg>
                                            @if($list3->patient_name && $list3->age)
                                                <p>{{Str::limit($list3->patient_name, 10)}} <br> {{$list3->gender_name}}, {{$list3->age}} Years<br></p>
                                            @else
                                                <p class="text-center">N/A</p>
                                            @endif
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endforeach
@endif
