<form class="row g-3 auto-width bed" action="{!! route('ipd-admissions-beds.create-step-2', $ipd_id) !!}" data-id="{!! $ipd_id !!}" method="post" id="add_bed">
    @csrf
    @method('post')
    @if(isset($type) && $type=='transfer')
    <div class="col-md-6">
        <label class="form-label">Select from bed</label>
        <select name="current_bed" id="current_bed" class="form-control">
            <option value="">Select Current Bed</option>
            @foreach($AllowBeds as $row)
            <option value="{!! $row->id !!}" {!! isset($bed_history_id) && $bed_history_id==$row->id?'selected':'' !!}>{!! $row->name !!}</option>
            @endforeach
        </select>
    </div>
    <div class="col-md-6">
        <label class="form-label">Current Bed Status</label>
        <select name="current_bed_status" id="current_bed_status" class="form-control">
            <option value="1">Hold This Bed</option>
            <option value="0">Release This Bed</option>
        </select>
    </div>
    <div class="col-md-6 check_out_date_time">
        <label for="check_out_date_time" class="form-label">Check Out Date </label>
        <input  type="datetime" value="" class="form-control" id="check_out_date_time" name="check_out_date_time" aria-describedby="inputGroupPrepend">
    </div>
    <div class="col-md-12">
        <label class="form-label">Transfer reason</label>
        <textarea class="form-control" name="reason" rows="3"></textarea>
    </div>
    @endif
    <input type="hidden" name="type" value="{!! $type !!}">
    <button type="button" class="btn btn-primary save_and_confirm w-70 disabled"> <i class="bi bi-check-circle"></i> Confirm (<b><span id="bed_name">-</span></b>) Bed & click to continue </button>
    <table id="beds_table" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th colspan="2">Bed No / Room No / Name</th>
                <th>Floor / Building</th>
                <th class="text-center">{!! isset($type) && $type=='transfer'?'Transfer':'Assign' !!} Bed</th>
            </tr>
        </thead>
        <tbody>
            @php $i=0; @endphp
            @foreach($beds as $key => $bed_group)
            <tr data-bs-toggle="collapse" data-bs-target="#collapseGroup{!! $key !!}" aria-expanded="false" aria-controls="collapseGroup{!! $key !!}" style="cursor: pointer;font-size: 17px;">
                <td colspan="4" style="background-color: #f1f9ff">
                    <b style="color:#082cf1">{!! $bed_group['group'] !!}</b>  <b class="text-info">({!! count($bed_group['beds']) !!} Bed is Available)</b> 
                    <i class="bi bi-arrow-down-short" align="right" id="icon{!! $key !!}"></i>

                </td>
            </tr>
            <tr class="collapse {!! $i==0?'show':'' !!}" id="collapseGroup{!! $key !!}">
                <td colspan="4">
                    <table class="table table-sm">
                        @foreach($bed_group['beds'] as $bed)
                        <tr>
                            <td><span style="margin-left: 5px; font-size: 15px;"><b>{!! $bed->name !!}</b></span></td>
                            <td><b>{!! $bed->room_number ?? '' !!}</b> - ({!! $bed->room_name ?? '' !!})</td>
                            <td>{!! $bed->getFloor->name ?? '' !!}<br>{!! $bed->getBuilding->name ?? '' !!}</td>
                            <td class="text-center"><button class="select-bed btn btn-sm btn-outline-success" type="button" data-id="{!! $bed->id !!}" data-bed-name="{!! $bed->name !!}"><i class="bi bi-check-circle"></i> Select Bed</button></td>
                        </tr>
                        @endforeach
                    </table>
                </td>
            </tr>
            @php $i++; @endphp
            @endforeach
        </tbody>
    </table>

    <input type="hidden" name="bed_id">
</form>
<script>
    $('.check_out_date_time').hide();
    $(document).on('change', '#current_bed_status', function(){
        if($(this).val() ==0) {
            $('.check_out_date_time').show();
        }
        else
        {
            $('.check_out_date_time').hide();
        }
    });
</script>