<form class="row g-3 auto-width update-bed" action="{{ route('ipd-admissions-beds.update', $data->id) }}" method="post" id="add_bed">
    @csrf
    @method('put')

    {{-- <div class="col-md-12">
        <label for="bed_no_id" class="form-label">Bed no <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" name="bed_no_id">
            <option value="">Select</option>
            @foreach($beds as $bed_no)
                <option {{ ($data->bed_no_id == $bed_no->id) ? 'selected' : '' }} value="{{ $bed_no->id }}">
                    {{ $bed_no->name }}
                    {{ $bed_no->getRoom->room_name }} - {{ $bed_no->getRoom->getBuilding->name }} ({{ $bed_no->getRoom->getFloor->name }})
                </option>
            @endforeach
        </select>
        <span class="text-danger error_bed_no_id" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="bed_group_id" class="form-label">Bed Group</label>
        <select class="form-control" name="bed_group_id">
            <option value="">Select</option>
            @foreach($bed_groups as $bed_group)
                <option {{ ($data->bed_group_id == $bed_group->id) ? 'selected' : '' }} value="{{ $bed_group->id }}">{{ $bed_group->name }}</option>
            @endforeach
        </select>
    </div> --}}
    <div class="col-md-12">
        <div>
            <label for="bed_group_id" class="form-label">Bed Group<span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group">
            <select class="bed_group_id form-control" name="bed_group_id">
                @foreach ($bed_groups as $bed_group)
                    <option value="{{ $bed_group->id }}"
                        {{ $data->bed_group_id == $bed_group->id ? 'selected' : '' }}>{{ $bed_group->name }}
                    </option>
                @endforeach
            </select>
        </div>
    </div>
    @if ($errors->has('account_tyxpe_id'))
        <span class="text-danger">{{ $errors->first('bed_group_id') }}</span>
    @endif
    <span class="text-danger error_bed_group_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-12">
        <div><label for="bed_group_id" class="form-label">Bed No<span class="text-danger"><b>*</b></span></label></div>
        <div class="input-group">
            <select class="form-control bed_no_id" name="bed_no_id">
                @foreach($beds as $bed)

                <option value="{{$bed->id}}" {{ $data->bed_no_id == $bed->id ? 'selected' : '' }} > {!! $bed->name !!}  -  {!!$bed->getRoom->room_name!!} -  {!!$bed->getRoom->getBuilding->name!!}</option>
                @endforeach
            </select>
        </div>
        @if ($errors->has('account_tyxpe_id'))
            <span class="text-danger">{{ $errors->first('bed_no_id') }}</span>
        @endif
        <span class="text-danger error_bed_no_id" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-4">
        <label for="is_active" class="form-label">Bed Status</label>
        <select class="form-control" name="is_active">
            <option {{ ($data->is_active == '1') ? 'selected' : '' }} value="1">Hold This Bed</option>
            <option {{ ($data->is_active == '0') ? 'selected' : '' }} value="0">Release This Bed</option>
        </select>
    </div>
    <!-- Full Days -->
    <div class="col-md-4">
        <label for="full_days" class="form-label">Full Days</label>
        <input  type="number" class="form-control" id="full_days" name="full_days" value="{!! $data->full_days??'' !!}" aria-describedby="inputGroupPrepend">
    </div>
    <!-- Half Days -->
    <div class="col-md-3">
        <label for="half_days" class="form-label">Half Days</label>
        <input  type="number" class="form-control" id="half_days" name="half_days" value="{!! $data->half_days??'' !!}" aria-describedby="inputGroupPrepend">
    </div>
    <div class="col-md-6">
        <label for="check_in_date_time" class="form-label">Check In Date</label>
        <input  type="datetime" value="{{  date('d/m/Y H:i A', strtotime($data->check_in_date_time)) }}" class="form-control" id="check_in_date_time" name="check_in_date_time" aria-describedby="inputGroupPrepend">
    </div>
    <div class="col-md-6">
        <label for="check_out_date_time" class="form-label">Check Out Date </label>
        <input  type="datetime" value="{{ $data->check_out_date_time?date('d/m/Y H:i A', strtotime($data->check_out_date_time)):'' }}" class="form-control" id="check_out_date_time" name="check_out_date_time" aria-describedby="inputGroupPrepend">
    </div>
</form>
<script>
    $(document).ready(function() {
        /******* Dependent Dropdown of Beds  ************/
        $(document).on('change', '.bed_group_id', function() {
            $.ajax({
                type: 'POST',
                url: "{{ route('ipd-admissions.get-beds') }}",
                data: {
                    bed_group_id: $(this).val(),
                    bed_no_id: '{!! $data->bed_no_id !!}'
                },
                success: function(response) {
                    if (response.success) {
                        $('.bed_no_id').html(response.data);
                    } else {
                        toastr.error('Failed to retrieve beds data.', 'Error!');
                    }
                },
                error: function(xhr, status, error) {
                    toastr.error('Error occurred while fetching data.', 'Error!');
                }

            });
        });

        $(document).on('change', '.bed_no_id', function() {
            getBeds();
        });



      
    function updateCheckoutDate() {
        let halfDays = parseInt($('#half_days').val()) || 0;
        let fullDays = parseInt($('#full_days').val()) || 0;

     
        let totalHours = (halfDays * 12) + (fullDays * 24);
    
        let checkInDate = new Date("{{ $data->check_in_date_time }}"); 
       
     
        if (!isNaN(totalHours)) {
            let checkoutDate = new Date(checkInDate.getTime() + (totalHours * 60 * 60 * 1000));
        
            let date = new Date(checkoutDate);

                // Extract the day, month, and year
                let day = date.getDate();
                let month = date.getMonth() + 1; // Months are zero-based in JavaScript
                let year = date.getFullYear();

                // Extract the hours, minutes, and seconds
                let hours = date.getHours();
                let minutes = date.getMinutes();
                let seconds = date.getSeconds();

                // Determine AM or PM suffix
                let ampm = hours >= 12 ? 'PM' : 'AM';

                // Convert hours from 24-hour to 12-hour format
                hours = hours % 12;
                hours = hours ? hours : 12; // The hour '0' should be '12'

                // Add leading zero to day, month, hours, minutes, and seconds if needed
                day = day < 10 ? '0' + day : day;
                month = month < 10 ? '0' + month : month;
                hours = hours < 10 ? '0' + hours : hours;
                minutes = minutes < 10 ? '0' + minutes : minutes;
                seconds = seconds < 10 ? '0' + seconds : seconds;

                // Format the date as "d/m/Y h:m:s AM/PM"
                let formattedDate = `${day}/${month}/${year} ${hours}:${minutes}:${seconds} ${ampm}`;

            $('#check_out_date_time').val(formattedDate); 
        }
    }

    $('#half_days').on('input', function() {
        updateCheckoutDate();
    });

    $('#full_days').on('input', function() {
        updateCheckoutDate();
    });




    });
</script>



