<form class="row g-3 auto-width edit_surgery" action="{{ route('ipd-surgeries.update', $surgery->id) }}" method="POST" id="edit_surgery_form">
    @csrf
    @method('PUT') <!-- Use PUT method for update -->

    <div class="col-md-6">
        <label for="surgery_type" class="form-label">Surgery Types</label>
        <select class="form-control" name="surgery_type_id" id="surgery_type">
            <option value="">Select Types</option>
            @foreach($surgery_types as $type)
                <option value="{{ $type->id }}" {{ $type->id == $surgery->surgery_type_id ? 'selected' : '' }}>
                    {{ $type->name }}
                </option>
            @endforeach
        </select>
        <input type="hidden" id="surgery_id" name="surgery_id" class="form-control" value="{{ $surgery->id }}">
    </div>

    <div class="col-md-6">
    <div>
        <label class="form-label">Surgeon Name <span class="text-danger"><b>*</b></span></label>
    </div>
    <div class="input-group autocomplete">
        <input type="text" name="doctor_name" id="doctor_id" class="doctor-select form-control" placeholder="Search Surgeon" autocomplete="off" value="{{ isset($doctor)  ?  $doctor->name . ' - (' . $doctor->code . ')' : '' }}" {{ isset($doctor) ? : '' }}>
        <ul class="searchResult"></ul>
        <input type="hidden" name="doctor_id" value="{{ $opdBooking->getDoctorAccount->id ?? '' }}">
        <div class="input-group-append" style="margin: auto 10px auto 0;">
            <button class="btn btn-secondary add_btn" id="create_doctor" type="button" data-bs-target="#commonModal"> + </button>
            <button class="btn btn-primary edit_btn" id="edit_doctor" type="button" data-bs-target="#commonModal">
                <i class="bi bi-pencil-square"></i>
            </button>
        </div>
    </div>
</div>


    <div class="col-md-6">
        <label for="notes" class="form-label">Notes</label>
        <textarea class="form-control" name="notes" id="notes" rows="1" placeholder="Notes">{{ $surgery->notes }}</textarea>
    </div>

    <div class="col-md-6">
        <label for="scheduled_date_time" class="form-label">Scheduled Date Time</label>
        <input type="text" name="scheduled_date_time" id="scheduled_date_time" class="form-control" placeholder="Scheduled Date Time" value="{{ $surgery->scheduled_date_time }}">
    </div>

    <div class="col-md-12">
        <label for="duration" class="form-label">Duration (In Minutes)</label>
        <input type="number" name="duration" id="duration" class="form-control" placeholder="Duration" value="{{ $surgery->duration }}">
    </div>
</form>


<script>
    
    $(document).ready(function(){
        $('#admission_date').flatpickr({
            enableTime: true,
            dateFormat: "Y-m-d H:i",
            defaultDate: "now",
            clickOpens: true,
            onReady: function (selectedDates, dateStr, instance) {
                instance.setDate(new Date(), true);
            },
            onClose: function (selectedDates, dateStr, instance) {
                instance.close();
            }
        });

        //doctor select
        $('.doctor-select').autocomplete({
            autoFocus: true,
            minLength: 0,
            source: function(request, response) {
                if (request.term.length < 2) {
                    $('[name="doctor_id"]').val('');
                    return false;
                }

                $.ajax({
                    url: "{{ route('billings-search-doctors') }}",
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'get_patients_for_billing',
                        search_text: request.term
                    },
                    success: function(json) {
                        if (json.error) {
                            $('[name="doctor_id"]').val('');
                            return false;
                        }
                        response($.map(json.result, function(item) {
                            return {
                                id: item.id,
                                name: item.name,
                                code: item.code,
                                gender: item.gender ,
                                phone_no: item.phone_no,
                                date_of_birth: item.date_of_birth,
                            };
                        }));
                    }
                });
            },
            select: function(event, ui) {
                event.preventDefault();
                var age      = ui.item.date_of_birth != null ? ', ' + getAge(ui.item.date_of_birth) + ' Years' : '';
                var gender   = ui.item.gender != null ? ', ' + ui.item.gender : '';
                var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';

                $(this).val(ui.item.name + ' - (' + ui.item.code + ')' + gender + age + phone_no + "");
                $('[name="doctor_id"]').val(ui.item.id);
                return false;
            }
        }).data("ui-autocomplete")._renderItem = function(ul, item) {
            var age      = item.date_of_birth != null ? ', ' + getAge(item.date_of_birth) + ' Years' : '';
            var gender   = item.gender != null ? ', ' + item.gender : '';
            var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';

            return $("<li>")
                .append("<a>" + item.name + ' - (' + item.code + ')' + gender + age + phone_no + "</a>")
                .appendTo(ul);
        };
    });

    var doctorSelect  = document.querySelector(".doctor-select");
    var querySelector = document.querySelector(".searchResult");

    document.addEventListener("click", (event) => {
        if (event.target !== event.target !== doctorSelect && event.target !== querySelector) {
            $(".searchResult").empty();
        }
    });
</script>


