<form class="row g-3 auto-width body_vitals" action="{{ route('ipd-admissions-body-vitals.store', $id) }}" method="post" id="add_body_vitals">
    @csrf
    @method('post')

    <div class="col-md-4">
        <label for="type" class="form-label">Type <span class="text-danger"><b>*</b></span></label>
        <select name="type" class="form-control">
            <option value="admission">At Admission</option>
            <option value="discharge">At Discharge</option>
            <option value="in_patient">In-Patient</option>
        </select>
    </div>
    <div class="col-md-4">
        <label for="date" class="form-label">Date <span class="text-danger"><b>*</b></span></label>
        <input type="text" name="date" class="form-control datepicker" placeholder="Date" value="{{ now()->format('m/d/Y'); }}">
    </div>
    <div class="col-md-4">
        <label for="time" class="form-label">Time <span class="text-danger"><b>*</b></span></label>
        <input type="time" name="time" class="form-control" placeholder="Time">
    </div>

    @foreach($body_vitals as $vital)
        <div class="col-md-4 body_vitals_details">
            <label for="{{ $vital->name }}" class="form-label">{{ $vital->name }} {!! $vital->mandatory == 1 ? '<span class="text-danger"><b>*</b></span>' : '' !!}</label>
            <input type="text" class="form-control vital_columns" value="{{ old($vital->id) }}" name="{{ $vital->id }}" placeholder="{{ $vital->name }}" {!! $vital->mandatory == 1 ? 'required' : '' !!}>
        </div>
    @endforeach

    <span class="text-danger error_vital_columns" style="display:none;">Please fill the required fields!</span>
</form>