<form class="row g-3 auto-width body_vitals" action="{{ route('ipd-admissions-body-vitals.update', $id) }}" method="post" id="add_body_vitals">
    @csrf
    @method('post')

    @php 
      $data = json_decode($body_vital_histories->body_vital_value,true);
    @endphp
    <div class="col-md-4">
        <label for="type" class="form-label">Type <span class="text-danger"><b>*</b></span></label>
        <select name="type" class="form-control">
            <option value="admission" {!! matchSelected('admission',$body_vital_histories->type) !!}>At Admission</option>
            <option value="discharge" {!! matchSelected('discharge',$body_vital_histories->type) !!}>At Discharge</option>
            <option value="in_patient" {!! matchSelected('in_patient',$body_vital_histories->type) !!}>In-Patient</option>
        </select>
    </div>
    <div class="col-md-4">
        <label for="date" class="form-label">Date <span class="text-danger"><b>*</b></span></label>
        <input type="text" name="date" class="form-control datepicker" placeholder="Date" value="{{ date('Y-m-d', strtotime($body_vital_histories->vitals_date_time)) }}">
    </div>
    <div class="col-md-4">
        <label for="time" class="form-label">Time <span class="text-danger"><b>*</b></span></label>
        <input type="time" name="time" class="form-control" placeholder="Time" value="{{ date('H:i:s', strtotime($body_vital_histories->vitals_date_time)) }}">
    </div>

    @foreach($body_vitals as $vital)
        <div class="col-md-4 body_vitals_details">
            <label for="{{ $vital->name }}" class="form-label">{{ $vital->name }} {!! $vital->mandatory == 1 ? '<span class="text-danger"><b>*</b></span>' : '' !!}</label>
            <input type="text" class="form-control vital_columns" value="{{ $data[$vital->id] ?? '' }}" name="{{ $vital->id }}" placeholder="{{ $vital->name }}" {!! $vital->mandatory == 1 ? 'required' : '' !!}>
        </div>
    @endforeach
</form>