<div class="table-responsive">
  <div class="d-flex justify-content-between">
    <h5 class="mb-0">Death Register Details</h5>

    <button type="button" class="btn btn-primary" id="addDeathRegister" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus-circle"></i> Add New</button>
  </div>
  <hr class="mb-2">
  <table id="example" class="table table-bordered align-middle" style="width:100%">
    <thead class="table-light">
      <tr>
        <th class="thbutton">Serial No</th>
        <th>Reference No</th>
        <th>Case ID</th>
        <th>Guardian Name</th>
        <th>Gender</th>
        <th>Death Date</th>
        <th>Death Time</th>
        <th>Report</th>
        <th class="thbutton">Edit</th>
        <th class="thbutton">Delete</th>
      </tr>
    </thead>
    <tbody>
      @php 
      $i = 1;  
      @endphp

        @if(isset($death_registers) && count($death_registers)>0)
        @foreach ($death_registers as $list)
        <tr>
            <td class="text-center">{{$i++}}</td>
            <td class="text-left">N/A</td>
            <td class="text-left">{{$list->ipd_admission_case_id ? $list->ipd_admission_case_id : 'N/A'}}</td>
            <td class="text-left">{{$list->guardian_name ? $list->guardian_name : 'N/A'}}</td>
            <td class="text-left">{{$list->gender_name ? $list->gender_name : 'N/A'}}</td>
            <td class="text-left">{{ formatedDate($list->death_date ? $list->death_date : 'N/A')  }}</td>
            <td class="text-left">{{ formatedTime($list->death_time ? $list->death_time : 'N/A')  }}</td>
            <td class="text-left">{{$list->death_report ? $list->death_report : 'N/A'}}</td>
            <td class="text-center">
                  <button data-id="{{ $list->id }}" class="btn btn-sm btn-outline-secondary editDeathRegister" data-bs-toggle="modal" id="editDeathRegister" data-bs-target="#commonModal" title="Edit">
                    <i class="bi bi-pencil-square"></i>
                  </button>
            </td>

            <td class="text-center">
                <a data-url="{{route('death-registers.destroy' , $list->id)}}" class="btn btn-sm btn-danger deleteDataCustom" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                  <i class="bi bi-trash text-white"></i>
                </a>
            </td>
        </tr>
        @endforeach
        @else
          <tr>
              <td colspan="4">No Data Found</td>
          </tr>
        @endif
    </tbody>
  </table>
</div>