<form class="row g-3 auto-width create_surgery_anesthesia" action="{{ route('surgery-anesthesia-store' , $id) }}" id="create_surgery_team_form">
    @csrf
    @method('post')
    <div class="col-md-12">
        <label for="anesthesia_name" class="form-label">Anesthesia Name <span class="text-danger"><b>*</b></span></label>
        <input type="text" name="anesthesia_name" id="anesthesia_name" class="form-control" placeholder="Anesthesia Name" value="{{ $surgery->anesthesia_name ?? '' }}">
    </div>
    <div class="col-md-12">
        <div>
            <label class="form-label">Anesthesia Doctor <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" name="doctor_name" id="doctor_name" class="doctor-select form-control" placeholder="Search Surgeon" autocomplete="off"
            value="{{ isset($surgery->getDoctor->id) ? ($surgery->getDoctor->account_title->name ?? '') . ' ' . ($surgery->getDoctor->name ?? 's') . ' - (' . ($surgery->getDoctor->code ?? '') . ')' : '' }}"
            {{ isset($surgery->getDoctor->id) ? '' : '' }}>
            <ul class="searchResult"></ul>
            <input type="hidden" name="anesthesia_doctor" value="{{ $surgery->anesthesia_doctor ?? '' }}">
            <div class="input-group-append" style="margin: auto 10px auto 0;">
            <button class="btn btn-secondary add_btn" id="create_doctor" type="button" data-bs-target="#commonModal"> + </button>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <label for="anesthesia_type" class="form-label">Anesthesia Type</label>
        <select class="form-control" name="anesthesia_type" id="anesthesia_type" required>
            <option value="">Select Type</option>
            @foreach($anesthesia_types as $list)
                <option value="{{ $list->id }}" {!! matchSelected($list->id, $surgery->anesthesia_type) !!}>{{ $list->name }}</option>
            @endforeach
        </select>
    </div>
    <div class="col-md-6">
        <label for="anesthesia_quantity" class="form-label">Anesthesia Quantity</label>
        <input type="text" name="anesthesia_quantity" id="anesthesia_quantity" value="{{ $surgery->anesthesia_quantity ?? '' }}" class="form-control" placeholder="Anesthesia Name">
    </div>
    <div class="col-md-6">
        <label for="anesthesia_form" class="form-label">Anesthesia form</label>
        <input type="text" name="anesthesia_form" id="anesthesia_form" value="{{ $surgery->anesthesia_form ?? '' }}" class="form-control" placeholder="Anesthesia Name">
    </div>
    <div class="col-md-6">
        <label for="anesthesia_time" class="form-label">Anesthesia time</label>
        <input type="time" name="anesthesia_time" id="anesthesia_time" value="{{ $surgery->anesthesia_time ?? '' }}" class="form-control" placeholder="Anesthesia Name">
    </div>
</form>
<script>
    $(document).ready(function(){
        $('#admission_date').flatpickr({
            enableTime: true,
            dateFormat: "Y-m-d H:i",
            defaultDate: "now",
            clickOpens: true,
            onReady: function (selectedDates, dateStr, instance) {
                instance.setDate(new Date(), true);
            },
            onClose: function (selectedDates, dateStr, instance) {
                instance.close();
            }
        });

        //doctor select
        $('.doctor-select').autocomplete({
            autoFocus: true,
            minLength: 0,
            source: function(request, response) {
                if (request.term.length < 2) {
                    $('[name="anesthesia_doctor"]').val('');
                    return false;
                }

                $.ajax({
                    url: "{{ route('billings-search-doctors') }}",
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'get_patients_for_billing',
                        search_text: request.term
                    },
                    success: function(json) {
                        if (json.error) {
                            $('[name="anesthesia_doctor"]').val('');
                            return false;
                        }
                        response($.map(json.result, function(item) {
                            return {
                                id: item.id,
                                name: item.name,
                                code: item.code,
                                gender: item.gender ,
                                phone_no: item.phone_no,
                                date_of_birth: item.date_of_birth,
                            };
                        }));
                    }
                });
            },
            select: function(event, ui) {
                event.preventDefault();
                var age      = ui.item.date_of_birth != null ? ', ' + getAge(ui.item.date_of_birth) + ' Years' : '';
                var gender   = ui.item.gender != null ? ', ' + ui.item.gender : '';
                var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';

                $(this).val(ui.item.name + ' - (' + ui.item.code + ')' + gender + age + phone_no + "");
                $('[name="anesthesia_doctor"]').val(ui.item.id);
                return false;
            }
        }).data("ui-autocomplete")._renderItem = function(ul, item) {
            var age      = item.date_of_birth != null ? ', ' + getAge(item.date_of_birth) + ' Years' : '';
            var gender   = item.gender != null ? ', ' + item.gender : '';
            var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';

            return $("<li>")
                .append("<a>" + item.name + ' - (' + item.code + ')' + gender + age + phone_no + "</a>")
                .appendTo(ul);
        };
    });

    var doctorSelect  = document.querySelector(".doctor-select");
    var querySelector = document.querySelector(".searchResult");

    document.addEventListener("click", (event) => {
        if (event.target !== event.target !== doctorSelect && event.target !== querySelector) {
            $(".searchResult").empty();
        }
    });
</script>
