<form class="row g-3 auto-width create_surgery_team" action="{{ route('surgery-team-store' , $surgery->id) }}" id="create_surgery_team_form">
    @csrf
    @method('post')

    <div class="col-md-12">
        <div>
            <label class="form-label">Surgeon Team <span class="text-danger"><b>*</b></span></label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" name="doctor_name" id="doctor_name" class="doctor-select form-control" placeholder="Search Surgeon" autocomplete="off"
            value="{{ isset($opdBooking->getDoctorAccount->id) ? $opdBooking->getDoctorAccount->account_title->name ?? '' . ' ' . $opdBooking->getDoctorAccount->name ?? '' . ' - (' . $opdBooking->getDoctorAccount->code ?? '' . ')' : '' }}"
            {{ isset($opdBooking->getDoctorAccount->id) ? 'readonly' : '' }}>
            <ul class="searchResult"></ul>
            <input type="hidden" name="doctor_id" value="{{ $opdBooking->getDoctorAccount->id ?? '' }}">
            <div class="input-group-append" style="margin: auto 10px auto 0;">
            <button class="btn btn-secondary add_btn" id="create_doctor" type="button" data-bs-target="#commonModal"> + </button>
            </div>
        </div>
    </div>

    <div class="col-md-12">
        <label for="designation_id" class="form-label">Designation <span class="text-danger"><b>*</b></span></label>
        <select class="form-control" name="designation_id" id="designation_id" required>
            <option value="">Select Designation</option>
            @foreach($designations as $list)
                <option value="{{ $list->id }}">{{ $list->name }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-12">
        <label for="responsibility" class="form-label">Responsibility </label>
        <input type="text" name="responsibility" id="responsibility" class="form-control" placeholder="Responsibility">
    </div>

    <div class="row mt-3 mb-3">
        <div class="col-md-12 text-center">
            <button class="btn btn-primary text-center" type="submit" id="saveAssignTeamButton">Save Assigned Team</button>
        </div>
    </div>
</form> 






<div class="container mt-3">
    <p style="font-size: 14px; font-weight: bold;" class="text-center">Assigned Team</p>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th class="thbutton">Serial</th>
                <th>Surgent/Team Name</th>
            
                <th>Responsibility</th>
                <th class="thbutton">Action</th>
            </tr>
        </thead>
        <tbody id="assignTeamTable">
            @php $i = 1; @endphp
            @if($surgery_team->count() > 0)
                @foreach($surgery_team as $list)
            <tr>
                <td>{{ $i++ }}</td>
                <td class="text-left"> <b> {{ $list->surgent_name }}</b> <br>{{ $list->designation_name }}</td>

                <td class="text-left">{{ $list->responsibility }}</td>
                <td class="text-center">
                    <a data-url="{{ route('surgery-team-destroy', $list->id) }}" class="btn btn-danger deleteDataCustom" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete"><i class="bi bi-trash text-white"></i> </a>
                </td>
            </tr>
                @endforeach
            @else
            <tr class="text-center">
                 <td colspan="4" class="text-center">No Assigned Team</td>
            </tr>
                
            @endif
            
            
        </tbody>
    </table>
</div>





<script>
    
    $(document).ready(function(){
        $('#admission_date').flatpickr({
            enableTime: true,
            dateFormat: "Y-m-d H:i",
            defaultDate: "now",
            clickOpens: true,
            onReady: function (selectedDates, dateStr, instance) {
                instance.setDate(new Date(), true);
            },
            onClose: function (selectedDates, dateStr, instance) {
                instance.close();
            }
        });

        //doctor select
        $('.doctor-select').autocomplete({
            autoFocus: true,
            minLength: 0,
            source: function(request, response) {
                if (request.term.length < 2) {
                    $('[name="doctor_id"]').val('');
                    return false;
                }

                $.ajax({
                    url: "{{ route('billings-search-doctors') }}",
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'get_patients_for_billing',
                        search_text: request.term
                    },
                    success: function(json) {
                        if (json.error) {
                            $('[name="doctor_id"]').val('');
                            return false;
                        }
                        response($.map(json.result, function(item) {
                            return {
                                id: item.id,
                                name: item.name,
                                code: item.code,
                                gender: item.gender ,
                                phone_no: item.phone_no,
                                date_of_birth: item.date_of_birth,
                            };
                        }));
                    }
                });
            },
            select: function(event, ui) {
                event.preventDefault();
                var age      = ui.item.date_of_birth != null ? ', ' + getAge(ui.item.date_of_birth) + ' Years' : '';
                var gender   = ui.item.gender != null ? ', ' + ui.item.gender : '';
                var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';

                $(this).val(ui.item.name + ' - (' + ui.item.code + ')' + gender + age + phone_no + "");
                $('[name="doctor_id"]').val(ui.item.id);
                return false;
            }
        }).data("ui-autocomplete")._renderItem = function(ul, item) {
            var age      = item.date_of_birth != null ? ', ' + getAge(item.date_of_birth) + ' Years' : '';
            var gender   = item.gender != null ? ', ' + item.gender : '';
            var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';

            return $("<li>")
                .append("<a>" + item.name + ' - (' + item.code + ')' + gender + age + phone_no + "</a>")
                .appendTo(ul);
        };
    });

    var doctorSelect  = document.querySelector(".doctor-select");
    var querySelector = document.querySelector(".searchResult");

    document.addEventListener("click", (event) => {
        if (event.target !== event.target !== doctorSelect && event.target !== querySelector) {
            $(".searchResult").empty();
        }
    });



</script>

