<div class="table-responsive">
  <div class="d-flex justify-content-between">
    <h5 class="mb-0">Surgery/Procedure Details</h5>

    <button type="button" class="btn btn-primary" id="addSurgery" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus-circle"></i> Add New</button>
  </div>
  <hr class="mb-2">
  <table id="example" class="table table-bordered align-middle" style="width:100%">
    <thead class="table-light">
      <tr>
        <th class="thbutton">Serial No</th>
        <th>Surgery Type</th>
        <th>Surgeon</th>
        <th>Notes</th>
        <th>Scheduled Date Time</th>
        <th>Surgery Team</th>
        <th>Anesthesia</th>
        <th class="thbutton">Edit</th>
        <th class="thbutton">Delete</th>
      </tr>
    </thead>
    <tbody>
      @php 
      $i = 1;  
      @endphp

       @if(isset($surgeries) && count($surgeries)>0)
        @foreach ($surgeries as $list)
        <tr>
          <td class="text-left">{{ $i++ }}</td>
          <td class="text-left">{{ $list->surgery_type_name ? $list->surgery_type_name : ''}} </td>
          <td class="text-left">{{ $list->surgent_name ? $list->surgent_name : ''}} </td>
          <td class="text-left">{{ $list->note ? $list->note : ''}} </td>
          <td class="text-left">{{ $list->scheduled_date_time ? $list->scheduled_date_time : ''}} <br>{{ $list->duration_time ? $list->duration_time : ''}} Minutes</td>

          <td class="text-center">
              <button data-id="{{ $list->id}}" class="btn btn-sm btn-primary" id="assignTeam" data-bs-toggle="modal" data-bs-target="#commonModal"></i> Assign Team
              </button>
          </td>
          <td class="text-center">
              <button data-id="{{ $list->id}}" class="btn btn-sm btn-primary anesthesia-create" data-bs-toggle="modal" data-bs-target="#commonModal"></i> Anesthesia
              </button>
          </td>

          <td class="text-center">
              <button data-id="{{ $list->id }}" class="btn btn-sm btn-outline-secondary editSurgery" data-bs-toggle="modal" id="editSurgery" data-bs-target="#commonModal" title="Edit">
                <i class="bi bi-pencil-square"></i>
              </button>
          </td>

          <td class="text-center">
            <a data-url="{{route('ipd-surgeries.destroy' , $list->id)}}" class="btn btn-sm btn-danger deleteDataCustom" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
              <i class="bi bi-trash text-white"></i>
            </a>
          </td>
        </tr>
        @endforeach
        @else
          <tr>
              <td colspan="10">No Data Found</td>
          </tr>
        @endif
    </tbody>
  </table>
</div>