<form class="row g-3 auto-width create_symptom" id="create_symptom_form" action="{{ route('ipd-admission-symptoms.store', $id) }}" method="post" >
    @csrf
    @method('post')

        <div class="col-md-12">
            <input type="hidden" name="symptom_id" value="{{ $symptom->id ?? '' }}">
            <div>
                <label class="form-label">Diagnosis Title <span class="text-danger"><b>*</b></span></label>
            </div>
            <div class="input-group autocomplete">
                <input type="text" id="symptom_id" class="symptoms-select form-control" placeholder="Search Symptom Title" value="@if(isset($symptom->id)){{ $symptom->symptoms_title ?? '' }} - {{ $symptom->code ?? '' }}@endif" {{ isset($symptom->id) ? 'readonly' : '' }}>
                <ul class="searchResult"></ul>
                <input type="hidden" name="symptom_id" value="{{ $symptom->id ?? '' }}">
            </div>
        </div>

    <div class="col-md-12">
        <label for="primary_diagnosis" class="form-label">Primary Diagnosis</label>
        <textarea rows="5" class="form-textarea" name="primary_diagnosis" placeholder="Primary Diagnosis" id="primary_diagnosis"></textarea>
    </div>

    <div class="col-md-12">
        <label for="secondary_diagnosis" class="form-label">Secondary Diagnosis</label>
        <textarea rows="5" class="form-textarea" name="secondary_diagnosis" placeholder="Secondary Diagnosis" id="secondary_diagnosis"></textarea>
    </div>
</form>


<script>
    $(document).ready(function() {
        $('.symptoms-select').autocomplete({
            autoFocus: true,
            minLength: 0,
            source: function(request, response) {
                if (request.term.length < 2) {
                    $('[name="symptom_id"]').val('');
                    return false;
                }

                $.ajax({
                    url: "{{ route('search-symptoms') }}",
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        search_text: request.term
                    },
                    success: function(json) {
                        if (json.error) {
                            $('[name="symptom_id"]').val('');
                            return false;
                        }
                        response($.map(json.result, function(item) {
                            return {
                                id: item.id,
                                name: item.symptoms_title,
                                code: item.code
                            };
                        }));
                    }
                });
            },
            select: function(event, ui) {
                event.preventDefault();

                var symptoms_title = ui.item.name ? ui.item.name : '';
                var code           = ui.item.code ? ' - (' + ui.item.code + ')' : '';

                $(this).val(symptoms_title + code);
                $('[name="symptom_id"]').val(ui.item.id);
                return false;
            }
        }).data("ui-autocomplete")._renderItem = function(ul, item) {
            var symptoms_title = item.name ? item.name : '';
            var code           = item.code ? ' - (' + item.code + ')' : '';

            return $("<li>")
                .append("<a>" + code + symptoms_title + "</a>")
                .appendTo(ul);
        };
    });

    const SymptomsSelect = document.querySelector(".symptoms-select");
    document.addEventListener("click", (event) => {
        if (event.target !== SymptomsSelect) {
            $(".searchResult").empty();
        }
    });
</script>