@extends('layouts.app')
@section('title', $voucher_type->name . ' - '. ($sale_invoice->main_invoice_no ?? '') . ' - '. (isset($sale_invoice->invoice_date) && $sale_invoice->invoice_date ? formatedDate($sale_invoice->invoice_date) : '') . ' - ' . ($admission->getPatient->name ?? ''))
@section('pages')
<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />
@php $pageTitle =  ($sale_invoice->main_invoice_no ?? '') . ' - ' .($admission->getPatient->name ?? '').'-'. (isset($sale_invoice->invoice_date) && $sale_invoice->invoice_date ?
formatedDate($sale_invoice->invoice_date) : '') ; @endphp
<style type="text/css">
    .pathology-bill .increase-font td{
        font-size: 13px !important
    }
</style>
<div id="btn_back" class="card-header py-3">
    <div class="row gx-2">
        <div class="col-lg-6 col-md-6 col-6">
            <div class="position-relative">
                <h5>Discharge Certificate - {!! $admission->getPatient->account_title->name ?? '' !!} {!! $admission->getPatient->name ?? '' !!} (
                    {!! $admission->getPatient->code ?? '' !!}) <br>
                </h5>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="ms-auto float-md-end">
                <div class="btn-group">
                    <a href="{{ route('ipd-admissions.patientdischargeedit', $admission->id) }}"  class="btn btn-warning" title="Edit">
                        <i class="bi bi-pencil-square"></i> Edit Discharge
                    </a>
                </div>
                <div class="btn-group">
                    <a href="{{ request()->get('redirect_route') != '' ? route(request()->get('redirect_route')) : route('ipd-admissions.show',$admission->id) }}" class="btn btn-outline-secondary me-1">
                        <i class="bx bx-arrow-back ms-0 me-1"></i>Back
                    </a>
                   
                    {{-- @if(in_array('ipd-admission-create', $authRolePermissions)) --}}
                      {{-- <a href="{{ route('ipd-admissions.create') }}" class="btn btn-primary"><i class="bx bx-plus"></i> New Admission</a> --}}
                      {{-- @endif --}}
                        {{-- @if(!is_null($ipd_id ?? ''))
                            <div class="float-md-end" style="margin-right: 10px">
                                <a href="{{ route('ipd-billings.create', $ipd_id ?? '') }}" class="btn btn-info new-bill">
                                    <i class="bx bx-plus text-white"></i> New Intent
                                </a>
                            </div>
                        @endif --}}
                </div>
            </div>
        </div>
    </div>
</div>
    <div id="print_div">
        <div class="pathology-bill">
            <div class="row mt-2">
                <div class="col-md-12 col-xs-12 p-1">
                    <div class="card border-0">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <table class="table table-borderless report-container" {!! request()->segment(2) == 'discharge-statement' ? '' : 'mb-1' !!}>
                                    @php $company = @$sale_invoice->getCompany;@endphp
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell" style="font-weight: normal;">
                                                @if(isset($company->id))
                                                    <x-CompanyLetterHead :company="$company" />
                                                @endif
                                                @php $voucherType = 'PATHOLOGY_LAB_BILLING'; @endphp
                                                @php $saleInvoice = $sale_invoice; @endphp
                                                @php $voucherTitle = "Ipd Discharge Statement"; @endphp
                                                @if(isset($sale_invoice->main_invoice_no))
                                                @include('components.ipd-specific-print-voucher-details')
                                                @endif
                                            </th>
                                        </tr>
                                    </thead>
                                    <tfoot class="report-footer">
                                        <tr>
                                            <td class="report-footer-cell">
                                            </td>
                                        </tr>
                                    </tfoot>
                                        
                                    </table>
                                </div>
                            </div>

                             <div class="row mx-2 ">
                                <table class="table table-borderless increase-font" >
                                    @if(!empty($admission->chief_complaint))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Chief Complaint</td>
                                        <td> : </td>
                                        <td>{!! $admission->chief_complaint ? $admission->chief_complaint : '' !!}</td>
                                    </tr>
                                    @endif
                                    @if(!empty($admission->history_of_illness))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">History of Illness</td>
                                        <td> : </td>
                                        <td>{!! $admission->history_of_illness ? $admission->history_of_illness : '' !!}</td>
                                    </tr>
                                    @endif
                                    @if(!empty($vital_history_admission))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold">On-Examination At Admission</td>
                                        <td>:</td>
                                        <td>
                                            @php 
                                              $body_vital_data = json_decode($vital_history_admission->body_vital_value,true);
                                            @endphp

                                            <p>
                                            @foreach($body_vital_data as $vital_key => $value)
                                                @if(!empty($value))
                                                <b>{!! $body_vital[$vital_key] ?? '' !!}:</b> {!! $value !!} {!! end($body_vital_data) == $value ? '' : ', ' !!}
                                                @endif
                                            @endforeach</p>
                                        </td> 
                                    </tr>
                                    @endif
                                    @if(!empty($vital_history_in_patient))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold">On-Examination At In-Patient</td>
                                        <td>:</td>
                                        <td>
                                            @php 
                                              $body_vital_data = json_decode($vital_history_in_patient->body_vital_value,true);
                                            @endphp

                                            <p>
                                            @foreach($body_vital_data as $vital_key => $value)
                                                @if(!empty($value))
                                                <b>{!! $body_vital[$vital_key] ?? '' !!}:</b> {!! $value !!} {!! end($body_vital_data) == $value ? '' : ', ' !!}
                                                @endif
                                            @endforeach</p>
                                        </td> 
                                    </tr>
                                    @endif
                                    @if(!empty($vital_history_discharge))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold">On-Examination At Discharge</td>
                                        <td>:</td>
                                        <td>
                                            @php 
                                              $body_vital_data = json_decode($vital_history_discharge->body_vital_value,true);
                                            @endphp

                                            <p>
                                            @foreach($body_vital_data as $vital_key => $value)
                                                @if(!empty($value))
                                                <b>{!! $body_vital[$vital_key] ?? '' !!}:</b> {!! $value !!} {!! end($body_vital_data) == $value ? '' : ', ' !!}
                                                @endif
                                            @endforeach</p>
                                        </td> 
                                    </tr>
                                    @endif

                                    @if(!empty($billing_report) && count($billing_report) > 0)
                                     <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold"> Investigation </td>
                                        <td>:</td>
                                        <td>
                                            {{-- @foreach($products as $product)
                                                <p>{{$product->name}}</p>
                                            @endforeach --}}

                                            @foreach($billing_report as $test_packages)
                                                <b>{{$test_packages['billing_report'][0]->test_package ?? ''}} | {{ formatedDate(@$test_packages['billing_report'][0]->created_at) ?? ''}}</b>
                                                <p>
                                                @foreach($test_packages['billing_report'] as $items)
                                                    {{$items->test_item}} : {{ $items->long_result ?? $items->result }} {{$items->unit}}@if($loop->last)
                                                        </p>
                                                    @else,
                                                    @endif
                                                @endforeach
                                            @endforeach
                                        </td>
                                    </tr>
                                    @endif
                                    @if(isset($admission->other_investigations))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold">Other Investigations </td>
                                        <td>:</td>
                                        <td>
                                            {!! ucfirst($admission->other_investigations) ?? '' !!}
                                        </td>
                                    </tr>
                                    @endif
                                    @if(isset($symptom->symptoms_title))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold">Diagnosis </td>
                                        <td>:</td>
                                        <td>
                                            <b>{!! $symptom->symptoms_title ?? '' !!} ({!! $symptom->getSymptomType->symptoms_type ?? '' !!} Code: {!! $symptom->code ?? '' !!})</b>
                                        </td>
                                    </tr>
                                    @endif
                                    @if(isset($admission->primary_diagnosis))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold">Primary Diagnosis </td>
                                        <td>:</td>
                                        <td>
                                            {!! ucfirst($admission->primary_diagnosis) ?? '' !!}
                                        </td>
                                    </tr>
                                    @endif
                                    @if(isset($admission->secondary_diagnosis))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold">Secondary Diagnosis </td>
                                        <td>:</td>
                                        <td>
                                            {!! ucfirst($admission->secondary_diagnosis) ?? '' !!}
                                        </td>
                                    </tr>
                                    @endif
                                    @if(!empty($admission->treatment_type))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Treatment Type</td>
                                        <td> : </td>
                                        <td>{!! $admission->treatment_type  ? $admission->treatment_type : '' !!}</td>
                                    </tr>
                                    @endif
                                    @if(!empty($admission->treatment_details))
                                          {{--Treatment Details--}} 
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Treatment Details</td>
                                        <td> : </td>
                                        <td>{!! $admission->treatment_details ? $admission->treatment_details : ''!!}</td>
                                    </tr>
                                    @endif
                                   @if($surgery)
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Date of Surgery </td>
                                        <td> : </td>
                                        <td>{{ $surgery->scheduled_date_time ? $surgery->scheduled_date_time : ''}}</td>
                                    </tr>

                                     {{--Procedure--}} 
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Procedure </td>
                                        <td> : </td>
                                        <td>{!! $surgery->surgery_type_name  ? $surgery->surgery_type_name : ''!!}</td>
                                    </tr>
                                    @else
                                    @endif
                                       
                                    @if(!empty($data->course_during_hosp))
                                    {{--Post operative--}} 
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Course During Hospitality</td>
                                        <td> : </td>
                                        <td>{!! $data->course_during_hosp ? $data->course_during_hosp : '' !!}</td>
                                    </tr>
                                    @endif
                                       
                                    @if(!empty($data->post_operation))
                                    {{--Post operative--}} 
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Post Operative</td>
                                        <td> : </td>
                                        <td>{!! $data->post_operation ? $data->post_operation : '' !!}</td>
                                    </tr>
                                    @endif

                                     {{--Anesthesia--}} 
                                    @if(!empty($surgery->anesthesia_name))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Anesthesia</td>
                                        <td> : </td>
                                        <td>{!! $surgery->anesthesia_name ?? '' !!} <br> BY : {!! $surgery->getDoctor->name ?? '' !!}</td>
                                    </tr>
                                    @endif

                                    @if(!empty($data->condition_of_discharge))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold"> Condition of discharge </td>  <td> :</td> <td>{!! isset($data) ? $data->condition_of_discharge : '' !!}</td> 
                                    </tr>
                                    @endif

                                    @if(!empty($data->advise_on_discharge))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Advice on Discharge</td>
                                        <td> : </td>
                                        <td>{!! isset($data) ? $data->advise_on_discharge : '' !!}</td>
                                    </tr>
                                    @endif
                                    @if (!empty($data->next_follow_up_date))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Follow-up</td>
                                        <td> : </td>
                                        <td> {{ isset($data) ? $data->next_follow_up_date : '' }} </td> 
                                    </tr>
                                    @endif

                                    @if(!empty($data->special_note))
                                   {{--Special Note--}}
                                     <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold"> Special note ( if any )</td>  <td>:</td> <td>{!! isset($data) ? $data->special_note : '' !!}</td> 
                                    </tr>
                                    @endif
                                    @if($surgery)
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Surgeon </td>
                                        <td> : </td>
                                        <td>{{ $surgery->surgent_name }}</td>
                                    </tr>
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Surgery Notes </td>
                                        <td> : </td>
                                        <td>{!! $surgery->note !!}</td>
                                    </tr>
                                    @else
                                    @endif
                                    @if(!empty($settings))
                                    @foreach($settings as $list)
                                        <tr style="border-width: 10px;border-color: transparent;">
                                            <td class="fw-bold">{{ ucfirst($list->field )}} </td>  <td>:</td><td>{!!$list->default_value!!}</td> 
                                        </tr>
                                    @endforeach
                                    @endif
                                    @if(!empty($data->name))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Discharge type </td>
                                        <td> : </td>
                                        <td>{!! $data->name !!}</td>
                                    </tr>
                                    @endif
                                    @if(!empty($data->explained_by))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Explained By</td>
                                        <td> : </td>
                                        <td>{!! $data->explained_by ? $data->explained_by : ''!!}</td>
                                    </tr>
                                    @endif

                                    @if(!empty($data->understood_by))
                                    <tr style="border-width: 10px;border-color: transparent;">
                                        <td class="fw-bold" style="width: 20%;">Understood By</td>
                                        <td> : </td>
                                        <td>{!! $data->understood_by ? $data->understood_by : ''!!}</td>
                                    </tr>
                                    @endif
                                   
                                </table>
                            </div>

                            <div class="row" style="margin:10px">
                                <div class="col-6" style="margin-bottom:10px">
                                    <p><u><b>Admitting Doctor</b></u></p>
                                    <h6>{!! $consultant->account_title !!} {!! $consultant->name !!}</h6>
                                    <p>{!! $consultant->qualifications !!}</p>
                                </div>
                                @if(isset($data->doc_name))
                                <div class="col-6" style="margin-bottom:10px">
                                    <p><u><b>Signed By Doctor</b></u></p>
                                    <h6>{!! $data->doc_title ?? '' !!} {!! $data->doc_name ?? '' !!}</h6>
                                    <p>{!! $data->qualifications ?? '' !!}</p>
                                </div>
                                @endif
                            </div>
                            <div>
                                <p style="margin-left:10px;font-weight: 500; font-size: small;">I have been explained about the disease, drugs, investigations and need for close follow up in the language best known /
                            understood by me
                            </p>
                             </div>
                             <div>
                                <p style="margin-left:10px;font-weight: 800; font-size: small;">Signature (Patient/ Patient Party) if patient party then Relation
                            </p>
                             </div>
                           </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="text-center">
    <button id="btn_print" type="button" class="btn btn-primary btn-lg"> Print Document <i class="bi bi-printer text-white"></i></button>
</div>
@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('#btn_back').hide();
            printInvoice();
            return;
            // printInvoice(page_title);
            /*$('#print_div').printThis({
                importStyle: true,
            });*/
            $(this).hide();
            var printContents       = document.getElementById('print_div').innerHTML;
            var originalContents    = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;

            $(this).show();
            $('#btn_back').show();
            $('#btn_print').show();
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage   = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth  = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf       = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content  = window.open('', '', 'height=750px,width=960px');
        let doc      = content.document;
        let head     = doc.head;
        let body     = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
</script>


@endsection
