@extends('layouts.app')
@section('title','IPD Admission')
@section('pages')
<style type="text/css">
  .breadcrumb-title {
    border-right: none;
  }

  .dataTables_filter {
    margin-bottom: 6px;
  }

  .ui-switcher {
    background-color: #da2a2a35;
    display: inline-block;
    height: 25px;
    width: 72px;
    border-radius: 50px;
    box-sizing: border-box;
    vertical-align: middle;
    position: relative;
    cursor: pointer;
    transition: border-color 0.25s;
    margin: 0;
    box-shadow: none;
  }

  .ui-switcher[aria-checked=false]:before {
    color: #da2a2a90;
    content: 'WAITING';
    right: 29px;
    font-size: 12px;
    font-weight: 700;
  }

  .ui-switcher[aria-checked=true]:before {
    color: #12bf2490;
    content: 'CONFIRM';
    left: 7px;
    font-size: 12px;
    font-weight: 700;
  }

  .ui-switcher {
    background-color: #da2a2a35;
    display: inline-block;
    height: 25px;
    width: 77px;
    border-radius: 50px;
    box-sizing: border-box;
    vertical-align: middle;
    position: relative;
    cursor: pointer;
    transition: border-color 0.25s;
    margin: 0;
    box-shadow: none;
  }

  .ui-switcher[aria-checked=true]:after {
    left: 57px;
    font-size: 13px;
    font-weight: 600;
  }
</style>
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.20/jquery.datetimepicker.css" integrity="sha512-bYPO5jmStZ9WI2602V2zaivdAnbAhtfzmxnEGh9RwtlI00I9s8ulGe4oBa5XxiC6tCITJH/QG70jswBhbLkxPw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<!--breadcrumb-->
<div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
  <div class="breadcrumb-title col-md-6"> IPD Admission
  </div>
  <div class="col-md-6">
    <nav aria-label="breadcrumb">
      <ol class="breadcrumb justify-content-md-end mb-0">
        <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="42" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
        <li class="breadcrumb-item" aria-current="page">IPD Admission</li>
        <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Admission Details </li>
      </ol>
    </nav>
  </div>
</div>

@php
$show_checklist_btn = 1;

if ((in_array('PATHOLOGY', $departments) && ($total_reports > $doneReports)) || $admission->ipd_checklist_verified == 1) {
$show_checklist_btn = 0;
}
@endphp
<!--end breadcrumb-->
<div class="card style_table shadow-none radius-5 min-height my-auto">
  <div class="card-header py-3">
    @include('layouts.partials.nav-menu')
    <div class="row gx-2">
      <div class="col-lg-4 col-md-4">
        <h5 class="mb-0">
          {{ $patient->account_title ? $patient->account_title->name : '' }}
          {{ $patient->name ? $patient->name : '' }}
          ({{ $patient->code }})
        </h5>
      </div>
      <div class="col-lg-8 col-md-5">
        <div class="ms-auto float-md-end">

          {{-- @if($admission->ipd_checklist_verified == 1) --}}
          <div class="btn-group">
            <a href="{{ route('ipd-admissions.patientdischargeedit', $admission->id) }}" class="btn btn-warning bg-warning"><i class="bi bi-box-arrow-right"></i>
              Edit Discharge
            </a>
          </div>
          {{-- @endif --}}
          <div class="btn-group verify-checklist" style="display: none">
            <a href="{{ route('ipd-checklist-verify', $admission->id) }}" class="btn btn-success me-1"><i class="bx bx-check-circle ms-0 me-1"></i>Verify For Discharge</a>
          </div>

          @if(!empty($dischargeExists) && isset($saleInvoice->id) )
          <div class="btn-group">
            <a href="{{ route('ipd-admissions.dischargestatement', $admission->id) }}" class="btn btn-dark bg-dark">Discharge Statement</a>
          </div>
          @endif
          @php $redirect = request()->redirect;
                  $id  = request()->segment(3) ;
          $redirect = $redirect .'/'. $id;
          @endphp
          <div class="btn-group">
            <a href="{!! route('ipd-admissions.show', $admission->id) !!}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class="shadow-none radius-5 min-height">
      <div class="row">
        {{--<div class="col-md-12">
          <div class="card">
            <div class="card-body g-3 row">
              <div class="table-responsive">
                <div>
                  <strong>Age</strong>: {{age($patient->account_contact->date_of_birth).' years'}},
                  <strong>Gender</strong>: {{$patient->account_contact->gender->name ?? ''}},
                  <strong>Date Of Birth</strong>: {{formatedDate($patient->account_contact->date_of_birth) ?? ''}},
                  <strong>Marital Status</strong>: {{$marital_status->name ?? ''}},
                  <strong>Blood Group</strong>: {{$blood_group->group ?? ''}}<br>
                  @if($patient->account_contact->any_known_allergies)
                  <strong>Any Known Allergies</strong>: {{$patient->account_contact->any_known_allergies}}<br>
                  @endif
                  @if($admission->note)
                  <strong>Admission Note</strong>: {{$admission->note}}
                  @endif
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-5">
          <div class="card">
            <div class="card-body g-3">
              <div class="table-responsive">
                <div class="d-flex justify-content-between">
                  <h5 class="mb-0">Admission Details</h5>
                </div>
                <hr class="mb-2">
                <table class="table table-bordered align-middle">
                  <tr class="fw-bold">
                    <td style="text-align:left;">Admission No </td>
                    <td>{{$admission->ipd_admission_no}}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left;">IPD CASE/FILE NUMBER</td>
                    <td>{{$admission->ipd_file_no ?? 'N/A'}}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left;">Patient Name </td>
                    <td>{{$patient->account_title->name ?? '' }}{{ $patient->name ?? ' '}}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left;">Admission Date</td>
                    <td>{!!formatedDateTime($admission->admission_date_time)!!}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left;">Referred By</td>
                    <td>{{$admission->referal_from ?? 'N/A'}}</td>
                  </tr>
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-5">
          <div class="card">
            <div class="card-body g-3 row">
              <div class="table-responsive">
                <h5 class="mb-0">Additional Details</h5>
                <hr class="mb-2">
                <table class="table table-bordered align-middle">
                  <tr>
                    <td style="text-align:left;">Previous medical issue</td>
                    <td>{{$admission->previous_medical_issue ?? 'N/A'}}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left;">Patient source</td>
                    <td>{{$patient_source->enquiry_source_name}}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left;">TPA</td>
                    <td>{{$tpa_account->name ?? 'N/A'}}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left;">Referral partner</td>
                    <td>{{$refferal_partner->name ?? 'N/A'}}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left;">Casualty</td>
                    <td>{{($admission->casualty == '1') ? 'Yes' : 'No'}}</td>
                  <tr>
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-2">
          <div class="card">
            <div class="card-body g-3 row">
              <div class="table-responsive" style="margin-bottom: 18px;">
                @if(isset($patient->account_images->image) && $patient->account_images->image != '')
                <img src="{!! getTempUrl($patient->account_images->image) !!}" height="auto" id="createImage" data-bs-toggle="modal" data-bs-target="#commonModal" style="cursor: pointer;max-width: 120px;width: 120px;">
                @else
                <img src="{!! asset('admin/images/avtaar.png') !!}" width="100%" height="auto" id="createImage" data-bs-toggle="modal" data-bs-target="#commonModal" style="cursor: pointer;max-width: 120px;width: 120px;">
                @endif
                <p class="pt-3" style="cursor: pointer;"><strong>Update Profile Image</strong></p>
              </div>
            </div>
          </div>
        </div>--}}
        <div class="col-md-12">
          <div class="card">
            <table id="example" class="table table-bordered align-middle" style="width:100%">
              <thead class="table-light">
                <tr>
                  <th class="thbutton">Sl No</th>
                  <th>Invoice No.</th>
                  <th>Consultant</th>
                  <th>Bed</th>
                  <th style="text-align:right">Bill Amount</th>
                  <th class="thbutton">Status</th>
                  <th class="thbutton">Balance</th>
                </tr>
              </thead>
              <tbody>
                @php $i=1;@endphp
                @if(count($saleInvoices)>0)
                @foreach($saleInvoices as $key => $list)
                @php $Receive = TransactionCalculationReceiveAmount($list->id,'IPD_INVOICE'); @endphp
                <tr>
                  <td class="text-center">{{ $key+1 }}</td>
                  <td>
                    @if(isset($list->id) && $list->id!='')
                    <a href="{!! route('lab-billings.show', $list->id) !!}" class="hyperlink">
                      <b>{{$list->voucher_type_invoice_no??''}}</b>
                    </a>
                    @endif
                    <br>
                    {{ formatedDate($list->invoice_date) }}<br>
                    {{ formatedTime($list->invoice_date) }}
                  </td>
                  <td>{!! $list->getDoctor->name??'Self' !!}</td>
                  <td>{{ isset($pending_history) && isset($pending_history[0]->getBed->name) ?$pending_history[0]->getBed->name : 'N/A' }}</td>
                  <td style="text-align:right">Total: {{ convertDecimelPoint($Receive['totalBilling']) ?? ''}}<br>
                    Received: {{ convertDecimelPoint($Receive['receivedAmount']) ?? ''}}
                    @if($Receive['dueAmount']>0)
                    <br>
                    <span class="badge btn-secondary text-white"> Due: {{ convertDecimelPoint($Receive['dueAmount']) ?? ''}}</span>
                    @endif
                  </td>
                  <td class="text-center {{ isset($Receive['dueAmount']) && $Receive['dueAmount'] > 0 ? 'text-danger' : '' }}">{{ isset($Receive['dueAmount']) && $Receive['dueAmount'] > 0 ? 'Pending' : 'Paid' }}</td>
                  <td class="text-center">
                    {!! $Receive['dueAmount'] > 0 ? '<a href="' . route('billing-collection',['invoice_id'=>$admission->id,'voucher_type'=>'ipd-invoice']) .'?redirect=lab-billings" class="btn-sm btn-success text-white">Collect</a>' : '<i class="bi bi-check-circle text-success" style="font-size: 30px;" title="Amount Collected."></i>' !!}
                  </td>
                </tr>
                @php $i++; @endphp
                @php
                if (in_array('PATHOLOGY', $departments) && (isset($Receive['dueAmount']) && $Receive['dueAmount'] > 0)) {
                $show_checklist_btn = 0;
                }
                @endphp
                @endforeach
                @else
                <tr>
                  <td colspan="18" class="text-center">No Data Found</td>
                </tr>
                @endif
              </tbody>
            </table>
          </div>
        </div>
        <div class="col-md-12">
          <div class="card">
            <div class="card-body g-3 row">
              <div class="table-responsive">
                <h4>Invoice Summary </h4>
                <table class="table">
                  <tbody>
                    <tr>
                      <td width="3%"><b>SL.NO</b></td>
                      <td width="30%"><b>Date</b></td>
                      {{--<td class="text-start"><b>Mode</b> </td>--}}
                      <td class="text-start"><b>Mode</b> </td>
                      <td width="5%" style="text-align: right;"><b>Amount</b></td>
                    </tr>
                    @php $totalReceivedAmount = 0; @endphp
                    @foreach($transactionHistory as $key => $list)
                    <tr>
                      <td>{!! $key+1 !!}</td>
                      <td style="text-align: left;">{!! $list['transactionDate'] !!}</td>
                      {{--<td>
                                      {!! $list['transactionMode'] !!} 
                                    
                                  </td>--}}
                      <td>
                        {!! $list['paymentMode']??'' !!}
                        @if($list['advanceReceived']=='Yes')
                        (Advance)
                        @endif
                      </td>
                      <td class="text-right text-end">
                        @php $totalReceivedAmount+=$list['amount'] @endphp
                        {!! $list['amount'] !!}
                      </td>
                    </tr>

                    @endforeach
                    <tr>
                      <td colspan="3" class="text-start"><b>Total Received</b></td>
                      <td class="text-end"><b>{!! convertDecimelPoint($totalReceivedAmount) !!}</b></td>
                    </tr>
                    <tr>
                      <td colspan="3" class="text-start"><b>Balance Amount</b></td>
                      <td class="text-end"><b>{!! isset($transactionSummery['dueAmount']) && $transactionSummery['dueAmount']>0 ? convertDecimelPoint($transactionSummery['dueAmount']-$transactionSummery['discountAmount']) : 0 !!}</b></td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-12">
          <div class="card">
            <div class="card-body g-3 row">
              <div class="table-responsive">
                <h4>Collection Summary </h4>
                <table class="table tr mb-1">
                  <tbody>
                    <tr>
                      <td>BASIC
                        AMOUNT</td>
                      <td class="text-right text-end">
                        {!! isset($transactionSummery['totalBilling']) ? convertDecimelPoint($transactionSummery['totalBilling']) : '' !!}</td>
                    </tr>
                    @php
                    $gst_amount = $gst_amount ?? 0;
                    @endphp
                    @if($gst_amount>0)
                    <tr>
                      <td>TOTAL TAX
                      </td>
                      <td class="text-right text-end">
                        {!! convertDecimelPoint($gst_amount) ?? '' !!}</td>
                    </tr>
                    @endif
                    <tr>
                      <td>
                        SUBTOTAL
                      </td>
                      <td class="text-right text-end">
                        {!! convertDecimelPoint($transactionSummery['totalBilling'] + $gst_amount) ?? '' !!}</td>
                    </tr>
                    @if($transactionSummery['discountAmount']>0)
                    <tr>
                      <td>SPECIAL
                        DISCOUNT</td>
                      <td class="text-right text-end">
                        {!! convertDecimelPoint($transactionSummery['discountAmount']) ?? '' !!}</td>
                    </tr>
                    @endif
                    @php
                    $grand_total =
                    $transactionSummery['totalBilling'] +
                    $gst_amount -
                    (Integer)$transactionSummery['discountAmount'] ??
                    0;
                    @endphp
                    @if($transactionSummery['roundOffAmount']!=0)
                    <tr>
                      <td>Round OFF</td>
                      <td class="text-right text-end">
                        <b>{!! $transactionSummery['roundOffAmount'] !!}</b>
                      </td>
                    </tr>
                    @endif
                    <tr>
                      <td><b>GRAND
                          TOTAL</b></td>

                      <td class="text-right text-end">
                        <b>{!! convertDecimelPoint(round($grand_total)) !!}</b>
                      </td>
                    </tr>

                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!--end row-->
@endsection

@section('js')
<script type="text/javascript">
  $(document).ready(function() {
    var show_checklist_btn = '{!! $show_checklist_btn !!}';
    if (show_checklist_btn == 0) {
      $('.verify-checklist').remove();
    } else {
      $('.verify-checklist').show();
    }
  });
</script>
@endsection