@extends('layouts.app')
@section('title','IPD Billings')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>

  <!--breadcrumb-->
  <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
    <div class="breadcrumb-title col-md-6"> IPD Billings
    </div>
    <div class="col-md-6">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb justify-content-md-end mb-0">
          <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="28" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
          <li class="breadcrumb-item" aria-current="page">IPD-In Patient</li>
            <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> IPD Billing</li>
        </ol>
      </nav>
    </div>
  </div>
  <!--end breadcrumb-->

  <div class="card style_table shadow-none radius-5 min-height">
    <div class="card-header py-3">
      @include('layouts.partials.nav-menu')
      <div class="row gx-2">
        <div class="col-lg-3 col-md-3 col-8">
            <div class="position-relative">
                <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                <input class="form-control ps-5" type="search" id="search" placeholder="Search">
            </div>
        </div>

        <div class="col-lg-9 col-md-9">
          <div class="ms-auto float-md-end">

            <div class="btn-group">
                <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            </div>

          </div>
        </div>
      </div>
    </div>

    <div class="card-body" id="tables">
      <div class="table-responsive">
        <table id="example" class="table table-bordered align-middle" style="width:100%">
            <thead class="table-light">
                <tr>
                    <th class="thbutton">Sl No</th>
                    <th>Test Package</th>
                    <th>Created By</th>
                    <th>Edited By</th>
                    <th>Reviewed By</th>
                </tr>
            </thead>
            <tbody>
                @php $i=1;@endphp
                @if(count($sub_details)>0)
                    @foreach($sub_details as $key=> $list)
                        <tr>
                            <td>{{ 1 + $key}}</td>
                            <td>
                              {{$list->getTestPackage->name ?? ''}}
                            </td>
                            <td>
                              {{$list->getCreatedBy->name ?? ''}}<br>
                              {!! formatedDate($list->task_created_at) !!}
                            </td>
                            <td>{{$list->getEditedBy->name ?? ''}}<br>
                              {!! formatedDate($list->task_edited_at) !!}
                            </td>
                            <td>{{$list->getReviewedBy->name ?? ''}}<br>
                              {!! formatedDate($list->task_reviewed_at) !!}
                            </td>
                        </tr>
                        @php $i++; @endphp
                    @endforeach
                @else
                    <tr>
                        <td colspan="6">No Data Found</td>
                    </tr>
                @endif
            </tbody>
        </table>
      </div>
    </div>
  </div>
@endsection
