@extends('layouts.app')
@section('title','IPD Billing Report')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">

  <!--breadcrumb-->
  <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
    <div class="breadcrumb-title col-md-6"> IPD Billing Report
    </div>
    <div class="col-md-6">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb justify-content-md-end mb-0">
          <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="28" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
          <li class="breadcrumb-item" aria-current="page">IPD-In Patient</li>
            <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> IPD Billing</li>
        </ol>
      </nav>
    </div>
  </div>
  <!--end breadcrumb-->

  <div class="card style_table shadow-none radius-5 min-height">
    <div class="card-header py-3">
      @include('layouts.partials.nav-menu')
      <div class="row gx-2">
        <div class="col-lg-12 col-md-12">
          <div class="ms-auto float-md-end">

            <div class="btn-group">
                <a href="{!! route('lab-billings.index') !!}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                <button class="btn btn-outline-secondary me-1" id="reset-all"><i class="bi bi-arrow-clockwise ms-0 me-1"></i>Reset All</button>
            </div>

          </div>
        </div>
      </div>
    </div>
    <div class="card-header py-3">
      <div class="row gx-2">
        <div class="row py-1 m-0">
          <div class="col-4 row border-right border-dark">
            <table>
              <tbody>
                <tr>
                  <td>Patient Name </td>
                  <td>: <b>{!! $sale_invoice->getPatient->name ?? '' !!}</b></td>
                </tr>
                <tr>
                  <td>Sex/Age </td>
                  <td>: <b>{!! $sale_invoice->getPatient->account_contact->gender->name ?? '' !!}</b></td>
                </tr>
                <tr>
                  <td>Address </td>
                  <td>: <b>{!! $sale_invoice->getPatient->first_account_address->address_line1 ?? '' !!}</b></td>
                </tr>
                <tr>
                  <td>State Name </td>
                  <td>: <b>{!! $sale_invoice->getPatient->first_account_address->state->name ?? '' !!}</b></td>
                </tr>
              </tbody>
            </table>
          </div>
          <div class="col-5 row">
            <table>
              <tbody>
                <tr>
                  <td>Patient ID </td>
                  <td>: <b>{!! $sale_invoice->main_invoice_no ?? '' !!}</b></td>
                </tr>
                <tr>
                  <td>Phone No </td>
                  <td>: <b>{!! $sale_invoice->getPatient->account_contact->phone_no ?? '' !!}</b></td>
                </tr>
              </tbody>
            </table>
          </div>
          <div class="col-2 text-center pt-1" style="width:auto !important;">
              <div class="">
                  {!! DNS1D::getBarcodeHTML($sale_invoice->main_invoice_no, 'C93') !!}
                  <h4>{!! $sale_invoice->main_invoice_no ?? '' !!}</h4>
              </div>
         </div>
        </div>
      </div>
    </div>
    @php
      $gender = $sale_invoice->getPatient->account_contact->account_gender_id ?? '1';
      $date_of_birth = $sale_invoice->getPatient->account_contact->date_of_birth ?? '';
      $age           = $date_of_birth != '' ? age($sale_invoice->getPatient->account_contact->date_of_birth) : 0;
    @endphp
    <div class="card-body">
        <div class="row auto">
            <div class="col-xl-12 mx-auto">
                <div class=" shadow-none radius-5 min-height p-4">
                  <form class="row auto-width mt-0" action="{{ route('ipd-billing-report.store',$sale_invoice->id)}}" method="post" enctype='multipart/form-data' id="billing_report">

                    <div class="row auto-width p-2">
                        @csrf
                        @foreach($testPackages as $key => $value)
                          <div class="d-flex align-items-center justify-content-center mb-0 mt-3">
                              <h5 class="mb-0">{!! $value['department_name'] ?? '' !!}</h5>
                          </div>
                          <hr>

                          <div class="col-md-12 row mb-3 m-2">
                            @foreach($value['test_packages'] as $test_packages)
                              <div class="d-flex align-items-center justify-content-between m-2">
                                  <h5 class="mb-0">{!! $test_packages->name ?? '' !!}</h5>
                                  <button class="btn btn-sm btn-light reset" type="button" data-id="{!! $test_packages->id ?? '' !!}"><b><i class="bi bi-arrow-clockwise"></i></b> Reset</button>
                              </div>
                              @foreach($test_packages->testPackageGroups as $testPackageGroup)
                                @php $serial = 1; @endphp
                                <table class="table table-bordered align-middle" style="border: 1px solid #dee2e6;">
                                  <thead class="table-light">
                                    <tr>
                                      <th width="10%">SL No</th>
                                      <th width="30%">Investigation</th>
                                      <th width="25%">Result</th>
                                      <th width="25%">Reference Range</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                @foreach($testPackageGroup->test_package_group_test_items as $items)
                                  <tr class="item-div package_{!! $test_packages->id ?? '' !!}">
                                    <td>{!! $serial !!}</td>
                                    <td>
                                      <label class="form-label" for="{!! $items->test_item->id !!}">{!! $items->test_item->test_name ?? '' !!}</label>
                                      <i>{!! $items->test_item->test_method_name ?? '' !!}</i>
                                    </td>
                                    <td>
                                      @if($items->test_item->reference_value_type == 'OPTIONS' && isset($items->test_item->testItemOption))
                                        <select class="form-select {!! $items->test_item->formula_code ?? '' !!}" name="test_results[{!! $items->test_package_id !!}][{!! $items->test_package_group_id !!}][{!! $items->test_item->id !!}]">
                                          <option value="">- Select -</option>
                                          @foreach($items->test_item->testItemOption as $option)
                                            <option value="{!! $option->name !!}" {!! isset($billing_report[$items->test_item->id]) ? matchSelected($billing_report[$items->test_item->id]->result, $option->name) : '' !!} style="
                                              color:{!! $option->styleType->font_color ?? '#000000' !!};
                                              background-color:{!! $option->styleType->bg_color ?? 'white' !!};
                                              text-decoration:{!! $option->styleType->text_decoration ?? 'none' !!};
                                              font-style:{!! $option->styleType->font_style ?? 'normal' !!};
                                              font-weight:{!! $option->styleType->font_weight ?? 'normal' !!};
                                              padding:{!! $option->styleType->font_padding ?? 'normal' !!};
                                              ">{!! $option->name !!}</option>
                                          @endforeach
                                        </select>
                                      @elseif($items->test_item->input_type == 'NUMBER' || $items->test_item->reference_value_type == 'RANGE')
                                        <input type="number" class="form-control {!! $items->test_item->reference_value_type == 'RANGE' ? 'range' : '' !!} {!! $items->test_item->formula_code ?? '' !!}" name="test_results[{!! $items->test_package_id !!}][{!! $items->test_package_group_id !!}][{!! $items->test_item->id !!}]" id="{!! $items->test_item->id !!}" placeholder="Test Result" value="{!! $billing_report[$items->test_item->id]->result ?? '' !!}">
                                      @elseif($items->test_item->input_type == 'TEXT')
                                        <input type="text" class="form-control {!! $items->test_item->formula_code ?? '' !!} {!! $items->test_item->reference_value_type == 'OPTIONS' ? 'option_input' : '' !!}" name="test_results[{!! $items->test_package_id !!}][{!! $items->test_package_group_id !!}][{!! $items->test_item->id !!}]" id="{!! $items->test_item->id !!}" placeholder="Test Result" value="{!! $billing_report[$items->test_item->id]->result ?? '' !!}">
                                      @elseif($items->test_item->input_type == 'TIME')
                                        <input type="time" class="form-control {!! $items->test_item->formula_code ?? '' !!}" name="test_results[{!! $items->test_package_id !!}][{!! $items->test_package_group_id !!}][{!! $items->test_item->id !!}]" id="{!! $items->test_item->id !!}" placeholder="Test Result" value="{!! $billing_report[$items->test_item->id]->result ?? '' !!}">
                                      @elseif($items->test_item->input_type == 'SUMMER_NOTE')
                                        <textarea class="summernote {!! $items->test_item->formula_code ?? '' !!}" id="{!! $items->test_item->id !!}" name="test_results[{!! $items->test_package_id !!}][{!! $items->test_package_group_id !!}][{!! $items->test_item->id !!}]">{!! $billing_report[$items->test_item->id]->result ?? '' !!}</textarea>
                                      @elseif($items->test_item->input_type == 'IMAGE')
                                        <input type="file" class="form-control {!! $items->test_item->formula_code ?? '' !!}" name="test_results[{!! $items->test_package_id !!}][{!! $items->test_package_group_id !!}][{!! $items->test_item->id !!}]" id="{!! $items->test_item->id !!}" placeholder="Test Result" accept="image/*">
                                      @elseif($items->test_item->input_type == 'PDF')
                                        <input type="file" class="form-control {!! $items->test_item->formula_code ?? '' !!}" name="test_results[{!! $items->test_package_id !!}][{!! $items->test_package_group_id !!}][{!! $items->test_item->id !!}]" id="{!! $items->test_item->id !!}" placeholder="Test Result" accept=".pdf">
                                      @else
                                        <input type="text" class="form-control {!! $items->test_item->formula_code ?? '' !!}" name="test_results[{!! $items->test_package_id !!}][{!! $items->test_package_group_id !!}][{!! $items->test_item->id !!}]" id="{!! $items->test_item->id !!}" placeholder="Test Result" value="{!! $billing_report[$items->test_item->id]->result ?? '' !!}">
                                      @endif
                                      <span class="text-danger error_testitem" style="display:none;">This field is required.</span>
                                    </td>
                                      <td>
                                        @if($items->test_item->reference_value_type == 'RANGE' && isset($items->test_item->testItemNormalRange))
                                          @foreach($items->test_item->testItemNormalRange->where('gender_id', $gender) as $range)
                                            @if($age >= $range->from_age && $age <= $range->to_age)
                                              Range({!! ceil($range->low_value) !!} - {!! ceil($range->high_value) !!})<br>
                                              <input type="hidden" name="" class="range-start" value="{!! ceil($range->low_value) !!}">
                                              <input type="hidden" name="" class="range-end" value="{!! ceil($range->high_value) !!}">
                                              @php break; @endphp
                                            @endif
                                          @endforeach
                                        @endif

                                        @if($items->test_item->reference_value_type == 'TEXT' && $items->test_item->reference_value != '')
                                          Ref({!! $items->test_item->reference_value !!})<br>
                                        @endif
                                      </td>
                                    </tr>
                                    @php $serial += 1; @endphp
                                  @endforeach
                                </tbody>
                                </table>
                              @endforeach
                            @endforeach
                          </div>
                        @endforeach

                        {{-- @foreach($sale_invoice->getSaleInvoiceDetailWithProductTestPackage as $key => $value)
                          <div class="d-flex align-items-center justify-content-between my-3">
                              <h5 class="mb-0">Product: {!! $value->getProduct->name ?? '' !!}</h5>
                          </div>
                          <div class="col-md-12 row m-2 ProductTestPackage">
                            @foreach($value->getProductTestPackage as $product_test_package)
                              <div class="department" data-id="{!! $product_test_package->getTestPackage->department_id ?? '' !!}">
                                <div class="col-md-12 row m-2">
                                  @foreach($product_test_package->getTestPackageGroupTestItem->testPackageItems as $test_item)
                                    <div class="col-md-12 row items">
                                      <div class="col-md-5 mt-2">
                                        <label class="form-label" for="{!! $test_item->name !!}">{!! $test_item->name ?? '' !!}</label>
                                      </div>
                                      <div class="col-md-7">
                                        @if($test_item->input_type == 'NUMBER')
                                          <input type="number" class="form-control" name="{!! $test_item->id !!}" id="{!! $test_item->id !!}" placeholder="Test Result" value="{!! $billing_report[$test_item->id] ?? '' !!}">
                                        @elseif($test_item->input_type == 'TEXT')
                                          <input type="text" class="form-control" name="{!! $test_item->id !!}" id="{!! $test_item->id !!}" placeholder="Test Result" value="{!! $billing_report[$test_item->id] ?? '' !!}">
                                        @elseif($test_item->input_type == 'TIME')
                                          <input type="time" class="form-control" name="{!! $test_item->id !!}" id="{!! $test_item->id !!}" placeholder="Test Result" value="{!! $billing_report[$test_item->id] ?? '' !!}">
                                        @elseif($test_item->input_type == 'SUMMER_NOTE')
                                          <textarea class="summernote" id="{!! $test_item->id !!}" name="{!! $test_item->id !!}" required>{!! $billing_report[$test_item->id] ?? '' !!}</textarea>
                                        @elseif($test_item->input_type == 'IMAGE')
                                          <input type="file" class="form-control" name="{!! $test_item->id !!}" id="{!! $test_item->id !!}" placeholder="Test Result" accept="image/*">
                                        @elseif($test_item->input_type == 'PDF')
                                          <input type="file" class="form-control" name="{!! $test_item->id !!}" id="{!! $test_item->id !!}" placeholder="Test Result" accept=".pdf">
                                        @endif
                                      </div>
                                    </div>
                                  @endforeach
                                </div>
                              </div>
                            @endforeach
                          </div>
                        @endforeach --}}
                        <div class="col-md-12 mt-2">
                            <div class="d-grid gap-2 with-100">
                                <button class="btn btn-primary submit" type="button"><i class="bx bx-save"></i> Update Report</button>
                            </div>
                        </div>
                    </div>
                  </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
<script type="text/javascript" src="{{ asset('admin/js/report-formula.js')}}"></script>
<script type="text/javascript">
  $(document).ready(function() {
      $('.summernote').summernote();

      $(document).on('click','.submit', function(e) {
        e.preventDefault();
        $('#billing_report').submit();
      });
      $(document).on('change input', '.range', function() {
        var rangeValue = parseInt($(this).val());
        rangeValue     = rangeValue > 0 ? rangeValue : 0;
        var startValue = parseInt($(this).parent().parent().find('.range-start').val());
        var endValue   = parseInt($(this).parent().parent().find('.range-end').val());

        if (rangeValue < startValue) {
            $(this).parent().parent().find('.error_testitem').show();
            $(this).parent().parent().find('.error_testitem').text('Given input is lower than the range.');
            $(this).focus();
        } else if (rangeValue > endValue) {
            $(this).parent().parent().find('.error_testitem').show();
            $(this).parent().parent().find('.error_testitem').text('Given input is higher than the range.');
            $(this).focus();
        } else {
          $(this).parent().parent().find('.error_testitem').hide();
        }
      });

      $(document).on('change', '.option_input',function() {
        var value      = $(this).val();
        var options    = $(this).parent().parent().find('.option');
        var isNotEqual = true;

        options.each(function() {
            if ($(this).val().toLowerCase() === value.toLowerCase()) {
                isNotEqual = false;
                return false;
            }
        });

        if (!isNotEqual) {
            $(this).css('border-color', 'green');
        } else {
            error = 1;
            $(this).parent().parent().find('.error_testitem').show();
            $(this).parent().parent().find('.error_testitem').text('Input must be selected from the given options.');
            $(this).focus();
        }
      });

      $(document).on('click', '.reset', function() {
          var parentDiv = $(this).data('id');
          $('.package_'+parentDiv).find('input, select, textarea').val('');
          $('.package_'+parentDiv).find('textarea').text('');
          $('.package_'+parentDiv).find('.note-editable').text('');
      });

      $(document).on('click', '#reset-all', function() {
          $('#billing_report').find('table').find('input, select, textarea').val('');
          $('#billing_report').find('table').find('textarea').text('');
          $('#billing_report').find('table').find('.note-editable').text('');
      });

    $(document).on('keyup', '.CBC-HEMOGLOBIN,.CBC-RBC,.CBC-PCV,.CBC-NEUTROPHILS,.CBC-LYMPHOCYTES,.CBC-MONOCYTES,.CBC-EOSINOPHILS,.CBC-PLATELET-COUNT,.CBC-MPV,.CBC-LEUKOCYTE-COUNT,.CBC-BASOPHILS', function() {
      calculate_cbc();
    });

    $(document).on('keyup', '.HBA1C-HEAMOGLOBIN', function() {
      calculate_HBA1C_val();
    });

    $(document).on('keyup', '.INR-PROTHROMBIN,.INR-NORMAL', function() {
      calculate_inr_val();
    });

    $(document).on('keyup', '.LIPID-SCHOLESTEROL,.LIPID-TRIGLYCERIDES,.LIPID-HDLCHOLESTEROL', function() {
      calculate_lipidprofile();
    });

    $(document).on('keyup', '.BLOOD-UREA', function() {
      calculate_blood_urea();
    });

    $(document).on('keyup', '.BILIRUBIN-TOTAL, .BILIRUBIN-DIRECT', function() {
      calculate_bilirubin_total();
    });

    $(document).on('keyup', '.RENAL-FUNCTION-TEST, .BLOOD-UREA', function() {
      calculate_urea_bun();
    });

    $(document).on('keyup', '.LIVER-FUNCTION-TEST, .TOTAL-PROTEIN, .ALBUMIN, .GLOBULIN, TOTAL-BILIRUBIN,.CONJUGATED-BILIRUBIN', function() {
      calculate_lft();
    });

    $(document).on('keyup', '.KFT-UREA', function() {
      calculate_kft();
    });

    $(document).on('keyup', '.PTIMEPATIENT, .PTIMECONTROL', function() {
      calculate_ptime();
    });
  });
</script>
@endsection
