<div class="card style_table shadow-none" style="margin-bottom:0.8rem;">
    <div class="card-header d-flex align-items-center justify-content-between">
        @if($page == 'billing')
        <div style="width:100%" class="accordion-item">
            <div class="accordion-header" id="panelsStayOpen-headingTwo">
                <div class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                    <div class="col-md-6">
                        @endif
                        <h6 class="mb-0">Total Products in Cart <i class="bi bi-cart"></i> ({!! isset($data['products']) ? count($data['products']) : '0' !!})</h6>
                        @if($page == 'billing')
                    </div>
                </div>
                <div class="col-md-12" align="right">
                    @endif
                    @if($page=='billingCreate')
                        <button href="{!! route('ipd-cart-billing',['id'=>$id]) !!}" type="button" class="btn btn-outline-primary" id="checkout"><i class="bx bx-plus"></i> Add New</button>
                    @elseif($page == 'billingEdit')
                        <button href="{!! route('ipd-edit-cart-billing',['invoice_id'=>$id,'batch_id'=>$batch_id]) !!}" type="button" class="btn btn-outline-primary" id="checkout"><i class="bx bx-plus"></i> Add New</button>
                    @endif
                    @if($page == 'billing')
                </div>
                @endif
            </div>
            @if($page == 'billing')
            <div style="" id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse @if($page != 'billing'){{'show'}}@else{{''}}@endif" aria-labelledby="panelsStayOpen-headingTwo">
                <div class="accordion-body">
                    @endif
                    <div class="card-body pb-0">
                        <div class="table-responsive">
                            <table id="example" class="table table-bordered align-middle" style="width:100%">
                                <thead class="table-light">
                                    <tr>
                                        <th class="text-start">ITEM NAME</th>
                                        <th>PARTICULAR</th>
                                        <th>VIAL CODE</th>
                                        <th width="10%" style="text-align:right">PACK QTY</th>
                                        <th width="10%" style="text-align:right">Loose QTY</th>
                                        <th class="text-end">PRICE</th>
                                        <th class="text-end">DIS.%</th>
                                        <th class="text-end">DIS.AMT.</th>
                                        <th style="text-align:right">TAX </th>
                                        <th class="text-end">AMOUNT</th>
                                        @if($page != 'billing' || $page == 'edit')
                                        <th class="thbutton">Delete</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $i = 1;$product_price = 0; @endphp
                                    @if(isset($data['products']) && count($data['products']) > 0)
                                    @foreach(array_reverse($data['products']) as $key => $list)
                                    <tr class="cart-products" data-price_id="{{$list['price_id']}}">
                                        <td class="text-start">
                                            {{$list['product'] ?? ''}} <br> @if(isset($list['hsncode']) && $list['hsncode'] != '')<b>Code:</b> {{$list['hsncode'] ?? ''}},@endif @if($list['brand']!='' && $list['brand']!='N/A')<b>Brand:</b> {{$list['brand'] ?? ''}}@endif
                                            <br>
                                            {{ $list['batch'] ?? '' }},
                                            @if(isset($list['expiry_date']))
                                                {{ $list['expiry_date'] ?? '' }}
                                            @endif
                                        </td>
                                        @if($page != 'billing' || $page == 'edit')
                                        <td><input type="text" name="product_details" data-price_id="{{$list['price_id']}}" class="form-control bg-white" value="{{$list['product_details'] ?? ''}}" placeholder="Item Details"></td>
                                        <td><input type="text" name="vial_code" data-price_id="{{$list['price_id']}}" class="form-control bg-white" value="{{$list['vial_code'] ?? ''}}" placeholder="Vial Code"></td>
                                        <td style="padding: 0.375rem 0.1rem;">
                                            <input type="text" name="main_qty" data-price_id="{{ $list['price_id'] }}" class="form-control bg-white" value="{{ convertDecimelPoint($list['main_qty'] ?? '') }}" placeholder="00.00" style="text-align:right">
                                        </td>
                                        <td style="padding: 0.375rem 0.1rem;">
                                            <input type="number" name="loose_qty" data-price_id="{{ $list['price_id'] }}" class="form-control bg-white" value="{{ convertDecimelPoint($list['loose_qty'] ?? '') }}" placeholder="00.00" style="text-align:right">
                                        </td>
                                        <td><input type="text" name="product_price" data-price_id="{{$list['price_id']}}" class="form-control bg-white" value="{{convertDecimelPoint($list['product_price']) ?? ''}}" placeholder="00.00" style="text-align: right;"></td>
                                        <td><input type="text" name="per_discount" data-price_id="{{$list['price_id']}}" class="form-control bg-white" value="{{convertDecimelPoint($list['per_discount']) ?? ''}}" placeholder="00.00" style="text-align: right;"></td>
                                        <td><input type="text" name="flat_discount" data-price_id="{{$list['price_id']}}" class="form-control bg-white" value="{{convertDecimelPoint($list['flat_discount']) ?? ''}}" placeholder="00.00" style="text-align: right;"></td>
                                        <td style="text-align: center">
                                            {{ $list['tax_per'] ?? '' }}%<br>{{ convertDecimelPoint($list['tax_flat'] ?? '') }}
                                        </td>
                                        <td class="text-end">
                                            <b>{{convertDecimelPoint($list['amount']) ?? (convertDecimelPoint($list['product_price']) ?? '')}}</b>
                                            <br>
                                            <span style="border-top: 1px solid #aaa;">Rate: {!! $list['product_mrp'] ?? '' !!}</span>
                                        </td>
                                        <td class="text-center">
                                            <a style="line-height:24px;" data-url="{{route('ipd-cart-product-remove')}}" data-id="{{$key}}" data-price_id="{{$list['price_id']}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="left" title="Delete">
                                                <i class="bi bi-trash text-white"></i>
                                           </a>
                                        </td>
                                        @else
                                        <td>{{$list['product_details'] ?? ''}}</td>
                                        <td>{{$list['vial_code'] ?? ''}}</td>
                                        <td class="text-end">{{ convertDecimelPoint($list['main_qty'] ?? '') }}</td>
                                        <td class="text-end">{{ convertDecimelPoint($list['loose_qty'] ?? '') }}</td>
                                        <td class="text-end">{{ convertDecimelPoint($list['product_price']) ?? ''}}</td>
                                        <td class="text-end">{{$list['per_discount'] ?? ''}}</td>
                                        <td class="text-end">{{ convertDecimelPoint($list['flat_discount']) ?? ''}}</td>
                                        <td style="text-align: center">
                                            {{ $list['tax_per'] ?? '' }}%<br>{{ convertDecimelPoint($list['tax_flat'] ?? '') }}
                                        </td>
                                        <td class="text-dark text-end">
                                            <b class="text-dark">{{ convertDecimelPoint($list['amount']) ?? (convertDecimelPoint($list['product_price']) ?? '')}}</b>
                                            <br>
                                            <span style="border-top: 1px solid #aaa;">Rate: {!! $list['product_mrp'] ?? '' !!}</span>
                                        </td>
                                        @endif

                                        @php $product_price += preg_replace("/[^0-9.]/", "", $list['amount']); @endphp
                                    </tr>
                                    @php $i++; @endphp
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="9">No Data Found</td>
                                    </tr>
                                    @endif

                                </tbody>
                            </table>
                        </div>
                        @if($page == 'billing')
                    </div>
                </div>

            </div>
            @endif
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $('#checkout').html('Total Amount {!! convertDecimelPoint($product_price) !!} <i class="bi bi-cart-fill"></i> Checkout');

    });
    $(document).on('click', '#checkout', function() {
        if ($('select[name="voucher_type_id"]').val().trim() == '') {
           $('.error_voucher_type_id').show();
           setTimeout(function () {
            $('.error_voucher_type_id').hide();
            }, 3000);
        }
        else
        {
            $(this).prop('disabled', true);
        setTimeout(function () {
            window.open($('#checkout').attr('href'), '_self');
        }, 2500);
        }
       
    });
</script>
@if( $product_price > 0)
<script type="text/javascript">
    $(document).ready(function() {
        $('#checkout').removeClass('btn-outline-primary');
        $('#checkout').addClass('btn-primary');
    });
</script>
@endif
