<div class="table-responsive">
    @if(isset($display) && $display == 'admission')
    <div class="d-flex justify-content-between">
        <div class="d-flex">
            <h5 class="mb-0 p-2">Intent List</h5>
            <select class="form-select billing-voucher-select">
                <option value="">- Select Voucher Type -</option>
                @foreach($voucher_types as $type)
                <option value="{!! $type->code !!}" {!! matchSelected($type->code, $voucherType) !!}>{!! $type->name !!}</option>
                @endforeach
            </select>
            <h5 class="mb-0 p-2">From Date</h5>
            <input type="text" name="from_date" class="from_date form-control" autocomplete="false" value="{!! $from_date ?? '' !!}">
            <h5 class="mb-0 p-2">To Date</h5>
            <input type="text" name="date_filter" class="billing_date_picker form-control" autocomplete="false" value="{!! $billing_date_picker ?? '' !!}">
        </div>

        <!-- <button type="button" class="btn btn-primary" id="addConsultant" data-bs-toggle="modal" data-bs-target="#commonModal"><i class="bx bx-plus-circle"></i> Add New</button> -->

        <div class="float-md-end" style="margin-right: 10px">
            @if(isset($ipd_id->id))
            <a href="{{ route('ipd-billings.create', $ipd_id->id) }}" class="btn btn-primary new-bill">
                <i class="bi bi-plus-circle text-white"></i> New Intent
            </a>
            @endif
            {{-- @if (!empty($data[0]->account_id) && isset($ipd_id->id))
                <a class="btn btn-primary" href="{!! route('ipd-invoice', $ipd_id->id) !!}"> <i class="bi bi-printer text-white"></i> Consolidated Bill</a>
            @endif --}}
            @if(isset($sale_invoice) && (!empty($sale_invoice->patient_id)) && isset($ipd_id->id))
                <a href="{{ route('ipd-billings-summary-item-wise',  $ipd_id->id) }}" class="btn btn-secondary new-bill">
                    <i class="bi bi-plus-circle text-white"></i> Item Wise Bill
                </a>
            @endif
            {{-- @if(isset($count) && $count > 10 && isset($ipd_id->id)) --}}
                <a href="{!! route('ipd-billings.index', $ipd_id->id) !!}" class="btn btn-info">
                    <i class="bi bi-receipt-cutoff"></i> View All Intents
                </a>
            {{-- @endif --}}
        </div>
    </div>
    <hr class="mb-2">
    @endif
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Invoice No.</th>
                <th>Date</th>
                <th>Patient Name</th>
                <th>Ref.By/Referral</th>
                <th>Voucher Type</th>

                {{--<th style="text-align:right">Amount</th>
                <th style="text-align:right">Received</th>--}}
                {{-- <th>Due</th> --}}
                <th class="thbutton">Bill</th>
                {{--<th class="thbutton">Report</th>--}}
                <th class="thbutton">Report</th>
                {{-- <th>Due</th>
                <th class="thbutton">Status</th> --}}
                @if(in_array('pathology-lab-billing-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(auth()->user()->can('pathology-lab-billing-delete'))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                    <tr>
                        <td class="text-center">{{ $data->firstItem() + $key }}</td>
                        <td>
                            <a href="{!! route('ipd-billings.show', $list->getSaleInvoice->id) !!}">
                                <b>{{$list->getSaleInvoice->main_invoice_no}}</b>
                            </a>
                            <br>
                            <a href="{!! route('ipd-billing-report-logs', $list->getSaleInvoice->id) !!}">
                                {{$list->invoice_batch_no ?? '' }}
                            </a>
                        </td>
                        <td>
                            {!! nl2br(e(formatedDateTime($list->created_at))) !!}
                            <br>
                            @if(isset($list->prepared_by))
                            <div style="color:#aaa">By: {!! $list->prepared_by??'' !!}</div>
                            @endif
                        </td>
                        <td>
                            {{$list->getSaleInvoice->getPatient->account_title->name ?? ''}}
                            {{$list->getSaleInvoice->getPatient->name ?? ''}}<br>
                            {{$list->getSaleInvoice->getPatient->account_contact->gender->name ?? ''}}
                            {{ isset($list->getSaleInvoice->getPatient->account_contact->date_of_birth) &&
                                isset($list->getSaleInvoice->getPatient->account_contact->gender) ? ', ' : '' }}
                                {{ isset($list->getSaleInvoice->getPatient->account_contact->date_of_birth) ? age($list->getSaleInvoice->getPatient->account_contact->date_of_birth) . ' years' : '' }}
                        </td>
                        <td>{{$list->getSaleInvoice->getDoctor->account_title->name ?? ''}}
                            {{$list->getSaleInvoice->getDoctor->name ?? ''}}
                        </td>
                        <td>{!! $list->voucherType->name??'' !!}</td>

                        {{--<td style="text-align:right">{{ convertDecimelPoint($list->getSaleInvoice->billing_amount) ?? ''}}</td>
                        <td style="text-align:right">{{ convertDecimelPoint($list->getSaleInvoice->received_amount) ?? ''}}</td>--}}
                        {{-- <td>{{ convertDecimelPoint($list->due_amount) ?? ''}}</td> --}}
                        {{-- <td class="text-center">
                            <a class="btn btn-warning" href="{!! route('ipd-invoice', $list->getSaleInvoice->id) !!}">
                                <i class="bi bi-receipt text-white"></i>
                            </a>
                        </td> --}}
                        <td class="text-center">
                            <a class="btn btn-success" href="{!! route('ipd-new-invoice', ['id' => $list->getSaleInvoice->id, 'batch_id' => $list->id]) !!}">
                                <i class="bi bi-printer text-white"></i>
                            </a>
                        </td>

                        <td class="text-center">
                            <a href="{!! route('print-billing-report', ['invoice_id' => $list->getSaleInvoice->id, 'batch_id' => $list->id, 'redirect' => 'ipd-billings']) !!}" class="btn btn-info">
                                <i class="bi bi-receipt text-white"></i>

                            </a>
                        </td>
                        {{--<td class="text-center">
                            <a href="{!! route('ipd-print-billing-report', $list->getSaleInvoice->id) !!}" class="btn btn-success">
                                <i class="bi bi-printer text-white"></i>
                            </a>
                        </td>--}}
                        {{-- <td class="text-center">
                            {!! $list->due_amount > 0 ? '<span class="btn-sm btn-success text-white">Collect</span>' : '' !!}
                        </td> --}}
                        {{-- <td class="text-center">
                            {{$list->getSaleInvoice->enquiry_quality_name}}
                            {!!
                                isset($list->getSaleInvoice->getSaleInvoiceDetail) &&
                                isset($list->getSaleInvoice->getSaleInvoiceDetail->getSaleInvoiceSubDetails) &&
                                isset($list->getSaleInvoice->getSaleInvoiceDetail->getSaleInvoiceSubDetails->status) &&
                                $list->getSaleInvoice->getSaleInvoiceDetail->getSaleInvoiceSubDetails->status == 1 ?
                                '<span class="badge badge-pill bg-success text-white">Ready</span>' : '<span class="badge badge-pill bg-danger text-white">Pending</span>'
                            !!}
                        </td> --}}
                        @if(in_array('pathology-lab-billing-edit', $authRolePermissions))
                        <td class="text-center">
                            <a href="{{route('ipd-billings.edit',['id'=>$list->getSaleInvoice->id,'batch_id'=>$list->id])}}?redirect=ipd_admissions" class="btn btn-warning" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </a>
                        </td>
                        @endif
                        @if(auth()->user()->can('pathology-lab-billing-delete'))
                        <td>
                            <a data-url="{{route('ipd-billings.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="18">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
@if(!isset($display) || $display != 'admission')
<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
    {!! $data->onEachSide(1)->render('ipd-admissions.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
</nav>
</div>
@endif


