<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th class="thbutton">IPD No.</th>
                <th>Patient Name</th>
                <th>Consultant</th>
                <th>Admission Date</th>
                <th>Discharged Date</th>
                <th class="thbutton">Edit</th>
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key => $discharge)
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td><strong>{{ $discharge->get_admission_details->ipd_admission_no ?? '' }}</strong></td>
                        <td>
                            {!! $discharge->get_admission_details->contacts->account_title->name ?? '' !!}
                            {!! @$discharge->get_admission_details->contacts->name  . ' (' . @$discharge->get_admission_details->contacts->code  . ') ' . ($discharge->tpa_account_id != '' ? '<span class="badge bg-danger">TPA</span>' : '') !!}<br>
                            {{ $discharge->get_admission_details->contacts->account_contact->gender->name ?? '' }}
                            {{ @$discharge->get_admission_details->contacts->account_contact != null ? age($discharge ->get_admission_details->contacts->account_contact->date_of_birth) . ' Years' : '' }}
                        </td>
                        <td>
                            {!! $discharge->get_admission_details->consultantHistory->consultants->account_title->name  ?? ''!!}
                            {!! $discharge->get_admission_details->consultantHistory->consultants->name ?? '' !!}
                            {!! $discharge->get_admission_details->consultantHistory->consultants->code ?? '' !!}
                            <br>
                            @if(isset($discharge->prepared_by))
                            <div style="color:#aaa">By: {!! $discharge->prepared_by??'' !!}</div>
                            @endif
                        </td>
                        <td>{!! @formatedDateTime($discharge->get_admission_details->admission_date_time)  !!}</td>
                        <td>{!! @formatedDateTime($discharge->discharge_datetime)  !!}</td>
                        <td class="text-center">
                            <a href="{{ route('ipd-admissions.patientdischargeedit', $discharge->ipd_admission_id) }}" class="btn btn-outline-secondary" title="Edit">
                                <i class="bi bi-pencil-square"></i>
                            </a>
                        </td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="7">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
    {!! $data->onEachSide(1)->render('ipd-discharged.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
</nav>
</div>
