<div id="print_div">
    <div class="pathology-bill">
        <div class="row">
            <div class="col-2" style="width: 20%">
                <p>Date: {!! formatedDate(date('Y-m-d')) !!}</p>
            </div>
            <div class="col-7" style="text-align: center;">
                <p style="color:#0b5ed7;font-size:18px;margin-bottom: -4px !important"><b>{!! $company->name ?? '' !!}</b></p>
                <p style="font-size: 14px;"><b>IPD Billing STATEMENT</b></p>
                <p style="padding-bottom: 5px;font-size: 11px;"><b><span style="color: #698aff;">Billing</span> List</b>
                    <b>From <span style="color:#698aff;" id="">{{ $fromDate ? formatedDate($fromDate) : formatedDate(date('Y-m-d H:i:s')) }}</span> TO <span style="color:#698aff;" id="">{{ $toDate ? formatedDate($toDate) : formatedDate(date('Y-m-d H:i:s')) }}</span>
                    </b>
                </p>
            </div>
            <div class="col-2" style="text-align: right; width:20%">
                <p>Time: {!! formatedTime(date('H:i:s')) !!}</p>
            </div>
        </div>

        <div>
            <table class="table table-borderless report-container">
                <tbody class="report-content">
                    <tr>
                        <td class="report-content-cell">
                            <div class="row">
                                <div class="col-12">
                                    <table class="table table-bordered-print w-100 table-only-header-full-width mb-1" id="quotation_products">
                                        <thead>
                                            <tr class="text-uppercase">
                                                <th class="thbutton">Sl No</th>
                                                <th style="text-align: left;">IPD/CASE NO</th>
                                                <th style="text-align: left;">Discharge Date</th>
                                                <th style="text-align: left;">Patient</th>
                                                <th>Age</th>
                                                <th>Gender</th>
                                                <th>Phone No.</th>
                                                <th>Address</th>
                                                <th style="text-align: left;">Consultant</th>
                                                <th>Department</th>
                                                <th>Ward</th>
                                               
                                                <th style="text-align: left;">Bed</th>
                                                <th style="text-align: left;">File No</th>
                                                {{--<th style="text-align: left;">Claim No</th>
                                                <th style="text-align: left;">Tpa </th>--}}
                                                <th style="text-align: left;">Casualty</th>
                                                {{--<th style="text-align: left;">Referal</th>
                                                <th style="text-align: left;">Note</th>
                                                <th style="text-align: left;">Referal Partner</th>
                                                <th style="text-align: left;">History</th>
                                                <th style="text-align: left;">Invoice Number</th>--}}
                                                <th style="text-align: left;">Bill Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php $i = 1; @endphp
                                            @foreach($ipdAdmission as $list)
                                            @php
                                            $Receive = TransactionCalculationReceiveAmount($list->sale_invoices_name, 'IPD_INVOICE');
                                            $date_of_birth = $list->getPatient->account_contact->date_of_birth ?? '';
                                            $age = $date_of_birth != '' ? age($list->getPatient->account_contact->date_of_birth) : 0;
                                            @endphp
                                            <tr>
                                                <td class="text-center">{{ $i }}</td>
                                                <td style="text-align: left;">{{ $list->ipd_admission_no != 0 ? $list->ipd_admission_no : '' }}</td>
                                                <td style="text-align: left;">{!! formatedDate($list->discharge_datetime) !!}</td>
                                                <td style="text-align: left;">{{ $list->account_name != 0 ? $list->account_name : ''}}</td>
                                                <td>{!! $age ? $age .' Year(s)':' ' !!}</td>
                                                <td>{!! $list->getPatient->account_contact->gender->name??'' !!}</td>
                                                <td>{!! $list->getPatient->account_contact->phone_no??'' !!} 
                                                    {!! isset($list->getPatient->account_contact->whatsapp_no) && $list->getPatient->account_contact->whatsapp_no!=''?', '.$list->getPatient->account_contact->whatsapp_no:'' !!}
                                                </td>
                                                <td>{!! $list->getPatient->first_account_address->address_line1??'' !!}</td>
                                                <td style="text-align: left;">{{ $list->doctor_name != 0 ? $list->doctor_name : ''}}</td>
                                                <td>{!! $list->getIpdBed->getBedType->name??'' !!}</td>
                                                <td>{!! $list->getIpdBed->getBedGroup->name??'' !!}</td>
                                                
                                                <td style="text-align: left;">{{ $list->bed_name != 0 ? $list->bed_name : ''}}</td>

                                                <td style="text-align: left;">{{ $list->ipd_file_no != 0 ? $list->ipd_file_no : ''}}</td>
                                                {{--<td style="text-align: left;">{{ $list->claim_number != 0 ? $list->claim_number : ''}}</td>
                                                <td style="text-align: left;">{{ $list->tpa_account_id != 0 ? $list->tpa_account_id : ''}}</td>--}}
                                                <td style="text-align: left;">{{ $list->casualty != 0 ? $list->casualty : 'No'}}</td>
                                                {{-- <td style="text-align: left;">{{ $list->referal_from != 0 ? $list->referal_from : ''}}</td>
                                                <td style="text-align: left;">{{ $list->note != 0 ? $list->note : ''}}</td>
                                                <td style="text-align: left;">{{ $list->referral_partner_id != 0 ? $list->referral_partner_id : ''}}</td>
                                                <td style="text-align: left;">{{ $list->previous_medical_issue != 0 ? $list->previous_medical_issue : ''}}</td>
                                                <td style="text-align: left;">{{ $list->sale_invoice_id != 0 ? $list->voucher_type_invoice_no : ''}}</td>--}}
                                                <td style="text-align:right">
                                                    @if(isset($Receive['totalBilling']))
                                                    {{ convertDecimelPoint($Receive['totalBilling']) != 0 ? convertDecimelPoint($Receive['totalBilling']) : '0' }}<br>
                                                    @else
                                                    <b>Bill Not Generated</b>
                                                    @endif
                                                </td>
                                            </tr>
                                            @php $i++; @endphp
                                            @endforeach
                                            @if(count($ipdAdmission) === 0)
                                            <tr>
                                                <td colspan="17" class="text-center">No Data Found</td>
                                            </tr>
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>


@if(count($ipdAdmission) > 0)
<div class="row">
    <div class="col-md-6" style="text-align: right;">
        <button id="btn_print" type="button" class="btn btn-primary btn-lg"><i class="bi bi-printer text-white"></i> Print Statement </button>
    </div>

    <div class="col-md-6" style="text-align: left;">
        <a href="javascript:;" class="btn btn-outline-primary export-statement"><i class="bi bi-download"></i> Export</a>
    </div>
</div>
@endif