@extends('layouts.app')
@section('title','IPD Patient Discharged')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />

<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> IPD Patient Discharged Update</div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->

<div class="row auto">
    <div class="col-xl-12 mx-auto">

        <form class="row auto-width mt-0 ipd-patient-discharged" action="{{ route('ipd-discharged.update', $data->id) }}" method="post" enctype='multipart/form-data' style="padding: 0px 0px 0px 9px;">
            @csrf
            @method('PATCH')
            <div class="col-md-6" style="padding: 0 0 0 9px;">
                <div class="card">
                    <div class="card-body g-3 row">

                        <h5 class="mb-0">IPD Patient Discharged</h5>
                        <hr class="mb-2">

                        <div class="col-md-12">
                            <label for="Discharge Type" class="form-label">Discharge Type <span class="text-danger"><b>*</b></span></label>
                            <select class="form-control discharge_types" name="discharge_type_id">
                            @foreach ($discharge_types as $type)
                                <option {{ isset($data) ? matchSelected($data->discharge_type_id, $type->id) : '' }} data-code="{{ $type->code }}" value="{{ $type->id }}">{{ $type->name }}</option>
                            @endforeach
                            </select>
                            <span class="text-danger error_discharge_types" style="display:none;">This field is required.</span>
                        </div>
                        <div class="col-md-6">
                            <label for="Discharge Date and Time" class="form-label">Discharge Date and Time <span class="text-danger"><b>*</b></span></label>
                            <input class="form-control" value="{{ isset($data) ? $data->discharge_date_time : '' }}" type="datetime-local" name="discharge_date_time">
                            <span class="text-danger error_discharge_date_time" style="display:none;">This field is required.</span>
                        </div>
                        <div class="col-md-6">
                            <label for="Next Follow Up Date" class="form-label">Next Follow Up Date</label>
                            <input class="form-control" type="date" value="{{ isset($data) ? $data->next_follow_up_date : '' }}" name="next_follow_up_date">
                        </div>
                        <div class="col-md-12">
                            <label for="Note" class="form-label">Discharge Note</label>
                            <textarea class="form-textarea" name="note" placeholder="Discharge Note">{{ isset($data) ? $data->note : '' }}</textarea>
                        </div>
                        <div class="col-md-12">
                            <label for="Operation" class="form-label">Operation</label>
                            <textarea class="form-textarea" name="operation" placeholder="Operation">{{ isset($data) ? $data->operation : '' }}</textarea>
                        </div>
                        <div class="col-md-12">
                            <label for="Diagnosis" class="form-label">Diagnosis</label>
                            <textarea class="form-textarea" name="diagnosis" placeholder="Diagnosis">{{ isset($data) ? $data->diagnosis : '' }}</textarea>
                        </div>
                        <div class="col-md-12">
                            <label for="Investigation" class="form-label">Investigation</label>
                            <textarea class="form-textarea" name="investigation" placeholder="Investigation">{{ isset($data) ? $data->investigation : '' }}</textarea>
                        </div>
                        <div class="col-md-12">
                            <label for="Treatment At Home" class="form-label">Treatment At Home</label>
                            <textarea class="form-textarea" name="treatment_at_home" placeholder="Treatment At Home">{{ isset($data) ? $data->treatment_at_home : '' }}</textarea>
                        </div>

                        <!-- REFERRAL DISCHARGE -->
                        <div style="display: none" class="g-3 row referral_discharge_fields">
                            <div class="col-md-6">
                                <label for="Referral Date and Time" class="form-label">Referral Date and Time <span class="text-danger"><b>*</b></span></label>
                                <input value="{{ isset($referral_discharged) ? $referral_discharged->referral_date_time : '' }}" class="form-control" type="datetime-local" name="referral_date_time">
                                <span class="text-danger error_referral_date_time" style="display:none;">This field is required.</span>
                            </div>
                            <div class="col-md-6">
                                <label for="Referral Hospital Name" class="form-label">Referral Hospital Name <span class="text-danger"><b>*</b></span></label>
                                <input value="{{ isset($referral_discharged) ? $referral_discharged->referral_hospital_name : '' }}" class="form-control" type="text" name="referral_hospital_name" placeholder="Referral Hospital Name">
                                <span class="text-danger error_referral_hospital_name" style="display:none;">This field is required.</span>
                            </div>
                            <div class="col-md-12">
                                <label for="Reason For Referral" class="form-label">Reason For Referral</label>
                                <textarea class="form-textarea" name="reason_for_referral" placeholder="Referral Hospital Name">{{ isset($referral_discharged) ? $referral_discharged->reason_for_referral : '' }}</textarea>
                            </div>
                        </div>

                        <!-- DEATH DISCHARGE -->
                        <div style="display: none" class="g-3 row death_discharge_fields">
                            <div class="col-md-6">
                                <label for="Death Date and Time" class="form-label">Death Date and Time <span class="text-danger"><b>*</b></span></label>
                                <input class="form-control" value="{{ isset($death_discharged) ? $death_discharged->death_date_time : '' }}" type="datetime-local" name="death_date_time">
                                <span class="text-danger error_death_date_time" style="display:none;">This field is required.</span>
                            </div>
                            <div class="col-md-6">
                                <label for="Guardian Name" class="form-label">Guardian Name <span class="text-danger"><b>*</b></span></label>
                                <input class="form-control" value="{{ isset($death_discharged) ? $death_discharged->guardian_name : '' }}" type="text" name="guardian_name" placeholder="Guardian Name">
                                <span class="text-danger error_guardian_name" style="display:none;">This field is required.</span>
                            </div>
                            <div class="col-md-12">
                                <label for="File Attachment" class="form-label">File Attachment</label>
                                <input class="form-control" type="file" name="death_file_attachment">
                            </div>
                            <div class="col-12">
                                @if(isset($death_discharged) && !empty($death_discharged->file_attachment))
                                    <img src="{!! getTempUrl($death_discharged->file_attachment) !!}" height="auto"
                                         style="cursor: pointer;max-width: 120px;width: 120px;">
                                @else
                                    <p>No image available</p>
                                @endif
                            </div>
                            <div class="col-md-12">
                                <label for="Death Report" class="form-label">Death Report</label>
                                <textarea class="form-textarea" name="death_report" placeholder="Death Report">{{ isset($death_discharged) ? $death_discharged->death_report : '' }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="card-body g-3 row">
                        <div class="col-12" align="center">
                            <div class="d-grid gap-2 with-100">
                              <button class="btn btn-primary save_button" type="submit"><i class="bx bx-save"></i> Update IPD Patient Discharged</button>
                          </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6" style="padding: 0 0 0 18px;">
                <div class="card">
                    <div class="card-body g-3">
                      <div class="table-responsive">
                          <div class="d-flex justify-content-between">
                              <h5 class="mb-0">Admission Details</h5>
                          </div>
                          <hr class="mb-2">
                          <table class="table table-bordered align-middle">
                            <tr>
                                <td style="text-align:left;">Admission No</td>
                                <td>{{ $admission->ipd_admission_no }}</td>
                            </tr>
                            <tr>
                                <td style="text-align:left;">IPD CASE/FILE NUMBER</td>
                                <td>{{ $admission->ipd_file_no ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <td style="text-align:left;">Patient Name</td>
                                <td>{{ $admission->contacts->name . ' - (' . $admission->contacts->code . ')' }}</td>
                            </tr>
                            <tr>
                                <td style="text-align:left;">Consultant Name</td>
                                <td>{{ $admission->consultantHistory->consultants->name . ' - (' . $admission->consultantHistory->consultants->code . ')' }}</td>
                            </tr>
                            <tr>
                                <td style="text-align:left;">Admission Date</td>
                                <td>{!! formatedDateTime($admission->admission_date_time) !!}</td>
                            </tr>
                            <tr>
                                <td style="text-align:left;">Age</td>
                                <td>{{ age($admission->contacts->account_contact->date_of_birth) . ' Years' }}</td>
                            </tr>
                            <tr>
                                <td style="text-align:left;">Gender</td>
                                <td>{{ $admission->contacts->account_contact->gender->name  ?? ''}}</td>
                            </tr>
                            <tr>
                                <td style="text-align:left;">Date Of Birth</td>
                                <td>{{ formatedDate($admission->contacts->account_contact->date_of_birth) }}</td>
                            </tr>
                            <tr>
                                <td style="text-align:left;">Marital Status</td>
                                <td>{{ $admission->contacts->account_contact->marital_status ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <td style="text-align:left;">Blood Group</td>
                                <td>{{ $blood_group->group ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <td style="text-align:left;">Referred By</td>
                                <td>{{ $admission->referal_from ?? 'N/A' }}</td>
                            </tr>
                            <tr>
                                <td style="text-align:left;">TPA - (Third Party Administrator)</td>
                                <td>{{ $tpa_account->name ?? 'N/A' }}</td>
                            </tr>
                        </table>
                      </div>
                    </div>
                </div>
            </div>
        </form>

    </div>
</div>
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>

<script>
    $(document).ready(function() {

        dischargeTypes();

        function dischargeTypes() {
            var selectedOption = $('.discharge_types').find('option:selected');
            var discharge_types = selectedOption.data('code');

            var referral_discharge_fields = $('.referral_discharge_fields');
            var death_discharge_fields    = $('.death_discharge_fields');

            if (discharge_types == 'NORMAL') {
                referral_discharge_fields.hide();
                death_discharge_fields.hide();
            }
            else if (discharge_types == 'REFERRAL') {
                referral_discharge_fields.show();
                death_discharge_fields.hide();
            }
            else if (discharge_types == 'DEATH') {
                death_discharge_fields.show();
                referral_discharge_fields.hide();
            }
        }

        $('.discharge_types').on('change', dischargeTypes);
    });

    $(document).on('click','.save_button', function(e) {
        e.preventDefault();

        if ($('.discharge_types option:selected').data('code') == 'REFERRAL') {
            $('.error_discharge_date_time').hide();
            $('.error_referral_date_time').hide();
            $('.error_referral_hospital_name').hide();
            $('.error_discharge_types').hide();
            var error = 0;

            if ($('input[name="discharge_date_time"]').val() == '') {
              $('.error_discharge_date_time').show();
              error = 1;
            }
            if ($('input[name="referral_date_time"]').val() == '') {
              $('.error_referral_date_time').show();
              error = 1;
            }
            if ($('input[name="referral_hospital_name"]').val() == '') {
              $('.error_referral_hospital_name').show();
              error = 1;
            }
            if ($('.discharge_types').val() == null) {
              $('.error_discharge_types').show();
              error = 1;
            }
            if (error == 0) {
                $('.ipd-patient-discharged').submit();
            }
        }
        else if ($('.discharge_types option:selected').data('code') == 'DEATH') {
            $('.error_discharge_date_time').hide();
            $('.error_death_date_time').hide();
            $('.error_guardian_name').hide();
            $('.error_discharge_types').hide();
            var error = 0;

            if ($('input[name="discharge_date_time"]').val() == '') {
              $('.error_discharge_date_time').show();
              error = 1;
            }
            if ($('input[name="death_date_time"]').val() == '') {
              $('.error_death_date_time').show();
              error = 1;
            }
            if ($('input[name="guardian_name"]').val().trim() == '') {
              $('.error_guardian_name').show();
              error = 1;
            }
            if ($('.discharge_types').val() == null) {
              $('.error_discharge_types').show();
              error = 1;
            }
            if (error == 0) {
                $('.ipd-patient-discharged').submit();
            }
        }
        else {
            $('.error_discharge_date_time').hide();
            $('.error_discharge_types').hide();
            var error = 0;

            if ($('input[name="discharge_date_time"]').val() == '') {
              $('.error_discharge_date_time').show();
              error = 1;
            }
            if ($('.discharge_types').val() == null) {
              $('.error_discharge_types').show();
              error = 1;
            }

            if (error == 0) {
                $('.ipd-patient-discharged').submit();
            }
        }

        error = 1;
    });
</script>
@endsection
