<form class="row g-3 auto-width" action="{{ route('job-application.update', $application->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('patch')
     <div class="col-md-6">
        <label for="application_no" class="form-label">Application No<span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="application_no" name="application_no" aria-describedby="inputGroupPrepend" required value="{{ $application->application_no }}">
        <span class="text-danger error_application_no" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="vacancy_id" class="form-label">Vacancy</label>
        <div class="input-group">
            <select class="single-select form-control" name="vacancy_id">
                <option value="">Select</option>
                @foreach($vacancies as $vacancy)
                <option value="$vacancy->id" {{ $application->vacancy_id == $vacancy->id ? 'selected' : '' }} >{{$vacancy->position}}</option>
                @endforeach
            </select>
        </div>
        <span class="text-danger error_vacancy_id" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="candidate_name" class="form-label"> Name<span class="text-danger"><b>*</b></span></label>
        <input type="text" class="form-control" id="candidate_name" name="candidate_name" aria-describedby="inputGroupPrepend" required value="{{ $application->candidate_name }}">
        <span class="text-danger error_candidate_name" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="candidate_email" class="form-label"> Email</label>
        <input type="email" class="form-control" id="candidate_email" name="candidate_email" aria-describedby="inputGroupPrepend" required value="{{ $application->candidate_email }}">
        <span class="text-danger error_candidate_email" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="candidate_phone" class="form-label"> Phone</label>
        <input type="text" class="form-control" id="candidate_phone" name="candidate_phone" aria-describedby="inputGroupPrepend" required value="{{ $application->candidate_phone }}">
        <span class="text-danger error_candidate_phone" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="cover_letter" class="form-label">Cover Letter</span></label>
        <input type="text" class="form-control" id="cover_letter" name="cover_letter" aria-describedby="inputGroupPrepend" required value="{{ $application->cover_letter }}">
        <span class="text-danger error_cover_letter" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="cv_attachment" class="form-label">CV Attachment</label>
        <input type="text" class="form-control" id="cv_attachment" name="cv_attachment" aria-describedby="inputGroupPrepend" required value="{{ $application->cv_attachment }}">
        <span class="text-danger error_cv_attachment" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="applied_at" class="form-label">Applied At</label>
        <div class="input-group">
            <input type="text" name="applied_at" class="form-control" id="applied_at" autocomplete="off" readonly style="cursor: pointer;" value="{{ !empty($vacancy->applied_at) ? date('m/d/Y', strtotime($vacancy->applied_at)) : '' }}">
        </div>
        <span class="text-danger error_applied_at" style="display:none;">This field is required.</span>
    </div>
     <div class="col-md-6">
        <label for="linkedin_profile_link" class="form-label">Linkedin Profile Link</label>
        <input type="text" class="form-control" id="linkedin_profile_link" name="linkedin_profile_link" aria-describedby="inputGroupPrepend" required value="{{ $application->linkedin_profile_link }}">
        <span class="text-danger error_linkedin_profile_link" style="display:none;">This field is required.</span>
    </div>

    <div class="col-md-6">
        <label for="review_remarks" class="form-label">Review Remarks</label>
        <input type="text" class="form-control" id="review_remarks" name="review_remarks" aria-describedby="inputGroupPrepend" required value="{{ $application->review_remarks }}">
        <span class="text-danger error_review_remarks" style="display:none;">This field is required.</span>
    </div>
    <div class="col-md-6">
        <label for="reviewed_at" class="form-label">Reviewed At</label>
        <input type="text" name="reviewed_at" class="form-control" id="reviewed_at" autocomplete="off" readonly style="cursor: pointer;"  value="{{ !empty($vacancy->reviewed_at) ? date('m/d/Y', strtotime($vacancy->reviewed_at)) : '' }}" >
        <span class="text-danger error_reviewed_at" style="display:none;">This field is required.</span>
    </div>
</form>
