@extends('layouts.app')
@section('title')
@section('pages')
<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
    .dataTables_filter{
        margin-bottom: 6px;
    }
</style>
  <!--breadcrumb-->
  <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
    <div class="breadcrumb-title col-md-6"> Job Application
    </div>
    <div class="col-md-6">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb justify-content-md-end mb-0">
          <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="178" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
          <li class="breadcrumb-item" aria-current="page">Website Managment</li>
            <li class="breadcrumb-item active" aria-current="page"><i class="bi bi-dot"></i> Job Application</li>
        </ol>
      </nav>
    </div>
  </div>
  <!--end breadcrumb-->
  <div class="card style_table shadow-none radius-5 min-height my-auto">
    <div class="card-header py-3">
      @include('layouts.partials.nav-menu')
      <div class="row gx-2">
      <div class="col-lg-6 col-md-6">
          <a class="page_head text-center" style="padding: 7px;font-size:15px;">
            <b>
            </b>
          </a>
      </div>
      <div class="col-lg-6 col-md-6">
          <div class="ms-auto float-md-end">
            <div class="btn-group">
                <a href="" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="row auto">
      <div class="col-xl-12 mx-auto">
          <div class="shadow-none radius-5 min-height">
              <div class="row">
                        <div class="card col-lg-6">
                            <div class="card-body g-3 row">
                                <div class="table-responsive">
                                  <div class="d-flex justify-content-between">
                                      <h5 class="mb-0">Job Application Details</h5>
                                  </div>
                                    <hr class="mb-2">
                                    <table class="table table-bordered align-middle">
                                      <tr>
                                          <td style="text-align:left; font-weight:bold ;">Application Number</td>
                                          <td>{{$application->application_no ?? ''}}</td>
                                      </tr>
                                      <tr>
                                          <td style="text-align:left; font-weight:bold ;">Vacancy</td>
                                          <td>{{$vacancy->position ?? ''}}</td>
                                      </tr>
                                      <tr>
                                      	<tr>
                                          <td style="text-align:left; font-weight:bold ;">Canditate Name</td>
                                          <td>{{$application->candidate_name ?? ''}}</td>
                                      </tr>
                                      <tr>
                                          <td style="text-align:left; font-weight:bold ;">Canditate Phone Number</td>
                                          <td>{{$application->candidate_phone ?? ''}}</td>
                                      </tr>
                                      <tr>
                                          <td style="text-align:left; font-weight:bold ;">Canditate Email</td>
                                          <td>{{$application->candidate_email ?? ''}}</td>
                                      </tr>
                                      <tr>
                                          <td style="text-align:left; font-weight:bold ;">CV Attachment</td>
                                          <td>{{$application->cv_attachment ?? ''}}</td>
                                      </tr>
                                      <tr>
                                      <tr>
                                          <td style="text-align:left; font-weight:bold ;">Cover Letter </td>
                                          <td>{{$application->cover_letter ?? ''}}</td>
                                      </tr>
                                      <tr>
                                          <td style="text-align:left; font-weight:bold ;">City</td>
                                          <td>{{$application->city ?? ''}}</td>
                                      </tr>
                                      <tr>
                                          <td style="text-align:left; font-weight:bold ;">Position </td>
                                          <td>{{$vacancy->position ?? ''}}</td>
                                      </tr>
                                      <tr>
                                          <td style="text-align:left; font-weight:bold ;">Applied at </td>
                                          <td>{{formatedDate($application->applied_at)}}</td>
                                      </tr>
                                      <tr>
                                          <td style="text-align:left; font-weight:bold;">LinkedIn Profile Link</td>
										<td>{{$application->linkedin_profile_link ?? ''}}</td>
										</tr>
										<tr>
										    <td style="text-align:left; font-weight:bold;">Status</td>
										    <td>{{$application->status ?? ''}}</td>
										</tr>
										<tr>
										    <td style="text-align:left; font-weight:bold;">Review Remarks</td>
										    <td>{{$application->review_remarks ?? ''}}</td>
										</tr>
										<tr>
										    <td style="text-align:left; font-weight:bold;">Reviewed By</td>
										    <td>{{$reviewed_by->name?? ''}}</td>
										</tr>
										<tr>
										    <td style="text-align:left; font-weight:bold;">Reviewed At</td>
										    <td>{{formatedDate($application->reviewed_at)}}</td>
										</tr>
                                      </tr>

                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

              </div>

              
      </div>
  </div>

    <!--end row-->
@endsection

