@extends('layouts.app')
@section('title','Pathology')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>

  <!--breadcrumb-->
  <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
    <div class="breadcrumb-title col-md-6"> Pathology
    </div>
    <div class="col-md-6">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb justify-content-md-end mb-0">
          <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="28" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
          <li class="breadcrumb-item" aria-current="page">Pathology</li>
        </ol>
      </nav>
    </div>
  </div>
  <!--end breadcrumb-->

  <div class="card style_table shadow-none radius-5 min-height">
    <div class="card-header py-3">
      @include('layouts.partials.nav-menu')
      <div class="row gx-2">
        <div class="col-lg-5 col-md-5 col-8">
            <!-- <div class="position-relative">
                <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                <input class="form-control ps-5" type="search" id="search" placeholder="Search">
            </div> -->
        </div>

        <div class="col-lg-7 col-md-7">
          <div class="ms-auto float-md-end">

            <div class="btn-group">
                <a href="{!! route('lab-billings.show', $invoice_id) !!}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
            </div>

          </div>
        </div>
      </div>
    </div>

    <div id="print_div">
        @include('invoice-formats.partials.style')
        <div>
            <div class="row">
                <div class="col-md-12 col-xs-12 p-1">
                    <div class="card-body" id="tables">
                      <div class="table-responsive">
                        <div class="col-md-12">
                        </div>
                        <div class="col-md-12 p-4">
                          <div class="row border border-dark border-bottom-0 text-uppercase" style="padding-top: 2px; padding-bottom: 2px;margin-right:0px;margin-left:0px;">
                              <div class="col-4 font-12" style="text-align: left;"><b>Invoice No :  {!! $sale_invoice->main_invoice_no ?? '' !!}</b></div>
                              <div class="col-4 text-center font-12"><b>Date  : {!! $sale_invoice->invoice_date ? formatedDate($sale_invoice->invoice_date) : '' !!}</b></div>
                              <div class="col-4 text-right font-12" style="text-align: right;"><b>Reff No. : {!! $sale_invoice->reff_no ?? '' !!}</b></div>
                          </div>
                          @php
                              $date_of_birth = $sale_invoice->getPatient->account_contact->date_of_birth ?? '';
                              $age           = $date_of_birth != '' ? age($sale_invoice->getPatient->account_contact->date_of_birth) : 0;
                          @endphp
                          <div class="row border border-dark" style="padding-top: 2px; padding-bottom: 0px;line-height:1.2; margin-right:0px;margin-left:0px">
                              <div class="col-8 border-right border-dark" style="font-size:12px;display: flex;">
                                  <table class="table table-borderless mb-1 w-50">
                                      <tbody>
                                          <tr class="font-weight-bold">
                                               <td style="text-align: left;">Patient Details</td>
                                              <td>:</td>
                                              <td colspan="3" style="text-align: left; padding-left: 2px">
                                                  {!! ucfirst(@$sale_invoice->getPatient->name) !!}
                                                  @if($sale_invoice->getPatient->primary_account != '1')
                                                      ({!! $sale_invoice->getPatient->code ?? '' !!})
                                                  @endif
                                              </td>
                                          </tr>
                                          @php
                                              $gender      = $sale_invoice->getPatient->account_contact->gender->name ?? '';
                                              $state       = $sale_invoice->getPatient->first_account_address->state->name ?? '';
                                              $city        = $sale_invoice->getPatient->first_account_address->city->name ?? '';
                                              $country     = $sale_invoice->getPatient->first_account_address->country->name ?? '';
                                              $whatsapp_no = $sale_invoice->getPatient->account_contact->whatsapp_no ?? '';
                                          @endphp
                                          @if($gender != '')
                                              <tr>
                                                  <td style="text-align: left;">Gender</td>
                                                  <td>:</td>
                                                  <td style="text-align: left; padding-left: 2px">{!! $gender ?? '' !!}
                                                      @if($age > 0)
                                                          , Age : {!! $age !!} Years
                                                      @endif
                                                  </td>
                                              </tr>
                                          @endif
                                          @foreach(accountLicenses($sale_invoice->getPatient->id) as $value)
                                              <tr>
                                                  <td style="text-align: left;">{!! $value->name !!}</td>
                                                  <td>:</td>
                                                  <td style="text-align: left; padding-left: 2px">{!! $value->license_number !!}</td>
                                              </tr>
                                          @endforeach
                                          <tr>
                                              <td style="text-align: left;">Address</td>
                                              <td>:</td>
                                              <td style="text-align: left; padding-left: 2px">{!! $sale_invoice->getPatient->first_account_address->address_line1 ?? '' !!}{!! $city != '' ? ', '.$city : '' !!}{!! $state != '' ? ', '.$state : '' !!}{!! $country != '' ? ', '.$country : '' !!}</td>
                                          </tr>
                                          <tr class="font-weight-bold">
                                               <td style="text-align: left;">Phone No</td>
                                              <td>:</td>
                                              <td colspan="3" style="text-align: left; padding-left: 2px"> {!! $sale_invoice->getPatient->account_contact->phone_no ?? '' !!} @if($whatsapp_no != '') WhatsApp : {!! $whatsapp_no !!} @endif</td>
                                          </tr>
                                          <tr class="font-weight-bold">
                                               <td style="text-align: left;">Email</td>
                                              <td>:</td>
                                              <td colspan="3" style="text-align: left; padding-left: 2px"> {!! $sale_invoice->getPatient->account_contact->email ?? '' !!}</td>
                                          </tr>
                                      </tbody>
                                  </table>
                                  <table class="table table-borderless mb-1 w-50">
                                      <tbody>
                                        @if(isset($sale_invoice->getDoctor))
                                          <tr class="font-weight-bold">
                                               <td style="text-align: left;">Doctor Details</td>
                                              <td>:</td>
                                              <td colspan="3" style="text-align: left; padding-left: 2px">
                                                  {!! ucfirst(@$sale_invoice->getDoctor->name) !!}
                                                  @if(@$sale_invoice->getDoctor->primary_account != '1')
                                                      ({!! $sale_invoice->getDoctor->code ?? '' !!})
                                                  @endif
                                              </td>
                                          </tr>
                                          @php
                                              $gender      = $sale_invoice->getDoctor->account_contact->gender->name ?? '';
                                          @endphp
                                          @if($gender != '')
                                              <tr>
                                                  <td style="text-align: left;">Gender</td>
                                                  <td>:</td>
                                                  <td style="text-align: left; padding-left: 2px">{!! $gender ?? '' !!}
                                                      @if($age > 0)
                                                          , Age : {!! $age !!} Years
                                                      @endif
                                                  </td>
                                              </tr>
                                          @endif
                                          <tr class="font-weight-bold">
                                               <td style="text-align: left;">Phone No</td>
                                              <td>:</td>
                                              <td colspan="3" style="text-align: left; padding-left: 2px"> {!! $sale_invoice->getDoctor->account_contact->phone_no ?? '' !!} @if($whatsapp_no != '') WhatsApp : {!! $whatsapp_no !!} @endif</td>
                                          </tr>
                                          <tr class="font-weight-bold">
                                               <td style="text-align: left;">Email</td>
                                              <td>:</td>
                                              <td colspan="3" style="text-align: left; padding-left: 2px"> {!! $sale_invoice->getDoctor->account_contact->email ?? '' !!}</td>
                                          </tr>
                                        @else
                                          <tr class="font-weight-bold">
                                               <td style="text-align: left;">Doctor Details</td>
                                              <td>:</td>
                                              <td colspan="3" style="text-align: left; padding-left: 2px">
                                                  Self
                                              </td>
                                          </tr>
                                          <tr class="font-weight-bold">
                                               <td style="text-align: left;">Gender</td>
                                              <td>:</td>
                                              <td colspan="3" style="text-align: left; padding-left: 2px">-</td>
                                          </tr>
                                          <tr class="font-weight-bold">
                                               <td style="text-align: left;">Address</td>
                                              <td>:</td>
                                              <td colspan="3" style="text-align: left; padding-left: 2px">-</td>
                                          </tr>
                                          <tr class="font-weight-bold">
                                               <td style="text-align: left;">Phone No</td>
                                              <td>:</td>
                                              <td colspan="3" style="text-align: left; padding-left: 2px">-</td>
                                          </tr>
                                          <tr class="font-weight-bold">
                                               <td style="text-align: left;">Email</td>
                                              <td>:</td>
                                              <td colspan="3" style="text-align: left; padding-left: 2px">-</td>
                                          </tr>
                                        @endif
                                      </tbody>
                                  </table>
                              </div>

                              <div class="col-4 border-right border-dark" style=" font-size:12px; margin-top: 4px; display: flex; justify-content: flex-end;">
                                  <div style="text-align: center;">
                                  @php
                                      $generatorPNG = new Picqer\Barcode\BarcodeGeneratorPNG();
                                  @endphp
                                  <img class="barcodeStyle" src="data:image/png;base64,{{ base64_encode($generatorPNG->getBarcode($sale_invoice->main_invoice_no ?? '', $generatorPNG::TYPE_CODE_128)) }}" height="120" width="200">
                                  <br>
                                  <h6><b>{!! $sale_invoice->main_invoice_no ?? '' !!}</b></h6></div>
                              </div>
                          </div>
                        </div>

                        @if( count($sub_details)>0 )
                          <div class="col-md-12 px-4">
                            @foreach($sub_details as $key => $list)

                              <div class="d-flex align-items-center justify-content-between m-2">
                                  <h5 class="mb-0">{{ 1 + $key }}. {{$list->getTestPackage->name}}</h5>
                              </div>

                                <table class="table table-bordered align-middle" style="border: 1px solid #dee2e6; margin-bottom: 30px;">
                                  <thead class="table-light">
                                    <tr>
                                      <th class="thbutton">SL No</th>
                                      <th>User</th>
                                      <th>User Email</th>
                                      <th>User Role</th>
                                      <th>Tracking Type</th>
                                      <th>Tracked At</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                  @foreach($list->tracking as $trackingkey => $tracking)
                                  @php
                                    $roles = $tracking->user->roles->pluck('name')->all();
                                  @endphp
                                    <tr>
                                      <td>{{ 1 + $trackingkey }}</td>
                                      <td>{{ $tracking->user->name ?? '' }}</td>
                                      <td>{{ $tracking->user->email ?? '' }}</td>
                                      <td>
                                        @foreach($roles as $role)
                                          {{ $role ?? '' }}
                                        @endforeach
                                      </td>
                                      <td>{{ ucfirst($tracking->tracking_type) ?? '' }}</td>
                                      <td>{!! formatedDate($tracking->created_at) !!}, {!! formatedTime($tracking->created_at) !!}</td>
                                    </tr>
                                  @endforeach
                                </tbody>
                              </table>
                            @endforeach
                          </div>
                        @else
                            No Data Found
                        @endif
                      </div>
                    </div>
                </div>
            </div>
        </div>
        <div style="width:100%; text-align: center; " class="p-3">
            <button id="btn_print" type="button" class="btn btn-primary btn-lg"> Print Document <i class="bi bi-printer text-white"></i></button>
        </div>
    </div>
  </div>
@endsection
@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
      var page_title = $('#page_title').val();
      $("title").html(page_title);
      $(document).on('click','#btn_print',function(event) {
          event.preventDefault();
          $('#btn_back').hide();
          /*$('#print_div').printThis({
              importStyle: true,
          });*/
          $(this).hide();
          var printContents    = document.getElementById('print_div').innerHTML;
          var originalContents = document.body.innerHTML;

          document.body.innerHTML = printContents;

          window.print();

          document.body.innerHTML = originalContents;

          $(this).show();
          $('#btn_back').show();
          $('#btn_print').show();
      });
    });
</script>

@endsection