@extends('layouts.app')
@section('title', 'Lab Report | ' .$voucher_type->voucher_title ?? ''. ' - ' . $sale_invoice->voucher_type_invoice_no . ' - ' . ($sale_invoice->invoice_date ?
formatedDate($sale_invoice->invoice_date) : '') . ' - ' . ($sale_invoice->getPatient->name ?? ''))
@section('pages')

<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />
@php $pageTitle = $sale_invoice->voucher_type_invoice_no . ' - ' .($sale_invoice->getPatient->name ?? '').'-'. ($sale_invoice->invoice_date ?
formatedDate($sale_invoice->invoice_date) : '') ; @endphp

<div id="btn_back" class="card-header py-3">
    <div class="row gx-2">
        <div class="col-lg-6 col-md-6 col-6">
            <div class="position-relative">
                <h5>Lab Report | {!! $sale_invoice->voucher_type_invoice_no !!}</h5>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="ms-auto float-md-end">
                <div class="btn-group">
                    @if($show_print_on_due == 'yes')
                    <button id="btn_print" type="button" class="btn btn-primary btn-lg"> <i class="bi bi-printer text-white"></i> Print Report </button>
                    @endif
                    
                </div>
                @php
                    $redirect = request()->redirect == 'lab-reporting' ? 'lab-reporting' : (request()->redirect == 'lab-billings' ? 'lab-billings.index' : (request()->redirect == 'ipd-billings' ? 'ipd-admissions.show' : 'lab-reporting'));
                    $id = [];

                    if (request()->redirect == 'ipd-billings') {
                        $id['ipd_admission'] = $sale_invoice->ipd_admission_id;
                    }
                @endphp
                <div class="btn-group">
                    <a href="{!! route($redirect,$id) !!}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <div class=" shadow-none radius-5 min-height">
            <div class="">
                <div class="row g-3 auto-width">
                    <div class="col-md-12 cart_products">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="my-1" style="text-align: right; margin-right: 120px">
    Print with letter head <input class="form-check-input1 letterhead-print" type="checkbox" {!! isset($print_with_letterhead) && $print_with_letterhead == 'yes' ? 'checked=""' : '' !!}>
</div>
<div id="print_div" class="report-body" style="margin: 0 auto">
    <style type="text/css">
        .table {
            line-height: 2;
            margin-bottom: 5px;
        }
        .report_table_headings {
            font-size: 15px;
            font-weight: bold;
        }
        .report-body {
            /*width: 100% !important;*/
        }
        .department-title {
            margin-bottom: 0px;
            font-size: 17px;
        }
        .test-package-title {
            margin-bottom: 0px;
            font-size: 13px;
            font-weight: bold;
        }
        .remove-border {
            border-top: 1px solid #ffffff;
        }
        .test-item-name {
            margin-left: 10px;
            font-size: 12px;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }
        .test-item-name i {
            margin-left: 10px;
            font-size: 11px;
        }
        .test-item-method {
            font-size: 10px;
            font-style: italic;

        }
        .test-item-range{
            font-size: 11px            ;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }
        .test-item-unit{
            font-size: 13px;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }
        .test-item-flag{
            font-size: 13px;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }
        .test-item-result{
            font-size: 14px;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }
        /*.font-weight-400 {
            font-weight: 400;
        }*/

        .th_border {
            border-bottom: 1px solid #c7c7c7 !important;
            border-top: 0px solid #ffffff !important;
        }
        @if(isset($page_break_after_dept) && $page_break_after_dept == 'yes')
            @media print {
                .pagebreak {
                    clear: both;
                    page-break-after: always;
                }
            }
        @endif
        .top-border {
            border-top: 1px solid black;
        }
        .bottom-border {
            border-bottom: 1px solid black;
        }

        .pathology-bill,
        .pathology-bill .table td,
        .pathology-bill .table th {
            font-size: 12px !important;
        }
        .bottom-border-width {
            border-bottom-width: 0 !important;
        }
        .test_label {
            font-weight: bold;
            border: 1px solid #c7c7c7;
            border-right: none;
            border-left: none;
            border-top: none;
            margin-bottom: 0px;
        }
        .test_label span {
            margin-left: 10px;
        }
    </style>
    <style type="text/css">
        @media print {
            .report-footer {
                color: black;
                background-color: transparent;
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                width: 100%
            }
            
            .report-container {
                width: 100%;
                margin-bottom: 60px; /* Adjust according to the footer height */
                page-break-inside: auto;
            }

            .report-header, .report-content, .report-footer {
                page-break-inside: avoid;
            }

            .report-footer {
                page-break-before: always; /* Move tfoot to the next page if necessary */
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
        }
        .text-right {
            text-align: right;
        }
        .font-12 {
            font-size: 12px !important;
        }
        .test_method {
            font-size: 10px;
            text-align: right;
        }
    </style>
<style type="text/css">
    body {
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        line-height: 1.42857143;
        /*color: #333;*/
        /*background-color: #fff;*/
    }
    .cart-products span {
        font-size: 14px;
        padding: 2px;
        border-radius: 14px;
    }
    @foreach($flags as $flag)
        .{!! $flag->code !!} {
            {!! $flag->font_size !='' ? 'font-size:' .$flag->font_size.'px;' : '' !!}
            {!! $flag->font_color !='' ? 'color:' .$flag->font_color.';' : '' !!}
            {!! $flag->bg_color !='' ? 'background-color:' .$flag->bg_color.';' : '' !!}
            {!! $flag->font_family !='' ? 'font-family:' .$flag->font_family.';' : '' !!}
            {!! $flag->text_decoration !='' ? 'text-decoration:' .$flag->text_decoration.';' : '' !!}
            {!! $flag->font_style !='' ? 'font-style:' .$flag->font_style.';' : '' !!}
            {!! $flag->font_weight !='' ? 'font-weight:' .$flag->font_weight.';' : '' !!}
            {!! $flag->font_padding !='' ? 'padding:' .$flag->font_padding.';' : '' !!}
        }
    @endforeach
</style>
    <div class="pathology-bill">
        <div class="row">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                    @php $company = @$sale_invoice->getCompany; @endphp
                                    @php $voucherType = $voucher_type->code; @endphp
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell" style="font-weight: normal;">
                                                @include('components.lab-report-letter-head')
                                                @include('components.lab-report-voucher-details')
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell">
                                                <div class="row report-body">
                                                    @php
                                                        $gender = $sale_invoice->getPatient->account_contact->account_gender_id ?? '1';
                                                        $date_of_birth = $sale_invoice->getPatient->account_contact->date_of_birth ?? '';
                                                        $age = $date_of_birth != '' ? ageInHours($sale_invoice->getPatient->account_contact->date_of_birth) : 0;
                                                        $i = 0;
                                                    @endphp

                                                    @if (count($testPackages) > 0 && count($billing_report) > 0)
                                                        <div class="col-md-12">
                                                            @foreach ($testPackages as $key => $value)
                                                                @php $i++; @endphp
                                                                <div class="department">
                                                                    @php $showSignatures = 0; @endphp
                                                                    <div style="display: flex; justify-content: center;text-align: center;margin-bottom: 3px">
                                                                        <div style="width: 10%" class="department-title-side">
                                                                        </div>
                                                                        <!-- department names  -->
                                                                        <div style="width: 80%">
                                                                            @if (isset($value['department']->show_in_report) && $value['department']->show_in_report == 1)
                                                                                <h4 class="department-title" style="{!! $cap_names == 1 ? 'text-transform: uppercase' : ''; !!}"><b>{!! @$value['department']->name ?? '' !!}</b></h4>
                                                                            @endif
                                                                        </div>
                                                                        <div style="width: 10%"> Print <input class="form-check-input1 department_checkbox" type="checkbox" checked=""></div>
                                                                    </div>

                                                                    @if (isset($value['department']->show_report_heading) && $value['department']->show_report_heading == 1)
                                                                    <div class="d-flex test_packages_headings"
                                                                        style="border: 1px solid #565656;">
                                                                        <div style="width:33%" class="text-left bottom-border-width mx-1"><span class="report_table_headings">Investigation</span></div>
                                                                        <div style="width:27.5%" class="text-left bottom-border-width"><span class="report_table_headings">Result</span></div>
                                                                        @if(!isset($show_flag) || (isset($show_flag) && $show_flag == 'yes'))
                                                                            <div style="width:5%" class="text-left bottom-border-width"><span class="report_table_headings">Flag</span></div>
                                                                        @endif
                                                                        <div style="width:11%" class="text-left bottom-border-width"><span class="report_table_headings">Unit</span></div>
                                                                        <div style="width:27%;display: flex;justify-content: space-between;" class="text-left bottom-border-width">
                                                                            <span class="report_table_headings">Reference Range</span><span class="report_table_headings">Method</span>
                                                                        </div>
                                                                    </div>
                                                                    @endif
                                                                    <div id="container" class="col-md-12 row test_packages_container" style="padding-right: 0;--bs-gutter-x:0;margin-bottom: 10px">
                                                                        @foreach ($value['test_packages'] as $test_packages)
                                                                            <table class="table align-middle" style="border: 1px solid #c7c7c7;border-right: none;border-left: none;border-top: none;">
                                                                                <thead>
                                                                                    {{-- <div class="sort" data-priority="{{ $test_packages->priority }}"> --}}
                                                                                    <tr>
                                                                                        <th colspan="{!! isset($show_flag) && $show_flag == 'yes' ? '4' : '3' !!}" width="50%" class="" style="border-bottom: 1px solid #c7c7c7 !important;border-top: 0px solid #ffffff !important;">
                                                                                            @if ($test_packages['show_in_report'] == 1)
                                                                                                <h5 class="test-package-title" data-id="{!! $test_packages->id !!}">{!! $test_packages->name ?? '' !!} {!! !empty($test_packages->test_method_name) ? '('.$test_packages->test_method_name.')' : '' !!}</h5>
                                                                                            @endif
                                                                                        </th>
                                                                                        <td width="50%" style="border-bottom: 1px solid #c7c7c7 !important;border-top: 0px solid #ffffff !important; text-align: right;font-size: 10px !important">
                                                                                            {!! $test_packages->reported_at ? 'Reported At : ' . formatedDate($test_packages->reported_at) . ', ' . formatedTime($test_packages->reported_at) . '<br>' : '' !!}
                                                                                            <script type="text/javascript">
                                                                                                $(document).ready(function() {
                                                                                                     $('.registered_at').text("{!! $test_packages->registered_at ? formatedDate($test_packages->registered_at) . ', ' . formatedTime($test_packages->registered_at) : '' !!}");
                                                                                                     $('.collected_at').text("{!! $test_packages->collected_at ? formatedDate($test_packages->collected_at) . ', ' . formatedTime($test_packages->collected_at) : '' !!}");
                                                                                                })
                                                                                            </script>
                                                                                        </td>
                                                                                    </tr>
                                                                                </thead>
                                                                            </table>
                                                                            @foreach ($test_packages->testPackageGroups as $testPackageGroup)
                                                                                @php $serial = 1; @endphp
                                                                                @foreach ($testPackageGroup->test_package_group_test_items as $item_key => $items)
                                                                                @php 
                                                                                    $is_pagebreak = 0;

                                                                                    if ($items->page_break == 1) {
                                                                                        $is_pagebreak = 1;
                                                                                    }
                                                                                    $answer = $billing_report[$items->test_item->id . '_' . $test_packages->sale_invoice_detail_id] ?? '';
                                                                                @endphp
                                                                                @if($items->test_item->item_type == 'TEST_LABEL')
                                                                                    <div class="test_label">
                                                                                        <span >
                                                                                            {!! $items->test_item->test_name ?? '' !!}
                                                                                        </span>
                                                                                    </div>
                                                                                @elseif(isset($answer->result) && !empty($answer->result))
                                                                                    <table class="table align-middle test_items_table test_package_item_{!! $test_packages->id !!}" style="border: 1px solid #e9e9e9;border-right: none;border-left: none;border-top: none;margin-bottom: 0px">
                                                                                        <tbody>
                                                                                            @if($items->test_item->input_type == 'SUMMER_NOTE')
                                                                                            <tr>
                                                                                                <td colspan="{!! isset($show_flag) && $show_flag == 'yes' ? '5' : '4' !!}">
                                                                                                    {!! $answer->long_result ?? '' !!}
                                                                                                </td>
                                                                                            </tr>
                                                                                            @elseif($items->test_item->input_type == 'IMAGE')
                                                                                            <tr>
                                                                                                <td colspan="{!! isset($show_flag) && $show_flag == 'yes' ? '5' : '4' !!}" class="text-center">
                                                                                                    <img src="{!! getTempUrl($answer->result) !!}" class="img-thumbnail" style="max-height: 500px;border-radius: 0.5rem !important;">
                                                                                                    <br>
                                                                                                    <span class="test-item-name">{!! $items->test_item->test_name ?? '' !!}</span>
                                                                                                </td>
                                                                                            </tr>
                                                                                            @elseif(isset($answer->result) && !empty($answer->result))
                                                                                                <tr>
                                                                                                    @php
                                                                                                        $remarksFullLength = 0;

                                                                                                        if ($items->test_item->test_name == 'REMARKS :' && empty($items->test_item->unit)) {
                                                                                                            $remarksFullLength = 1;
                                                                                                        } elseif (empty($items->test_item->unit)) {
                                                                                                            $remarksFullLength = 1;
                                                                                                        }
                                                                                                        $title_style = $items->test_item->title_style ?? 'normal';
                                                                                                        $style = '';

                                                                                                        if($title_style == 'italic') {
                                                                                                            $style = 'style="font-style: italic;"';
                                                                                                        } elseif ($title_style == 'bold') {
                                                                                                            $style = 'style="font-weight: bold;"';
                                                                                                        }
                                                                                                    @endphp
                                                                                                    <td width="30%">
                                                                                                        <span class="test-item-name" {!! $style !!}>{!! $items->test_item->test_name ?? '' !!}<br><!-- <i>{!! isset($items->test_item->test_method_name) && !empty($items->test_item->test_method_name) ?  '('.$items->test_item->test_method_name . ')' : '' !!}</i> --></span></td>
                                                                                                    <td width="{!! $remarksFullLength == 0 ? '25%' : '60%'!!}" class="" {!! $remarksFullLength == 0 ? '' : 'colspan="4"'!!}>
                                                                                                        @php
                                                                                                            $low = '';
                                                                                                            $high = '';
                                                                                                            $result = '';
                                                                                                            $testItemNormalRange = '';
                                                                                                            $result_flag = '';
                                                                                                        @endphp
                                                                                                        @if ($items->test_item->reference_value_type == 'RANGE' && isset($items->test_item->testItemNormalRange))
                                                                                                            @foreach ($items->test_item->testItemNormalRange->where('gender_id', $gender) as $range)
                                                                                                                @php
                                                                                                                $testItemNormalRange = $range;
                                                                                                                @endphp
                                                                                                            @endforeach
                                                                                                            @php
                                                                                                                $low = $testItemNormalRange->low_value ?? 0;
                                                                                                                $high = $testItemNormalRange->high_value ?? 0;
                                                                                                                $result = $answer->result;

                                                                                                                if (!empty($high) && !empty($low)) {
                                                                                                                    $result_flag = billingRangeFlag($high,$low,$result);
                                                                                                                }
                                                                                                            @endphp
                                                                                                        @endif

                                                                                                        @if($items->test_item->reference_value_type == 'OPTIONS' && isset($items->test_item->testItemOption))
                                                                                                            @foreach($items->test_item->testItemOption as $range)
                                                                                                                @if($range->name == $answer->result)
                                                                                                                    @php $result_flag = $range->styleType->code; @endphp
                                                                                                                @endif
                                                                                                            @endforeach
                                                                                                        @endif
                                                                                                        @php
                                                                                                            $flag = '';
                                                                                                        @endphp
                                                                                                        <span class="error_testitem test-item-result {!! $result_flag !!}">
                                                                                                            {!! $answer->result ?? '' !!}
                                                                                                             @if(isset($answer) && !empty($answer->note))
                                                                                                                {!! $answer->note !!}
                                                                                                            @endif
                                                                                                            <div style="display:flex; justify-content: space-between;">
                                                                                                            </div>
                                                                                                        </span>
                                                                                                    </td>
                                                                                                    @if($remarksFullLength == 0)
                                                                                                        @if(!isset($show_flag) || (isset($show_flag) && $show_flag == 'yes'))
                                                                                                            @php
                                                                                                                $flag = isset($answer->flag) ? ucfirst(substr($answer->flag, 0, 1)) : '';
                                                                                                                $font_size = isset($answer->font_size) ? $answer->font_size : '';
                                                                                                                $font_color = isset($answer->font_color) ? $answer->font_color : '';
                                                                                                            @endphp

                                                                                                            <td width="5%">
                                                                                                                <span class="test-item-flag">
                                                                                                                    <i class="bi bi-{!! $result_flag == 'low' ? 'arrow-down' : ($result_flag == 'high' ? 'arrow-up' : '') !!}"></i> {!! ucfirst($result_flag) !!}
                                                                                                                </span>
                                                                                                            </td>
                                                                                                        @endif
                                                                                                        <td width="10%" style="line-height: 0.8rem;">
                                                                                                            <span class="test-item-unit">{!! $items->test_item->unit ?? '' !!}</span>
                                                                                                        </td>

                                                                                                        <td width="25%" style="line-height: 1.2;">
                                                                                                            <span class="test-item-range">
                                                                                                            @if ($items->test_item->reference_value_type == 'RANGE' && isset($items->test_item->testItemNormalRange))
                                                                                                            @foreach ($items->test_item->testItemNormalRange->where('gender_id', $gender) as $range)
                                                                                                                @if(count($items->test_item->testItemNormalRange->where('gender_id', $gender)) > 1 )Age {!! hoursToYears($range->from_age) !!} - {!! hoursToYears($range->to_age) !!}y : @endif{!! $range->low_value !!} - {!! $range->high_value !!}
                                                                                                                    <input type="hidden" name="" class="range-start" value="{!! ceil($range->low_value) !!}">
                                                                                                                    <input type="hidden" name="" class="range-end" value="{!! ceil($range->high_value) !!}">
                                                                                                                    <br>
                                                                                                            @endforeach
                                                                                                            @endif

                                                                                                            @if($items->test_item->reference_value_type == 'OPTIONS' && isset($items->test_item->testItemOption))
                                                                                                                @foreach($items->test_item->testItemOption as $range)
                                                                                                                    <input type="hidden" name="" class="{!! (trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $range->name))) !!}" value="{!! $range->styleType->code !!}">
                                                                                                                @endforeach
                                                                                                            @endif
                                                                                                            @if ($items->test_item->reference_value_type == 'TEXT' && $items->test_item->reference_value != '')
                                                                                                                {!! $items->test_item->reference_value !!}<br>
                                                                                                            @endif
                                                                                                            <i><p class="test_method">{!! isset($items->test_item->test_method_name) && !empty($items->test_item->test_method_name) ?  '('.$items->test_item->test_method_name . ')' : '' !!}</p></i>
                                                                                                            </span>
                                                                                                            {{-- @if(in_array($item_key, page_record_limit()))
                                                                                                                <div class="pagebreak"> </div>
                                                                                                            @endif --}}
                                                                                                        </td>
                                                                                                    @endif
                                                                                                </tr>
                                                                                                @php $showSignatures = 1; @endphp
                                                                                            @endif
                                                                                            @php $serial += 1; @endphp
                                                                                        </tbody>
                                                                                    </table>

                                                                                @endif
                                                                                    @if($is_pagebreak == 1)
                                                                                        <div class="pagebreak"> </div>
                                                                                    @endif
                                                                                @endforeach
                                                                            @endforeach
                                                                            @if(isset($test_packages->package_note_status) && $test_packages->package_note_status == 1)
                                                                            <div class="px-4 w-100">
                                                                                {!! $test_packages->package_note !!}     
                                                                            </div>
                                                                            @endif
                                                                        @endforeach
                                                                    </div>
                                                                    @if ($showSignatures == 1)
                                                                        <div
                                                                            style="display: flex; justify-content: center;text-align: center;margin-bottom: 20px">
                                                                            <div style="width: 50%; margin-top: 10px">
                                                                                @if (isset($tech_signature_setting) && $tech_signature_setting == 'Department' && !empty($value['department']->tech_signature))
                                                                                    @php
                                                                                        $tech_max_height = !empty($value['department']->tech_max_height) ? $value['department']->tech_max_height . 'px !important' : '';
                                                                                        $tech_max_width = !empty($value['department']->tech_max_width) ? $value['department']->tech_max_width . 'px !important' : '';
                                                                                    @endphp
                                                                                    <img src="{!! isset($value['department']->tech_signature) ? getTempUrl($value['department']->tech_signature) : '' !!}" style="height: {!! $tech_max_height !!};width: {!! $tech_max_width !!};    z-index: 1000; position: relative;">
                                                                                    <!-- <div style="width: 50%; border-top: 1px solid #bebebe; margin: 0 auto; "></div> -->
                                                                                @elseif (!empty($test_packages->technician_signature))
                                                                                    <img src="{!! getTempUrl($test_packages->technician_signature) !!}" width="200px">
                                                                                    <!-- <div style="width: 50%; border-top: 1px solid #bebebe; margin: 0 auto; "></div> -->
                                                                                @endif
                                                                                {{-- <p class="mb-0"><b>{!! $test_packages->technician_prepared_by !!}</b></p>
                                                                                <p style="line-height: 1;">{!! $test_packages->technician_designation !!}</p> --}}
                                                                            </div>
                                                                            <div style="width: 50%; margin-top: 10px">
                                                                                @if (isset($doc_signature_setting) && $doc_signature_setting == 'Department' && !empty($value['department']->doc_signature))
                                                                                @php
                                                                                    $doc_max_height = !empty($value['department']->doc_max_height) ? $value['department']->doc_max_height  . 'px !important': '';
                                                                                    $doc_max_width = !empty($value['department']->doc_max_width) ? $value['department']->doc_max_width . 'px !important' : '';
                                                                                @endphp
                                                                                    <img src="{!! getTempUrl($value['department']->doc_signature) !!}" style="height: {!! $doc_max_height !!};width: {!! $doc_max_width !!};    z-index: 1000; position: relative;">
                                                                                    <!-- <div style="width: 50%; border-top: 1px solid #bebebe; margin: 0 auto; "></div> -->
                                                                                @elseif (!empty($test_packages->doctor_signature))
                                                                                    <img src="{!! getTempUrl($test_packages->doctor_signature) !!}" width="200px">
                                                                                    <!-- <div style="width: 50%; border-top: 1px solid #bebebe; margin: 0 auto; "></div> -->
                                                                                @endif
                                                                                {{--<p class="mb-0"><b>{!! $test_packages->doctor_prepared_by !!}</b></p>
                                                                                <p style="line-height: 1;">{!! $test_packages->doctor_designation !!}</p>--}}
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                    @if(count($testPackages) != $i)
                                                                        <div class="pagebreak"> </div>
                                                                    @endif
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    @else
                                                        Report Is Not Ready Yet
                                                    @endif
                                                </div>

                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div class="col-12 text-center enfofreport" style="display: none">
                                                    <h6><b>** End Of Report **</b></h6>
                                                </div>
                                            </td>
                                        </tr>
                                                
                                    </tbody>
                                    @include('components.lab-report-footer')
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<div class="text-center">
    @if($show_print_on_due == 'yes')
    <button id="btn_print" type="button" class="btn btn-primary btn-lg"> <i class="bi bi-printer text-white"></i> Print Report </button>
    @endif
</div>
@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        $( ".department" ).each(function() {
            if ($(this).find('.test_items_table').length < 1) {
                $(this).remove();
            }
        });

        $( ".test-package-title" ).each(function() {
            if ($('.test_package_item_' + $(this).data('id')).length < 1) {
                $(this).remove();
            }
        });

        fetch_cart();
        function fetch_cart(){
          $.ajax({
            url:"{!! route('print-test-packages-status',$sale_invoice->id) !!}?page=billing&batch_id={!! $batch_id !!}",
            success:function(data){
                $('.cart_products').html('');
                $('.cart_products').html(data);
            }
          })
        }

        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();
            $('.enfofreport').show();

            if ($('.letterhead-print').is(':checked') == false) {
                $('.footer_img').hide();
                $('.letter_head_img').hide();
            }

            $(".department_checkbox").each(function() {
                $(this).parent().hide();
                if ($(this).is(':checked') == false) {
                    $(this).closest('.department').hide();
                    // $('.ui-switcher').remove();
                }
            });
            $('.department-title-side').hide();
            $('.continue-text').show();

            printInvoice();

            $('.enfofreport').hide();
            $('#btn_back').show();
            $('.department-title-side').show();
            $('.continue-text').hide();
            $('.department').show();
            $('.department_checkbox').parent().show();
            $('.footer_img').show();
            $('.letter_head_img').show();
            return;
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
</script>
@endsection
