@extends('layouts.app')
@section('title', $voucher_type->voucher_title ?? ''. ' - ' . $sale_invoice->main_invoice_no . ' - ' . ($sale_invoice->invoice_date ?
formatedDate($sale_invoice->invoice_date) : '') . ' - ' . ($sale_invoice->getPatient->name ?? ''))
@section('pages')

<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />
@php $pageTitle = $sale_invoice->main_invoice_no . ' - ' .($sale_invoice->getPatient->name ?? '').'-'. ($sale_invoice->invoice_date ?
formatedDate($sale_invoice->invoice_date) : '') ; @endphp

<div id="btn_back" class="card-header py-3">
    <div class="row gx-2">
        <div class="col-lg-6 col-md-6 col-6">
            <div class="position-relative">
                <h5>{!! $voucher_type->voucher_title ?? '' !!} | {!! $sale_invoice->main_invoice_no !!}</h5>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="ms-auto float-md-end">
                <div class="btn-group">
                    <button id="btn_print" type="button" class="btn btn-primary btn-lg"> <i class="bi bi-printer text-white"></i> Print Report </button>
                    
                </div>
                <div class="btn-group">
                    <a href="{!! route('lab-reporting') !!}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="my-2" style="text-align: right; margin-right: 120px">
    Print with letter head <input class="form-check-input1 letterhead-print" type="checkbox" {!! isset($print_with_letterhead->value) && $print_with_letterhead->value == 'yes' ? 'checked=""' : '' !!}>
</div>
<div id="print_div" class="report-body" style="margin: 0 auto">
    <style type="text/css">
        .table {
            line-height: 2;
            margin-bottom: 5px;
        }
        .report_table_headings {
            font-size: 16px;
        }
        .report-body {
            width: 260mm !important;
        }
        .department-title {
            margin-bottom: 0px;
            font-size: 20px;
        }
        .test-package-title {
            margin-bottom: 0px;
            font-size: 14px;
        }
        .remove-border {
            border-top: 1px solid #ffffff;
        }
        .test-item-name {
            margin-left: 10px;
            font-size: 12px;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }
        .test-item-method {
            font-size: 10px;
            font-style: italic;

        }
        .test-item-range{
            font-size: 12px            ;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }
        .test-item-unit{
            font-size: 13px;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }
        .test-item-flag{
            font-size: 13px;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }
        .test-item-result{
            font-size: 14px;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
        }
        .font-weight-400 {
            font-weight: 400;
        }

        .th_border {
            border-bottom: 1px solid #dfe0e1 !important;
            border-top: 0px solid #ffffff !important;
        }
        @if(isset($page_break_after_dept->value) && $page_break_after_dept->value == 'yes')
            @media print {
                .pagebreak {
                    clear: both;
                    page-break-after: always;
                }
            }
        @endif
        .top-border {
            border-top: 1px solid black;
        }
        .bottom-border {
            border-bottom: 1px solid black;
        }

        .pathology-bill,
        .pathology-bill .table td,
        .pathology-bill .table th {
            font-size: 12px !important;
        }
        .bottom-border-width {
            border-bottom-width: 0 !important;
        }
    </style>
    <style type="text/css">
        @page {
          size: A4;
          margin: 0 auto;
          margin-bottom: 0.5cm;
          margin-top: 0.5cm;
        }
        @media print {
            .report-footer {
                color: black;
                background-color: transparent;
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                border-top: solid black 1px;
            }
            
            .report-container {
                width: 100%;
                margin-bottom: 60px; /* Adjust according to the footer height */
                page-break-inside: auto;
            }

            .report-header, .report-content, .report-footer {
                page-break-inside: avoid;
            }

            .report-footer {
                page-break-before: always; /* Move tfoot to the next page if necessary */
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            .report-content {
                page-break-after:always
            }
        }
    </style>
    <div class="pathology-bill">
        <div class="row">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                    @php $company = @$sale_invoice->getCompany; @endphp
                                    @php $voucherType = 'PATHOLOGY_LAB_BILLING'; @endphp
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell" style="font-weight: normal;">
                                                @include('components.lab-report-letter-head')
                                                @include('components.lab-report-voucher-details')
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell">
                                                <div class="row report-body">
                                                    @php
                                                        $gender = $sale_invoice->getPatient->account_contact->account_gender_id ?? '1';
                                                        $date_of_birth = $sale_invoice->getPatient->account_contact->date_of_birth ?? '';
                                                        $age = $date_of_birth != '' ? ageInHours($sale_invoice->getPatient->account_contact->date_of_birth) : 0;
                                                    @endphp

                                                    @if (count($testPackages) > 0 && count($billing_report) > 0)
                                                                                                                <div class="col-md-12">
                                                            @foreach ($testPackages as $key => $value)
                                                                <div class="department">
                                                                    @php $showSignatures = 0; @endphp
                                                                    <div style="display: flex; justify-content: center;text-align: center;margin-bottom: 10px">
                                                                        <div style="width: 10%" class="department-title-side">
                                                                        </div>
                                                                        <!-- department names  -->
                                                                        <div style="width: 80%">
                                                                            @if (isset($value['department']->show_in_report) && $value['department']->show_in_report == 1)
                                                                                <h4 class="department-title"><u>{!! @$value['department']->name ?? '' !!}</u></h4>
                                                                            @endif
                                                                        </div>
                                                                        <div style="width: 10%"> Print <input class="form-check-input1 department_checkbox" type="checkbox" checked=""></div>
                                                                    </div>

                                                                    @if (isset($value['department']->show_report_heading) && $value['department']->show_report_heading == 1)
                                                                    <table class="table align-middle"
                                                                        style="border: 1px solid #565656;">
                                                                        <thead class="table-light">
                                                                            <tr>
                                                                                <th width="30%" class="text-left bottom-border-width"><span class="report_table_headings">Investigation</span></th>
                                                                                <th width="25%" class="text-left bottom-border-width"><span class="report_table_headings">Result</span></th>
                                                                                @if(!isset($show_flag->value) || (isset($show_flag->value) && $show_flag->value == 'yes'))
                                                                                    <th width="5%" class="text-left bottom-border-width"><span class="report_table_headings">Flag</span></th>
                                                                                @endif
                                                                                <th width="10%" class="text-left bottom-border-width"><span class="report_table_headings">Unit</span></th>
                                                                                <th width="25%" class="text-left bottom-border-width"><span class="report_table_headings">Reference Range</span></th>
                                                                            </tr>
                                                                        </thead>
                                                                    </table>
                                                                    @endif
                                                                    <div id="container" class="col-md-12 row" style="padding-right: 0;--bs-gutter-x:0;margin-bottom: 10px">
                                                                        @foreach ($value['test_packages'] as $test_packages)
                                                                            <table class="table align-middle" style="border: 1px solid #dee2e6;border-right: none;border-left: none;border-top: none;">
                                                                                <thead>
                                                                                    {{-- <div class="sort" data-priority="{{ $test_packages->priority }}"> --}}
                                                                                    <tr>
                                                                                        <th colspan="{!! isset($show_flag->value) && $show_flag->value == 'yes' ? '4' : '3' !!}" width="75%" class="" style="border-bottom: 1px solid #dfe0e1 !important;border-top: 0px solid #ffffff !important;">
                                                                                            @if ($test_packages['show_in_report'] == 1)
                                                                                                <h5 class="test-package-title">{!! $test_packages->name ?? '' !!}</h5>
                                                                                            @endif
                                                                                        </th>
                                                                                        <th width="25%" class="text-align-right font-weight-400 " style="border-bottom: 1px solid #dfe0e1 !important;border-top: 0px solid #ffffff !important;">
                                                                                            {!! $test_packages->reported_at ? 'Reported At : ' . formatedDate($test_packages->reported_at) . ', ' . formatedTime($test_packages->reported_at) . '<br>' : '' !!}
                                                                                            <script type="text/javascript">
                                                                                                $(document).ready(function() {
                                                                                                     $('.registered_at').text("{!! $test_packages->registered_at ? formatedDate($test_packages->registered_at) . ', ' . formatedTime($test_packages->registered_at) : '' !!}");
                                                                                                     $('.collected_at').text("{!! $test_packages->collected_at ? formatedDate($test_packages->collected_at) . ', ' . formatedTime($test_packages->collected_at) : '' !!}");
                                                                                                })
                                                                                            </script>
                                                                                        </th>
                                                                                    </tr>
                                                                                </thead>
                                                                                <tbody>
                                                                                    @foreach ($test_packages->testPackageGroups as $testPackageGroup)
                                                                                        @php $serial = 1; @endphp
                                                                                        @foreach ($testPackageGroup->test_package_group_test_items as $items)
                                                                                            @if($items->test_item->input_type == 'SUMMER_NOTE')
                                                                                            <tr>
                                                                                                <td colspan="{!! isset($show_flag->value) && $show_flag->value == 'yes' ? '5' : '4' !!}">
                                                                                                    {!! $billing_report[$items->test_item->id]->long_result ?? '' !!}
                                                                                                </td>
                                                                                            </tr>
                                                                                            @elseif($items->test_item->input_type == 'IMAGE')
                                                                                            <tr>
                                                                                                <td colspan="{!! isset($show_flag->value) && $show_flag->value == 'yes' ? '5' : '4' !!}" class="text-center">
                                                                                                    <img src="{!! getTempUrl($billing_report[$items->test_item->id]->result) !!}" class="img-thumbnail" style="max-height: 500px;border-radius: 0.5rem !important;">
                                                                                                    <br>
                                                                                                    <span class="test-item-name">{!! $items->test_item->test_name ?? '' !!}</span>
                                                                                                </td>
                                                                                            </tr>
                                                                                            @elseif (isset($billing_report[$items->test_item->id]->result) && !empty($billing_report[$items->test_item->id]->result))
                                                                                            <tr>
                                                                                                <td width="30%" style="line-height: 1.4;"><span class="test-item-name">{!! $items->test_item->test_name ?? '' !!}<br><i>{!! $items->test_item->test_method_name ?? '' !!}</i></span></td>
                                                                                                <td width="25%" class="">
                                                                                                    <b><span class="error_testitem test-item-result {{ $billing_report[$items->test_item->id]->flag }}" style="{!! $billing_report[$items->test_item->id]->flag == '' !!}">{!! $billing_report[$items->test_item->id]->result ?? '' !!}
                                                                                                            <div style="display:flex; justify-content: space-between;">
                                                                                                            </div>
                                                                                                        </span>
                                                                                                    </b>
                                                                                                </td>
                                                                                                @if(!isset($show_flag->value) || (isset($show_flag->value) && $show_flag->value == 'yes'))
                                                                                                @php
                                                                                                    $flag = isset($billing_report[$items->test_item->id]->flag) ? ucfirst(substr($billing_report[$items->test_item->id]->flag, 0, 1)) : '';
                                                                                                @endphp
                                                                                                <td width="5%">
                                                                                                    <span class="test-item-flag">
                                                                                                        <i class="bi bi-{!! $flag == 'L' ? 'arrow-down' : ($flag == 'H' ? 'arrow-up' : '') !!}"></i> {!! $flag == 'N' ? '' : $flag !!}
                                                                                                    </span>
                                                                                                </td>
                                                                                                @endif
                                                                                                <td width="10%">
                                                                                                    <span class="test-item-unit">{!! $items->test_item->unit ?? '' !!}</span>
                                                                                                </td>

                                                                                                <td width="25%">
                                                                                                    <span class="test-item-range">@if ($items->test_item->reference_value_type == 'RANGE' && isset($items->test_item->testItemNormalRange))
                                                                                                        @foreach ($items->test_item->testItemNormalRange->where('gender_id', $gender) as $range)
                                                                                                            @if ($age >= $range->from_age && $age <= $range->to_age)
                                                                                                                {!! ceil($range->low_value) !!} - {!! ceil($range->high_value) !!}
                                                                                                                <input type="hidden" name="" class="range-start" value="{!! ceil($range->low_value) !!}">
                                                                                                                <input type="hidden" name="" class="range-end" value="{!! ceil($range->high_value) !!}">
                                                                                                                @php break; @endphp
                                                                                                            @endif
                                                                                                        @endforeach
                                                                                                    @endif
                                                                                                    @if ($items->test_item->reference_value_type == 'TEXT' && $items->test_item->reference_value != '')
                                                                                                        Ref({!! $items->test_item->reference_value !!})<br>
                                                                                                    @endif
                                                                                                    {!! $items->test_item->unit ?? '' !!}
                                                                                                </span>
                                                                                                </td>
                                                                                            </tr>
                                                                                            @php $showSignatures = 1; @endphp
                                                                                            @endif
                                                                                            @php $serial += 1; @endphp
                                                                                        @endforeach
                                                                                    @endforeach
                                                                                </tbody>
                                                                            </table>
                                                                        @endforeach
                                                                    </div>
                                                                    @if ($showSignatures == 1)
                                                                        <div
                                                                            style="display: flex; justify-content: center;text-align: center;margin-bottom: 20px">
                                                                            <div style="width: 50%; margin-top: 10px">
                                                                                @if (isset($doc_signature_setting->value) && $doc_signature_setting->value == 'Department' && !empty($value['department']->doc_signature))
                                                                                    <img src="{!! getTempUrl($value['department']->doc_signature) !!}" width="200px">
                                                                                    <div style="width: 50%; border-top: 1px solid #bebebe; margin: 0 auto; "></div>
                                                                                @elseif (!empty($test_packages->doctor_signature))
                                                                                    <img src="{!! getTempUrl($test_packages->doctor_signature) !!}" width="200px">
                                                                                    <div style="width: 50%; border-top: 1px solid #bebebe; margin: 0 auto; "></div>
                                                                                @endif
                                                                                <h6 class="mb-0">{!! $test_packages->doctor_prepared_by !!}</h6>
                                                                                <p>{!! $test_packages->doctor_designation !!}</p>
                                                                            </div>
                                                                            <div style="width: 50%; margin-top: 10px">
                                                                                @if (isset($tech_signature_setting->value) && $tech_signature_setting->value == 'Department' && !empty($value['department']->tech_signature))
                                                                                    <img src="{!! isset($value['department']->tech_signature) ? getTempUrl($value['department']->tech_signature) : '' !!}" width="200px">
                                                                                    <div style="width: 50%; border-top: 1px solid #bebebe; margin: 0 auto; "></div>
                                                                                @elseif (!empty($test_packages->technician_signature))
                                                                                    <img src="{!! getTempUrl($test_packages->technician_signature) !!}" width="200px">
                                                                                    <div style="width: 50%; border-top: 1px solid #bebebe; margin: 0 auto; "></div>
                                                                                @endif
                                                                                <h6 class="mb-0">{!! $test_packages->technician_prepared_by !!}</h6>
                                                                                <p>{!! $test_packages->technician_designation !!}</p>
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                </div>
                                                                <div class="pagebreak"> </div>
                                                            @endforeach
                                                        </div>
                                                    @else
                                                        Report Is Not Ready Yet
                                                    @endif
                                                </div>

                                            </td>
                                        </tr>
                                    </tbody>
                                    @include('components.lab-report-footer')
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<div class="text-center">
    <button id="btn_print" type="button" class="btn btn-primary btn-lg"> <i class="bi bi-printer text-white"></i> Print Report </button>
</div>
@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();

            if ($('.letterhead-print').is(':checked') == false) {
                $('.footer-img').hide();
                $('.letter_head_img').hide();
            }

            $(".department_checkbox").each(function() {
                $(this).parent().hide();
                if ($(this).is(':checked') == false) {
                    $(this).closest('.department').hide();
                    $('.ui-switcher').remove();
                }
            });
            $('.department-title-side').hide();

            printInvoice();

            $('#btn_back').show();
            $('.department-title-side').show();
            $('.department').show();
            $('.department_checkbox').parent().show();
            $('.footer-img').show();
            $('.letter_head_img').show();
            return;
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
</script>
@endsection
