<style type="text/css">
    .ui-widget-content {
        z-index: 1060;
    }
</style>
<form class="row g-3 auto-width update-agent" action="{{ route('billings-update-agent', $sale_invoice->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('Post')
    <div class="col-md-12">
        <label class="form-label">Collection Agent Name</label>
        <div class="input-group autocomplete">
            <input type="text" name="" class="collection-select form-control" placeholder="Search Collection Agent.." value="{!! $collection_agent->full_name ?? '' !!}">
            <ul class="searchResult"></ul>
            <div class="input-group-append" style="margin: auto 10px auto 0;">
                <button class="btn btn-secondary add_btn" id="create_collection_lab" type="button" > + </button>
            </div>
            <input type="hidden" name="collection_id" value="{!! $collection_agent->id ?? '' !!}">
        </div>
        <span class="text-danger error_collection_id" style="display:none;">This field is required.</span>
    </div>
</form>

<script type="text/javascript">
    $('.collection-select').autocomplete({
        autoFocus: true,
        minLength: 0,
        source: function(request, response) {
            if (request.term.length < 2) {
                $('[name="collection_id"]').val('');
                return false;
            }

            $.ajax({
                url: '{{ route('billings-search-collection') }}',
                type: 'POST',
                dataType: 'json',
                data: {
                    search_text: request.term
                },
                success: function(json) {
                    if (json.error) {
                        $('[name="collection_id"]').val('');
                        return false;
                    }
                    response($.map(json.result, function(item) {
                        return {
                            id: item.id,
                            code: item.code,
                            name: item.name,
                            gender: item.gender ,
                            phone_no: item.phone_no,
                            date_of_birth: item.date_of_birth,
                        };
                    }));
                }
            });
        },
        select: function(event, ui) {
            event.preventDefault();
            var age      = ui.item.date_of_birth != null ? ', ' + getAge(ui.item.date_of_birth) + ' Years' : '';
            var gender   = ui.item.gender != null ? ', ' + ui.item.gender : '';
            var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';
            var code = ui.item.code != null ? ', ' + ui.item.code : '';

            $(this).val(ui.item.name + code + gender + age + phone_no + "");
            $('[name="collection_id"]').val(ui.item.id);

            $.ajax({
              url     : '{!! route("cart-product-update") !!}',
              method  : 'post',
              data    : {
                    "_token": $('meta[name ="csrf-token"]').attr('content'),
                    "collection_id": ui.item.id,
              }
            });

            return false;
        }
    }).data("ui-autocomplete")._renderItem = function(ul, item) {
        var age      = item.date_of_birth != null ? ', ' + getAge(item.date_of_birth) + ' Years' : '';
        var gender   = item.gender != null ? ', ' + item.gender : '';
        var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';
        var code = item.code != null ? ', ' + item.code : '';

        return $("<li>")
            .append("<a>" + item.name + code + gender + age + phone_no + "</a>")
            .appendTo(ul);
    };
</script>