<style type="text/css">
    .ui-widget-content {
        z-index: 1060;
    }
</style>
<form class="row g-3 auto-width update-doctor" action="{{ route('billings-update-doctor', $sale_invoice->id)}}" method="post" enctype='multipart/form-data'>
    @csrf
    @method('Post')
    <div class="col-md-12">
        <div>
            <label class="form-label">Doctor Name</label>
        </div>
        <div class="input-group autocomplete">
            <input type="text" name="" id="doctor_id" class="doctor-select form-control" placeholder="Search Doctor" value="{!! $doctor->full_name ?? '' !!}">
            <ul class="searchResult"></ul>
            <div class="input-group-append" style="margin: auto 10px auto 0;">
                <button class="btn btn-secondary add_btn" id="create_doctor" type="button"  > + </button>
            </div>
            <input type="hidden" name="doctor_id" value="{!! $doctor->id ?? '' !!}">
        </div>
        <span class="text-danger error_doctor_id" style="display:none;">This field is required.</span>
    </div>
</form>

<script type="text/javascript">
    $('.doctor-select').autocomplete({
        autoFocus: true,
        minLength: 0,
        source: function(request, response) {
            if (request.term.length < 2) {
                $('[name="doctor_id"]').val('');
                return false;
            }

            $.ajax({
                url: '{{ route('billings-search-doctors') }}',
                type: 'POST',
                dataType: 'json',
                data: {
                    search_text: request.term
                },
                success: function(json) {
                    if (json.error) {
                        $('[name="doctor_id"]').val('');
                        return false;
                    }
                    response($.map(json.result, function(item) {
                        return {
                            id: item.id,
                            name: item.name,
                            code: item.code,
                            gender: item.gender ,
                            phone_no: item.phone_no,
                            date_of_birth: item.date_of_birth,
                        };
                    }));
                }
            });
        },
        select: function(event, ui) {
            event.preventDefault();
            var age      = ui.item.date_of_birth != null ? ', ' + getAge(ui.item.date_of_birth) + ' Years' : '';
            var gender   = ui.item.gender != null ? ', ' + ui.item.gender : '';
            var phone_no = ui.item.phone_no != null ? ', ' + ui.item.phone_no : '';
            var code = ui.item.code != null ? ', ' + ui.item.code : '';

            $(this).val(ui.item.name + code + gender + age + phone_no + "");
            $('[name="doctor_id"]').val(ui.item.id);

            $.ajax({
              url     : '{!! route("cart-product-update") !!}',
              method  : 'post',
              data    : {
                    "_token": $('meta[name ="csrf-token"]').attr('content'),
                    "doctor_id": ui.item.id,
              }
            });

            return false;
        }
    }).data("ui-autocomplete")._renderItem = function(ul, item) {
        var age      = item.date_of_birth != null ? ', ' + getAge(item.date_of_birth) + ' Years' : '';
        var gender   = item.gender != null ? ', ' + item.gender : '';
        var phone_no = item.phone_no != null ? ', ' + item.phone_no : '';
        var code = item.code != null ? ', ' + item.code : '';

        return $("<li>")
            .append("<a>" + item.name + code + gender + age + phone_no + "</a>")
            .appendTo(ul);
    };
</script>