@extends('layouts.app')
@section('title', $voucher_type->voucher_title . ' - ' . $sale_invoice->main_invoice_no . ' - ' . ($sale_invoice->invoice_date ?
formatedDate($sale_invoice->invoice_date) : '') . ' - ' . ($sale_invoice->getPatient->name ?? ''))
@section('pages')

<link href="{{ asset('admin/css/print.css')}}" rel="stylesheet" />
<style type="text/css">
    .table {
        line-height: 2;
        margin-bottom: 5px;
    }
    .report_table_headings {
        font-size: 16px;
    }
    .report-body {
        width: 260mm !important;
    }
    .department-title {
        margin-bottom: 0px;
        font-size: 20px;
    }
    .test-package-title {
        margin-bottom: 0px;
        font-size: 16px;
    }
    .remove-border {
        border-top: 1px solid #ffffff;
    }
    .test-item-name {
        margin-left: 10px;
        font-size: 13px;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
    }
    .test-item-method {
        font-size: 10px;
        font-style: italic;

    }
    .test-item-range{
        font-size: 12px;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
    }
    .test-item-unit{
        font-size: 13px;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
    }
    .test-item-flag{
        font-size: 13px;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
    }
    .test-item-result{
        font-size: 14px;
        font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
    }
    .font-weight-400 {
        font-weight: 400;
    }

    .th_border {
        border-bottom: 1px solid #e0e0e0 !important;
        border-top: 1px solid #ffffff;
    }
    @if(isset($page_break_after_dept->value) && $page_break_after_dept->value == 'yes')
        @media print {
            .pagebreak {
                clear: both;
                page-break-after: always;
            }
        }
    @endif
</style>
@php $pageTitle = $sale_invoice->main_invoice_no . ' - ' .($sale_invoice->getPatient->name ?? '').'-'. ($sale_invoice->invoice_date ?
formatedDate($sale_invoice->invoice_date) : '') ; @endphp

<div id="btn_back" class="card-header py-3">
    <div class="row gx-2">
        <div class="col-lg-6 col-md-6 col-6">
            <div class="position-relative">
                <h5>{!! $voucher_type->voucher_title ?? '' !!} | {!! $sale_invoice->main_invoice_no !!}</h5>
            </div>
        </div>
        <div class="col-lg-6 col-md-6">
            <div class="ms-auto float-md-end">

                <div class="btn-group">
                    <a href="{!! route('lab-reporting') !!}" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
                </div>
            </div>
        </div>
    </div>
</div>


<div id="print_div" class="report-body" style="margin: 0 auto">
    <div class="pathology-bill">
        <div class="row">
            <div class="col-md-12 col-xs-12 p-1">
                <div class="card border-0">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-borderless report-container">
                                    @php $company = @$sale_invoice->getCompany; @endphp
                                    @php $voucherType = 'PATHOLOGY_LAB_BILLING'; @endphp
                                    <thead class="report-header">
                                        <tr>
                                            <th class="report-header-cell" style="font-weight: normal;">
                                                @include('components.lab-report-sticker')
                                                <hr>
                                            </th>
                                        </tr>
                                    </thead>

                                    <tbody class="report-content">
                                        <tr>
                                            <td class="report-content-cell">
                                                <div class="row report-body">
                                                    @php
                                                        $gender = $sale_invoice->getPatient->account_contact->account_gender_id ?? '1';
                                                        $date_of_birth = $sale_invoice->getPatient->account_contact->date_of_birth ?? '';
                                                        $age = $date_of_birth != '' ? ageInHours($sale_invoice->getPatient->account_contact->date_of_birth) : 0;
                                                    @endphp


                                                </div>

                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<div class="text-center">
    <button id="btn_print" type="button" class="btn btn-primary btn-lg"> Print Document <i class="bi bi-printer text-white"></i></button>
</div>
@endsection

@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/1.3.4/jspdf.min.js"></script>

<script>
    $(document).ready(function() {
        var page_title = $('#page_title').val();
        $("title").html(page_title);
        $(document).on('click', '#btn_print', function(event) {
            event.preventDefault();

            if ($('.letterhead-print').is(':checked') == false) {
                $('.footer-img').hide();
                $('.letter_head_img').hide();
            }

            $(".department_checkbox").each(function() {
                $(this).parent().hide();
                if ($(this).is(':checked') == false) {
                    $(this).closest('.department').hide();
                    $(this).closest('.department').hide();
                    $('.ui-switcher').remove();
                }
            });
            $('.department-title-side').hide();

            printInvoice();

            $('#btn_back').show();
            $('.department-title-side').show();
            $('.department').show();
            $('.department_checkbox').parent().show();
            $('.footer-img').show();
            $('.letter_head_img').show();
            return;
        });

        $(document).on('click', '#btn_pdf', function(e) {
            html2canvas($('#print_div'), {
                background: "#ffffff",
                onrendered: function(canvas) {
                    var myImage = canvas.toDataURL("image/png", 1.0);
                    // Adjust width and height
                    var imgWidth = (canvas.width * 43) / 250;
                    var imgHeight = (canvas.height * 48) / 250;
                    // jspdf changes
                    var pdf = new jsPDF('p', 'mm', 'a4');
                    pdf.addImage(myImage, 'png', 5, 5, imgWidth, imgHeight); // 2: 19
                    pdf.save(`${$('#page_title').val()}.pdf`);
                }
            });
        });
    });

    function printInvoice() {
        let printDiv = $('#print_div').html();
        let content = window.open('', '', 'height=750px,width=960px');
        let doc = content.document;
        let head = doc.head;
        let body = doc.body;

        $(head).append('<Title>{{$pageTitle}}</Title>');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/bootstrap.min.css') }}" type="text/css">');
        $(head).append('<link rel="stylesheet" href="{{ asset('admin/css/print.css') }}" type="text/css">');
        $(head).append('<style>@page {size: auto;}</style>');
        $(body).append(printDiv);

        setTimeout(function() {
            content.print();
        }, 500);
    }
</script>
@endsection
