<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Invoice No.</th>
                <!-- <th>Date</th> -->
                <th>Patient Details</th>
                <th>Ref.By/Referral</th>
                <th style="text-align:right">Bill Amount</th>
                <th class="thbutton">Bill</th>
                {{--<th class="thbutton">Report</th>--}}
                <th class="thbutton">Report</th>
                <th class="thbutton">Balance</th>
                <!-- <th class="thbutton">Status</th> -->
                @if(in_array('pathology-lab-billing-edit', $authRolePermissions))
                <th class="thbutton">Edit</th>
                @endif
                @if(auth()->user()->can('pathology-lab-billing-delete'))
                <th class="thbutton">Delete</th>
                @endif
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @if(count($data)>0)
                @foreach($data as $key=> $list)
                @php $Receive = TransactionCalculationReceiveAmount($list->id,'PATHOLOGY'); @endphp
                    <tr>
                        <td class="text-center">{{$data->firstItem() + $key}}</td>
                        <td>
                            <a href="{!! route('lab-billings.show', $list->id) !!}" class="hyperlink">
                                <b>{{$list->voucher_type_invoice_no??''}}</b>
                            </a>
                            <br>
                                {{ formatedDate($list->invoice_date) }}<br>
                                {{ formatedTime($list->invoice_date) }}
                        </td>
                        <td>
                            {!! $list->getPatient->account_title->name??''!!}
                            {{ $list->getPatient->name ?? '' }}<br>
                            {{ $list->getPatient->account_contact->gender->name ?? '' }}{{ isset($list->getPatient->account_contact->date_of_birth) && isset($list->getPatient->account_contact->gender) ? ', ' : '' }} {{ isset($list->getPatient->account_contact->date_of_birth) ? age($list->getPatient->account_contact->date_of_birth) . ' years' : '' }}<br>
                            {!!
                                isset($list->task_status) && !empty($list->task_status) ? '<span class="badge badge-pill bg-secondary text-white">Report '. $list->task_status .'</span>' : ''
                            !!}
                        </td>
                        <td>
                            @php
                                $doctor_name = isset($list->getDoctor) && isset($list->getDoctor->name) && $list->getDoctor->name != '' ? $list->getDoctor->name : 'Self';
                                $doctor_title = isset($list->getDoctor) && isset($list->getDoctor->account_title) && isset($list->getDoctor->account_title->name) != '' ? $list->getDoctor->account_title->name : '';
                            @endphp
                            {{ $doctor_title.' '.$doctor_name }}
                            <br>
                            <div style="color:#aaa">By: {!! $list->getCreatedBy->prepared_by??'' !!}</div>
                        </td>
                        <td style="text-align:right">
                            Total: {{ convertDecimelPoint($Receive['totalBilling']) ?? ''}}
                            @if($Receive['dueAmount']>0)
                                <br>
                                <span class="badge btn-secondary text-white"> Due: {{ convertDecimelPoint($Receive['dueAmount']) ?? ''}}</span>
                            @endif
                            @if($Receive['receivedAmount']>0)
                                <br>
                                <a href="{!! route('billing-collection-list',['invoice_id'=>$list->id,'module_code'=>'PATHOLOGY']) !!}?redirect=lab-billings" class="">
                                    <b>Received: {{ convertDecimelPoint($Receive['receivedAmount']) ?? ''}}</b>
                                </a>
                            @endif
                        </td>
                        <td class="text-center">
                            <a class="btn btn-success" href="{!! route('pathology-invoice', $list->id) !!}">
                                <i class="bi bi-printer text-white"></i>
                            </a>
                        </td>
                        {{--<td class="text-center">
                            <a href="{!! route('billing-report', $list->id) !!}" class="btn btn-primary">
                                <i class="bi bi-bar-chart text-white"></i>
                            </a>
                        </td>--}}
                        <td class="text-center">
                            @if($list->sub_details_count > 0)
                            <a href="{!! route('print-billing-report', $list->id) !!}?redirect=lab-billings" class="btn btn-info">
                                <i class="bi bi-receipt text-white"></i> 
                            </a>
                            @endif
                        </td>
                        <td class="text-center">
                            {!! $Receive['dueAmount'] > 0 ? '<a href="' . route('billing-collection',['invoice_id'=>$list->id,'voucher_type'=>'pathology']) .'?redirect=lab-billings" class="btn-sm btn-success text-white">Collect</a>' : '<i class="bi bi-check-circle text-success" style="font-size: 30px;" title="Amount Collected."></i>' !!}
                        </td>
                        {{-- <td class="text-center">
                            {!! $list->due_amount > 0 ? '<a href="' . route('sticker-billing-report',['id'=>$list->id,'voucher_type'=>'pathology']) .'" class="btn-sm btn-secondary text-white"><i class="bi bi-sticky"></i></a>' : 'Big BarCode' !!}
                        </td>
                        <td>
                            {{$list->enquiry_quality_name ?? ''}}
                            
                        </td> --}}
                        @if(in_array('pathology-lab-billing-edit', $authRolePermissions))
                        <td class="text-center">
                            <a href="{{route('lab-billings.edit', $list->id)}}" class="btn btn-warning" title="Edit">
                                <i class="bi bi-pencil-square text-white"></i>
                            </a>
                        </td>
                        @endif
                        @if(auth()->user()->can('pathology-lab-billing-delete'))
                        <td class="text-center">
                            <a data-url="{{route('lab-billings.destroy')}}" data-id="{{$list->id}}" class="btn btn-danger deleteDataCustom" href="#" class="text-danger" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Delete">
                                <i class="bi bi-trash text-white"></i>
                            </a>
                        </td>
                        @endif
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="18" class="text-center">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="mt-2 row">
    <div class="col-lg-10 col-md-10 col-10 float-start">
        {!! $data->onEachSide(0)->render('enquiry-statuses.pagination') !!}
    </div>
    <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length" style="text-align: right;">
        <i class="bi bi-funnel" style=" top: 11px;left: 20px;"></i>
        <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example" style="padding-left: 30px;">
            <option value="10">Show: 10</option>
            <option value="30">Show: 30</option>
            <option value="50">Show: 50</option>
        </select>
    </div>
</nav>
</div>

