@extends('layouts.app')
@section('pages')

<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />
    <div class="card style_table shadow-none radius-5 min-height">
        <div class="card-header py-3">
            @include('layouts.partials.nav-menu')
            <div class="row gx-2">

              <div class="col-lg-2 col-md-2 col-4 dataTables_length">
                <i class="bi bi-clock"></i>
                <input class="form-control ps-5 datepickers" type="text" id="start_date" name="start_date" autocomplete="off" placeholder="Start Date">
              </div>

              <div class="col-lg-2 col-md-2 col-4 dataTables_length">
                <i class="bi bi-clock"></i>
                <input class="form-control ps-5 datepickers" type="text" id="end_date" name="end_date" autocomplete="off" placeholder="End Date">
              </div>

              <div class="col-lg-2 col-md-2 col-4 dataTables_length">
                <button class="search-button btn btn-outline-primary">Search</button>
              </div>

              <div class="col-lg-7 col-md-7">
                <div class="ms-auto float-md-end">

                  <div class="btn-group">
                      <!-- <a href="javascript:history.back()" class="btn btn-outline-secondary me-1"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a> -->
                  </div>
                </div>
              </div>
            </div>
        </div>
    </div>

    <div class="row row-cols-1 row-cols-lg-3 row-cols-xl-3 row-cols-xxl-3">
        <div class="col-12">
            <h6>Reporting Dashboard</h6>
        </div>
        <div class="col">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">No of Reports</p>
                            <h4 class="mb-0 text-primary"><span class="total_reports">{!! $total_reports !!}</span></h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-kanban-fill"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">Ready To Print Reports</p>
                            <h4 class="mb-0 text-primary"><span class="doneReports">{!! $doneReports !!}</span>/<span class="total_reports">{!! $total_reports !!}</span></h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-kanban-fill"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">Sample Collected</p>
                            <h4 class="mb-0 text-primary"><span class="sampleCollected">{!! $sampleCollected !!}</span>/<span class="total_reports">{!! $total_reports !!}</span></h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-kanban-fill"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">Result Updated</p>
                            <h4 class="mb-0 text-primary"><span class="updatedReports">{!! $updatedReports !!}</span>/<span class="total_reports">{!! $total_reports !!}</span></h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-kanban-fill"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
        <div class="col">
            <div class="card radius-5">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="">
                            <p class="mb-1">Doctor Reviewed</p>
                            <h4 class="mb-0 text-primary"><span class="doneReports">{!! $doneReports !!}</span>/<span class="total_reports">{!! $total_reports !!}</span></h4>
                        </div>
                        <div class="ms-auto fs-2 text-primary">
                            <i class="bi bi-kanban-fill"></i>
                        </div>
                    </div>
                </div>
            </div>
       </div>
    </div>
@endsection

@section('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>

<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
<script>
    $(function() {
        $('.datepickers').datepicker({
            format: 'mm/dd/yy',
        }).on('changeDate', function(ev) {
            $(this).datepicker('hide');
        });

        $(document).on('click', '.search-button', function() {
            var start_date = $('[name="start_date"]').val();
            var end_date   = $('[name="end_date"]').val();

            if (start_date.trim() != '' && end_date.trim() != '') {
               $.ajax({
                    url: "{{ route('lab-reporting-dashboard') }}",
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        "_token"     : $('meta[name="csrf-token"]').attr('content'),
                        "start_date" : start_date,
                        "end_date"   : end_date
                    },
                    success: function(json) {
                        $('.total_reports').text(json.total_reports);
                        $('.doneReports').text(json.doneReports);
                        $('.sampleCollected').text(json.sampleCollected);
                        $('.updatedReports').text(json.updatedReports);
                    }
                });
            } else {
                toastr.error('Start and End dates are required!');
            }
        });
    });
</script>
@endsection
