<div class="table-responsive">
    <table id="example" class="table table-bordered align-middle" style="width:100%">
        <thead class="table-light">
            <tr>
                <th class="thbutton">Sl No</th>
                <th>Invoice No.</th>
                <th>Batch No.</th>
                <th>Patient Name</th>
                <th>Test And Department</th>
                <th class="thbutton">Result Status</th>
                <th class="thbutton">Review Result</th>
            </tr>
        </thead>
        <tbody>
            @php $i=1;@endphp
            @php
                $badge = [
                    'HOLD'             => 'secondary',
                    'PENDING'          => 'info',
                    'RESULT_RECHECK'   => 'warning',
                    'RESULT_REVIEWED'  => 'success',
                    'RESULT_UPDATED'   => 'info',
                    'SAMPLE_COLLECTED' => 'primary',
                ];
            @endphp
            @if(count($saleInvoices)>0)
                @foreach($saleInvoices as $key => $list)
                    <tr>
                        <td class="text-center">{{ $i }}</td>
                        <td>
                            <a href="{!! route('lab-billings.show', $list->id) !!}">
                                <b>{{$list->voucher_type_invoice_no}}</b>
                            </a>
                            <br>
                                {{ formatedDate($list->invoice_date) }}
                        </td>
                        <td>
                            {{ $list->invoice_batch_no }}<br>
                            {{ formatedDate($list->invoice_batch_date) }} {{ formatedTime($list->invoice_batch_date) }}
                        </td>
                        <td>
                            {{$list->account_title ?? ''}} {{ ucfirst($list->patent_name) ?? ''}}<br>
                            {{$list->gender ?? ''}}{{ isset($list->date_of_birth) && isset($list->gender) ? ', ' : '' }} {{ isset($list->date_of_birth) ? age($list->date_of_birth) . ' Years' : '' }}
                        </td>
                        <td>
                            <span style="font-size: 13px;color: #06466f" style="white-space: break-spaces;"><b>{{$list->test_package_name ?? ''}}</b></span><br>
                            <small style="white-space: break-spaces;">{{$list->department_name ?? ''}}</small>
                        </td>
                        <td class="text-center">
                            @if($list->all_tests_reviewed == '1')
                                <span class="badge bg-{!! $badge[$list->status_code] ?? 'success' !!}">{!! $list->status !!}</span>
                            @else
                                <span class="badge bg-{!! $badge[$list->status_code] ?? 'danger' !!}">{!! $list->status !!}</span>
                            @endif
                        </td>
                        <td class="text-center">
                            <a href="{!! route('doctor-review', ['invoice_id' => $list->id]) !!}?batch_id={!! $list->batch_id !!}&redirect_route=billing-report" class="btn btn-primary button-large text-white">
                                <i class="bi bi-pencil-square text-white"></i> Review Result
                            </a>
                        </td>
                    </tr>
                    @php $i++; @endphp
                @endforeach
            @else
                <tr>
                    <td colspan="18" class="text-center">No Data Found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
<nav class="row align-items-center mt-3">
    <div class="col-md-6">
        {!! $saleInvoices->onEachSide(0)->render('lab-reporting.doctor-reviews.pagination') !!}
    </div>
    <div class="col-md-6">
      <div class="row gx-2">
        <div class="col-md-9">
        </div>
        <div class="col-lg-3 col-md-3 col-3 dataTables_length" id="example_length">
          <select class="form-select sorting sorting-box" id="" name="example_length" aria-controls="example">
              <option value="20">Show: 20</option>
              <option value="30">Show: 30</option>
              <option value="50">Show: 50</option>
          </select>
        </div>
      </div>
    </div>
</nav>
</div>

