@extends('layouts.app')
@section('title','Lab Reporting')
@section('pages')
<style type="text/css">
    .breadcrumb-title {
      border-right: none;
    }
</style>

<link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css')}}" rel="stylesheet" />

  <!--breadcrumb-->
  <div class="page-breadcrumb row align-items-center justify-content-between mb-3 px-3 px-md-0">
    <div class="breadcrumb-title col-md-6">Result Update
    </div>
    <div class="col-md-6">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb justify-content-md-end mb-0">
          <li class="breadcrumb-item"><i class="bi bi-info-circle-fill text-info show-help-support" data-id="28" data-bs-toggle="modal" data-bs-target="#commonModal"></i></li>
          <li class="breadcrumb-item" aria-current="page">Result Update</li>
        </ol>
      </nav>
    </div>
  </div>
  <!--end breadcrumb-->

  <div class="card style_table shadow-none radius-5 min-height">
    <div class="card-header py-3">
      @include('layouts.partials.nav-menu')
      <div class="row gx-2">

        <div class="col-lg-2 col-md-2 col-4 dataTables_length" id="example_length">
          <i class="bi bi-funnel"></i>
          <select class="form-select" id="" name="search_type" aria-controls="example">
              <option value="invoice_no">Invoice No</option>
              <option value="batch_no">Batch No</option>
              <option value="pat_name">Name</option>
              <option value="phone">Phone Number</option>
              <option value="abha_no">UHID/ABHA NO</option>
              <option value="test">Test</option>
              <option value="department">Department</option>
          </select>
        </div>

        <div class="col-lg-2 col-md-2 col-8">
            <div class="position-relative">
                <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                <input class="form-control ps-5" type="search" id="search" placeholder="Search">
            </div>
        </div>
        <div class="col-lg-2 col-md-2 col-2 dataTables_length" id="example_length">
          <i class="bi bi-funnel"></i>
          <select class="form-select" id="" name="status" aria-controls="example">
              <option value="pending"selected>Pending Results</option>
              <option value="done">Done Results </option>
              <option value="all">All Results </option>
          </select>
        </div>
        <div class="col-lg-2 col-md-2 col-8">
          <div class="position-relative">
            <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-calendar"></i></div>
            <input class="form-control ps-5 from_date" type="text" name="from_date" id="from_date" placeholder="dd/mm/yyyy" value="{{$from_date}}" style="background: #fff9e4;font-weight: bold;">
          </div>
        </div>
        <div class="col-lg-3 col-md-3 col-3 dataTables_length" id="type">
        </div>

        <div class="col-lg-1 col-md-5">
          <div class="ms-auto float-md-end">

          </div>
        </div>
      </div>
    </div>

    <div class="card-body" id="tables">
      
      @include('lab-reporting.result-update.table')

      <input type="hidden" name="hidden_page" id="hidden_page" value="1" />
      <input type="hidden" name="hidden_column_name" id="hidden_column_name" value="name" />
      <input type="hidden" name="hidden_sort_type" id="hidden_sort_type" value="asc" />
    </div>

  @endsection
  @section('js')
  <script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')}}"></script>
  <script>
     /***************** Global Delay Fucntion ***************/
     function delay(callback, ms) {
        var timer = 0;
        return function() {
            var context = this,
                args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                callback.apply(context, args);
            }, ms || 0);
        };
    }
    $(document).ready(function(){

      $('[name="from_date"]').datepicker({
        format: "{!! $companyDateFormate??'dd-mm-yyyy' !!}",
        autoclose: true,
        })/*.datepicker("setDate", {!! $from_date !!})*/;

      function clear_icon(){
        $('#id_icon').html('');
        $('#post_title_icon').html('');
      }

      function fetch_data(page, sort_type, sort_by, query, type,from_date){
        var search_type       = $('[name="search_type"]').val();
        $.ajax({
          url:"?page="+page+"&sortby="+sort_by+"&sorttype="+sort_type+"&query="+query+"&type="+type+"&search_type="+search_type + "&from_date="+ from_date,
          success:function(data){
            $('.ui-switcher').remove();
            $('#tables').html('');
            $('#tables').html(data);
            $.switcher('[name="status"]');
            $.switcher('.changeStatusCustom');
          }
        })
      }

      /******** searching ********/
      $(document).on('keyup', '#search', delay(function() {
        var query = $('#search').val();
        
        if (query.length < 2 && query.length != 0) {
            return;
        }

        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        var page        = 1?1:(this).attr('href').split('page=')[1];
        var type        = $('[name="status"]').val();
        var from_date = $('#from_date').val();
        fetch_data(page, sort_type, column_name, query, type,from_date);
      }, 700));

      $('body').on('change', '.sorting', function(){
        var column_name   = $(this).val();
        var order_type    = $(this).data('sorting_type');
        var reverse_order = '';
        var page          = 1?1:(this).attr('href').split('page=')[1];
        var query         = $('#search').val()?$('#search').val():'';
        var type        = $('[name="status"]').val();
        var from_date = $('#from_date').val();
        fetch_data(page, reverse_order, column_name, query, type,from_date);
      });

      $('body').on('click', '.pager a', function(event){
        event.preventDefault();
        $('#hidden_page').val(page);
        var page        = $(this).attr('href').split('page=')[1];
        var column_name = $('.sorting').val()?$('.sorting').val():'';
        var sort_type   = $('#hidden_sort_type').val();
        var query       = $('#search').val()?$('#search').val():'';
        $('li').removeClass('active');
        $(this).parent().addClass('active');

        var type        = $('[name="status"]').val();
        var from_date = $('#from_date').val();
        fetch_data(page, sort_type, column_name, query, type,from_date);
      });

      $('body').on('change', '[name="status"]', function(){
        var type        = $(this).val();
        var query       = $('#search').val();
        var column_name = $('.sorting').val();
        var sort_type   = $('#hidden_sort_type').val();
        var page        = 1?1:(this).attr('href').split('page=')[1];

        var from_date = $('#from_date').val();
        fetch_data(page, sort_type, column_name, query, type,from_date);
      });

      $('body').on('change', '.from_date', function() {
        var column_name = $('.sorting').val() ? $('.sorting').val() : '';
        var order_type =$('.sorting').val() ? $('.sorting').val() : '';
        var reverse_order = '';
        var page = 1 ? 1 : (this).attr('href').split('page=')[1];
        var query = $('#search').val() ? $('#search').val() : '';
        var from_date = $('#from_date').val();
        console.log(from_date);
        var status        = $('[name="status"]').val();
        fetch_data(page, reverse_order, column_name, query,status,from_date);
      });

      /*********delete data**********/
      $("body").on("click",'.deleteDataCustom', function(event){
          dataString    = {"id":$(this).data('id')};  
          var UrlValue  = $(this).data('url');
          var btn = $(this);

          Swal.fire({
              title: 'Are you sure you want to delete this?',
              icon: 'warning',
              showDenyButton: true,
              showCancelButton: false,
              confirmButtonText: 'Yes',
              denyButtonText: 'No',
          }).then((result) => {
              /* Read more about isConfirmed, isDenied below */
              if (result.isConfirmed) {
                  $.ajax({
                  url     : UrlValue,
                  method  : 'post',
                  data    :{
                          "_token": $('meta[name="csrf-token"]').attr('content'),
                          "id": $(this).data('id')
                  },
                  headers:
                  {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  },
                  beforeSend: function( xhr ) {
                      // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                  },
                  success : function(response){
                      if(response.success){
                          var ErroMsg = $(this).printErrorMsg(response.message);

                          $(this).Toastshow('success',ErroMsg);

                          var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                          var column_name = $('.sorting').val()?$('.sorting').val():'';
                          var sort_type   = $('#hidden_sort_type').val();
                          var query       = $('#search').val()?$('#search').val():'';
                          var type        = $('[name="status"]').val();
                          var from_date = $('#from_date').val();
                          fetch_data(page, sort_type, column_name, query, type,from_date);
                      }else{
                          var ErroMsg = $(this).printErrorMsg(response.message);
                          $(this).Toastshow('error',ErroMsg);
                      }
                  },
                  error: function (data) {
                    console.log("error ",data);
                  }   
              });
              }
          });
      });

      /*********change status**********/
      $("body").on("click",'.changeStatusCustom', function(event){
          dataString       = {"id":$(this).data('id'),"status":$(this).data('status')};  
          var UrlValue     = $(this).data('url');
          var status       = $(this).data('status');
          var changeStatus = $(this);
          var btn = $(this);

          Swal.fire({
              title: 'Are you sure you want to change status?',
              icon: 'warning',
              showDenyButton: true,
              showCancelButton: false,
              confirmButtonText: 'Yes',
              denyButtonText: 'No',
          }).then((result) => {
              if (result.isConfirmed) {
                  $.ajax({
                      url     : UrlValue,
                      method  : 'post',
                      data    :dataString,
                      headers:
                      {
                          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                      },
                      beforeSend: function( xhr ) {
                          // xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
                      },
                      success : function(response){
                          if(response.success){
                              var ErroMsg = $(this).printErrorMsg(response.message);
                              $(this).Toastshow('success',ErroMsg);

                              var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                              var column_name = $('.sorting').val()?$('.sorting').val():'';
                              var sort_type   = $('#hidden_sort_type').val();
                              var query       = $('#search').val()?$('#search').val():'';

                              var type        = $('[name="status"]').val();
                              var from_date = $('#from_date').val();
                              fetch_data(page, sort_type, column_name, query, type,from_date);
                          } else {
                              var ErroMsg = $(this).printErrorMsg(response.message);
                              if (ErroMsg === '') {
                                  ErroMsg = "Something went wrong!";
                              }
                              $(this).Toastshow('error',ErroMsg);

                              if (status == 1) {
                                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                              } else {
                                  changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                              }
                          }
                      },
                      error: function (data) {
                          console.log("error ",data);

                          if (status == 1) {
                              changeStatus.parent().find('.ui-switcher').attr('aria-checked', false);
                          } else {
                              changeStatus.parent().find('.ui-switcher').attr('aria-checked', true);
                          }
                      }   
                  });
              }
              else if (result.isDenied) {
                  var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                  var column_name = $('.sorting').val()?$('.sorting').val():'';
                  var sort_type   = $('#hidden_sort_type').val();
                  var query       = $('#search').val()?$('#search').val():'';

                  var type        = $('[name="status"]').val();
                  var from_date = $('#from_date').val();
                  fetch_data(page, sort_type, column_name, query, type,from_date);
              }
              //return false;
          });
      //return false;
      });
      $("body").on("click",'.reupdate', function(event){
          var UrlValue = $(this).data('url');
          $.ajax({
              url     : UrlValue,
              method  : 'post',
              data    : {},
              headers:
              {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              },
              success : function(response){
                  if(response.success){
                    var page        = $('.pager').find('.active a').attr('href') == undefined ? 1 : $('.pager').find('.active a').attr('href').split('page=')[1];
                    var column_name = $('.sorting').val()?$('.sorting').val():'';
                    var sort_type   = $('#hidden_sort_type').val();
                    var query       = $('#search').val()?$('#search').val():'';

                    var type        = $('[name="status"]').val();
                    var from_date = $('#from_date').val();
                    fetch_data(page, sort_type, column_name, query, type,from_date);

                    $(this).Toastshow('success', response.message);
                  } else {
                    $(this).Toastshow('error', 'Something went wrong!');
                  }
              }
          });
      });
    });
  </script>
@endsection