@php
    if (session()->has('company_data')) {
        $companyData = session('company_data');
    } else {
        $companyData = getComapnyName(); // Assuming getComapnyName() is a helper function or method
    }
@endphp
<!DOCTYPE html>
<html lang="en" class="semi-dark">

    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <!--Less-->
        <link rel="stylesheet/less" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
        <!--plugins-->
        <link href="{{ asset('admin/plugins/simplebar/css/simplebar.css') }}" rel="stylesheet" />
        <link href="{{ asset('admin/plugins/perfect-scrollbar/css/perfect-scrollbar.css') }}" rel="stylesheet" />
        <link href="{{ asset('admin/plugins/select2/css/select2.min.css') }}" rel="stylesheet" />
        <link href="{{ asset('admin/plugins/select2/css/select2-bootstrap4.css') }}" rel="stylesheet" />
        <link href="{{ asset('admin/plugins/metismenu/css/metisMenu.min.css') }}" rel="stylesheet" />
        <link href="{{ asset('admin/plugins/datetimepicker/css/classic.css') }}" rel="stylesheet" />
        <link href="{{ asset('admin/plugins/datepicker/css/datepicker.css') }}" rel="stylesheet" />
        <!-- Bootstrap CSS -->
        <link href="{{ asset('admin/css/bootstrap.min.css') }}" rel="stylesheet" />
        <link href="{{ asset('admin/css/bootstrap-extended.css') }}" rel="stylesheet" />
        <link href="{{ asset('admin/css/icons.css') }}" rel="stylesheet">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css" rel="stylesheet">

        <!----print css-->

        <!-- Stylesheet CSS -->
        <link href="{{ asset('admin/css/style.css') }}" rel="stylesheet" />
        <!-- switcher -->
        <link href="{{ asset('admin/css/switcher.css') }}" rel="stylesheet" type="text/css">
        <!-- loader-->

        <!--Theme Styles-->
        <link href="{{ asset('admin/css/theme/semi-dark.css') }}" rel="stylesheet" />
        <!-- Favicon.io -->
        <link rel="icon" href="{{ asset('admin/images/favicon.ico') }}" type="image/png" />

        <script type="text/javascript" src="{{ asset('admin/js/jquery3.3.1.min.js') }}"></script>
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <link href="{{ asset('admin/css/toastr.min.css') }}" rel="stylesheet" type="text/css">
        <link href="{{ asset('admin/css/sweetalert2.min.css') }}" rel="stylesheet" type="text/css">

        <script type="text/javascript" src="{{ asset('admin/js/parsley.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/js/toastr.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/js/sweetalert2.all.min.js') }}"></script>

        <link href="{{ asset('admin/css/jquery-ui.css') }}" rel="stylesheet" type="text/css">

        <!-- Meta Taggs -->
        <title>@yield('title') | {!! $companyData['name']??'' !!}</title>
        <meta name="author" content="#website_title_here">
        <meta name="description" content="#website_meta_description_here">
        <meta name="keywords" content="#website_meta_keywords_here">
        <style type="text/css">
            .ui-autocomplete {
                width: auto !important;
            }

            .debit_amount {
                font-size: 14px;
                text-align: right;
                border: solid 1px red;
            }

            .credit_amount {
                font-size: 14px;
                text-align: right;
                border: solid 1px green;
            }
        </style>
        @yield('css')
    </head>

    <body>
      

        <textarea class="editor user_note"></textarea>
        <textarea class="editor admin_note"></textarea>
        <!--start wrapper-->
        <div class="wrapper">
            <!--start top header-->
            <header class="top-header">
                <nav class="navbar navbar-expand">
                    <div class="mobile-toggle-icon d-xl-none">
                        <i class="bi bi-list"></i>
                    </div>
                    <div class="top-navbar d-none d-xl-block">
                        <ul class="navbar-nav align-items-center">
                            <li class="nav-item me-3">
                                <b>{!! $companyData['name'] ?? '' !!}</b>
                            </li>
                        </ul>
                    </div>
                    <form class="searchbar d-none d-xl-flex ms-auto">
                        <div class="position-absolute top-50 translate-middle-y search-icon ms-3"><i
                                class="bi bi-search"></i></div>
                        <input class="form-control sideMenusearchbar" type="text" placeholder="Type here to search">
                        <div class="position-absolute top-50 translate-middle-y d-block d-xl-none search-close-icon"><i
                                class="bi bi-x-lg"></i></div>
                    </form>
                    <div class=" d-none d-xl-flex ms-auto w-2" style="width: 20%;">
                        <select class="form-control" id="{!! request()->segment(1) == 'dashboard' ? 'user_financial_year' : '' !!}" {!! request()->segment(1) == 'dashboard' ? '' : 'disabled' !!}>
                            <option value="">Select Financial Year</option>
                            @php $user_financial_year_id = \Session::get('user_financial_year_id') ?? ''; @endphp
                            @php $financialyear = \Session::get('financialyear') ?? ''; @endphp

                            @foreach ($financialyear as $key => $value)
                                <option value="{!! $value->financialyearid !!}" {!! $user_financial_year_id == $value->financialyearid ? 'selected' : '' !!}>Financial Year
                                    {!! $value->financial_year_name !!}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="top-navbar-right ms-auto ms-md-0">
                        <ul class="navbar-nav align-items-center">
                            <li class="nav-item dropdown dropdown-large">
                            </li>
                            <li class="nav-item dropdown dropdown-large">
                                <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="#"
                                    data-bs-toggle="dropdown">
                                    <div class="projects">
                                        <i class="bi bi-grid-3x3-gap-fill"></i>
                                    </div>
                                </a>
                                <div class="dropdown-menu dropdown-menu-end">
                                    <div class="row row-cols-3 gx-2">
                                        {{-- <div class="col">
                                <a href="{{ isset($module['route']) && !empty($module['route']) ? url($module['route']) : '#' }}">
                                   <div class="apps p-2 radius-5 text-center">
                                      <div class="parent-icon"><i class="bi bi-{{ !empty($module['icon']) ? $module['icon'] : 'people-fill' }}"></i></div>
                                      <div class="menu-title">{!! !empty($module['menu_name']) ? $module['menu_name'] : 'people-fill' !!}</div>
                                   </div>
                                </a>
                             </div> --}}
                                        @foreach ($quickMenuModules as $module)
                                            @if(in_array($module['permission'], $authRolePermissions))
                                            <div class="col">
                                                <a
                                                    href="{{ isset($module['route']) && !empty($module['route']) ? url($module['route']) : '#' }}">
                                                    <div class="apps p-2 radius-5 text-center">
                                                        <div
                                                            class="apps-icon-box mb-1 text-white bg-danger bg-gradient">
                                                            <i
                                                                class="bi bi-{{ !empty($module['icon']) ? $module['icon'] : 'people-fill' }}"></i>
                                                        </div>
                                                        <p class="mb-0 apps-name">{!! !empty($module['menu_name']) ? $module['menu_name'] : 'people-fill' !!}</p>
                                                    </div>
                                                </a>
                                            </div>
                                            @endif
                                        @endforeach

                                    </div>
                                    <!--end row-->
                                </div>
                            </li>
                            <li class="nav-item dropdown dropdown-small me-0">
                                <a class="nav-link dropdown-toggle dropdown-toggle-nocaret pe-0" href="#"
                                    data-bs-toggle="dropdown">
                                    <div class="user-setting d-flex align-items-center gap-1">
                                        <img src="{{ asset('admin/images/avtaar.png') }}" class="user-img"
                                            loading="lazy" alt="profile" width="32" height="32">
                                        <div class="user-name">{{ Auth::user()->name ?? '' }}</div>
                                    </div>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    {{-- <li>
                           <a class="dropdown-item" href="#">
                              <div class="d-flex align-items-center">
                                 <img src="{{ asset('admin/images/avtaar.png')}}" class="rounded-circle" loading="lazy" alt="profile" width="45" height="45">
                                 <div class="ms-2">
                                    <h6 class="mb-0 dropdown-user-name">{{Auth::user()->name ?? ''}}</h6>
                                 </div>
                              </div>
                           </a>
                        </li> --}}
                                    {{-- <li>
                           <hr class="dropdown-divider">
                        </li> --}}
                                    <li>
                                        <a class="dropdown-item" href="{{ url('signOut') }}">
                                            <div class="d-flex align-items-center">
                                                <div class="setting-icon"><i class="bi bi-lock-fill"></i></div>
                                                <div class="setting-text ms-2"><span>Logout</span></div>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </nav>
            </header>
            <!--end top header-->
            <!--start sidebar -->

            <aside class="sidebar-wrapper" data-simplebar="true">
                <div class="sidebar-header">
                    <div>
                        {{-- <img src="{{ asset('admin/images/main_logo_new.png') }}"
                            class="@if (isset($companyData->logo)) {{ 'logo-icons' }}@else{{ 'logo-icon' }} @endif"
                            alt="Favicon"> --}}
                        @if(isset($companyData['logo']))
                            <img src="{{ $companyData['logo']?getPermanentUrl($companyData['logo']): 'https://metaminthealth.s3.ap-south-1.amazonaws.com/metamintassets/images/meta_mint_white_logo.png'}}" class="@if (isset($companyData->logo)){{'logo-icons'}}@else{{'logo-icon'}}@endif" alt="Favicon" style="width:100%">
                        @endif
                    </div>
                    {{-- @if (!isset($companyData->logo))
                        <div>
                            <h4 class="logo-text">Meta Mint</h4>
                        </div>
                    @endif --}}
                    <div class="toggle-icon ms-auto"><i class="bi bi-chevron-double-left"></i></div>
                </div>
                <!--navigation-->

                <ul class="metismenu" id="menu">
                    <li>
                        <a href="{{ url('dashboard') }}">
                            <div class="parent-icon"><i class="bi bi-house-door"></i></div>
                            <div class="menu-title">Dashboard</div>
                        </a>
                    </li>
                    {{-- @dd($leftMenuModules); --}}
                    @foreach ($leftMenuModules as $key => $module)
                        @if(in_array($module['permission'], $authRolePermissions))
                            <li>
                                <a
                                    href="{{ isset($module['route']) && !empty($module['route']) ? url($module['route']) : '#' }}">
                                    <div class="parent-icon"><i
                                            class="bi bi-{{ !empty($module['icon']) ? $module['icon'] : 'people-fill' }}"></i>
                                    </div>
                                    <div class="menu-title">{!! !empty($module['menu_name']) ? $module['menu_name'] : 'people-fill' !!}</div>
                                </a>
                            </li>
                        @endif
                    @endforeach

                    {{--
            @if (in_array('COURSES', $modulePermissions) && in_array('courses-list', $authRolePermissions))
                <li>
                    <a href="{{ url('courses') }}">
                        <div class="parent-icon"><i class="bi bi-book"></i></div>
                        <div class="menu-title">{!! @$menuModules['COURSES']['menu_name'] ?? 'Academic Manager' !!}</div>
                    </a>
                </li>
            @endif

            @if (in_array('LIBRARY MANAGEMENT', $modulePermissions) && in_array('library-management-list', $authRolePermissions))
                <li>
                    <a href="{{ url('books') }}">
                        <div class="parent-icon"><i class="bi bi-book"></i></div>
                        <div class="menu-title">{!! @$menuModules['LIBRARY MANAGEMENT']['menu_name'] ?? 'Library Management' !!}</div>
                    </a>
                </li>
            @endif

            @if (in_array('STUDENTS', $modulePermissions) && in_array('students-list', $authRolePermissions))
                <li>
                    <a href="{{ url('students') }}">
                        <div class="parent-icon"><i class="bi bi-people-fill"></i></div>
                        <div class="menu-title">{!! @$menuModules['STUDENTS']['menu_name'] ?? 'Students Manager' !!}</div>
                    </a>
                </li>
            @endif

            @if (in_array('FACULTY', $modulePermissions) && in_array('faculty-list', $authRolePermissions))
            <li>
               <a href="{{ url('faculty') }}">
                  <div class="parent-icon"><i class="bi bi-people-fill"></i></div>
                  <div class="menu-title">{!! @$menuModules['FACULTY']['menu_name'] ?? 'Faculty' !!}</div>
               </a>
            </li>
            @endif

            @if (in_array('ACCOUNTING', $modulePermissions) && in_array('accounting-list', $authRolePermissions))
            <li>
               <a href="{{ route ('receipt-voucher.index') }}">
                  <div class="parent-icon"><i class="bi bi-book"></i></div>
                  <div class="menu-title">{!! @$menuModules['ACCOUNTING']['menu_name'] ?? 'Financial Accounting' !!}</div>
               </a>
            </li>
            @endif

            @if (in_array('ACCOUNTS', $modulePermissions) && in_array('accounts-list', $authRolePermissions))
            <li>
               <a href="{{ route('accounts.index') }}">
                  <div class="parent-icon"><i class="bi bi-{!! isset($module_icons) && isset($module_icons[38]) ? $module_icons[38]['icon'] : 'list' !!}"></i></div>
                  <div class="menu-title">{!! @$menuModules['ACCOUNTS']['menu_name'] ?? 'Accounts' !!}</div>
               </a>
            </li>
            @endif
            @if (in_array('ENQUIRY', $modulePermissions) && in_array('enquiry-list', $authRolePermissions))
            <li>
               <a href="{{ route('enquiries.index') }}">
                  <div class="parent-icon"><i class="bi bi-{!! isset($module_icons) && isset($module_icons[22]) ? $module_icons[22]['icon'] : 'list' !!}"></i>
                  </div>
                  <div class="menu-title">{!! @$menuModules['ENQUIRY']['menu_name'] ?? 'Enquiry' !!}</div>
               </a>
            </li>
            @endif

            <!-- Tax Master -->
            @if (in_array('TAX_MASTER', $modulePermissions) && in_array('tax-master-list', $authRolePermissions))
            <li>
                <a href="{{ route('tax-masters.index')}}">
                   <div class="parent-icon"><i class="bi bi-journal-bookmark"></i>
                   </div>
                  <div class="menu-title">{!! @$menuModules['TAX_MASTER']['menu_name'] ?? 'Tax Master' !!}</div>
                </a>
             </li>
             @endif

            <!-- End Of Tax Master -->

            @if (in_array('DOCUMENT_MANAGEMENT', $modulePermissions) && in_array('document-management-list', $authRolePermissions))
            <li>
                <a href="{{ url('documents-management') }}">
                    <div class="parent-icon"><i class="fadeIn animated bx bx-test-tube"></i>
                    </div>
                  <div class="menu-title">{!! @$menuModules['DOCUMENT_MANAGEMENT']['menu_name'] ?? 'Document Management' !!}</div>
                </a>
             </li>
            @endif

           <!-- Products -->
            @if (in_array('PRODUCT', $modulePermissions) && in_array('product-list', $authRolePermissions))
               <li>
                  <a href="{{ route('products.index') }}">
                     <div class="parent-icon"><i class="bi bi-{!! isset($module_icons) && isset($module_icons[21]) ? $module_icons[21]['icon'] : 'list' !!}"></i>
                     </div>
                  <div class="menu-title">{!! @$menuModules['PRODUCT']['menu_name'] ?? 'Products' !!}</div>
                  </a>
               </li>
            @endif

           <!-- End Of Products -->

            <!-- Test Manager -->
            @if (in_array('TEST_MANAGER', $modulePermissions) && in_array('test-package-list', $authRolePermissions))
             <li>
                <a href="{{ url('test-packages') }}">
                    <div class="parent-icon"><i class="fadeIn animated bx bx-test-tube"></i>
                    </div>
                    <div class="menu-title">{!! @$menuModules['TEST_MANAGER']['menu_name'] ?? 'Test Manager' !!}</div>
                </a>
             </li>
             @endif

            @if (in_array('MEDICAL_SETTINGS', $modulePermissions) && in_array('medical-settings-list', $authRolePermissions))
             <li>
                <a href="{{ url('symptoms') }}">
                    <div class="parent-icon"><i class="bi bi-heart-pulse-fill"></i>
                    </div>
                    <div class="menu-title">{!! @$menuModules['MEDICAL_SETTINGS']['menu_name'] ?? 'Medical Settings' !!}</div>
                </a>
             </li>
            @endif

            <!-- End Of Test Manager -->

            <!-- Start Of Company -->
            @if (in_array('COMPANY', $modulePermissions) && in_array('company-list', $authRolePermissions))
            <li>
               <a href="{{ url ('companies')}}">
                  <div class="parent-icon"><i class="bi bi-{!! isset($module_icons) && isset($module_icons[9]) ? $module_icons[9]['icon'] : 'list' !!}"></i>
                  </div>
                    <div class="menu-title">{!! @$menuModules['COMPANY']['menu_name'] ?? 'Company' !!}</div>
               </a>
            </li>
            @endif
            <!-- End Of Company -->

            <!-- Start Of OPD Appointment -->
            @if (in_array('OPD_BOOKING', $modulePermissions) && in_array('opd-booking-list', $authRolePermissions))
            <li>
               <a href="{{ route('opd-bookings.index')}}">
                  <div class="parent-icon"><i class="bi bi-calendar2-check-fill"></i></div>
                  <div class="menu-title">{!! @$menuModules['OPD_BOOKING']['menu_name'] ?? 'OPD Out Patient' !!}</div>
               </a>
           </li>
           @endif
            <!-- End Of OPD Appointment -->

           <!-- Start Of IPD In Patient -->
            @if (in_array('IPD_ADMISSION', $modulePermissions) && in_array('ipd-admission-list', $authRolePermissions))
            <li>
               <a href="{{ route('ipd-admissions.index')}}">
                  <div class="parent-icon">
                     <i class="bi bi-hospital"></i>
                  </div>
                  <div class="menu-title">{!! @$menuModules['IPD_ADMISSION']['menu_name'] ?? 'IPD-In Patient' !!}</div>
               </a>
            </li>
            @endif
            <!-- End Of IPD In Patient -->

            @if (in_array('PATHOLOGY_LAB_BILLING', $modulePermissions) && in_array('pathology-lab-billing-list', $authRolePermissions))
            <li>
               <a href="{{ route('lab-billings.index')}}">
                  <div class="parent-icon"><i class="bi bi-calendar2-check-fill"></i></div>
                  <div class="menu-title">{!! @$menuModules['PATHOLOGY_LAB_BILLING']['menu_name'] ?? 'Pathology' !!}</div>
               </a>
            </li>
            @endif

            @if (in_array('SALES', $modulePermissions) && in_array('sales-list', $authRolePermissions))
            <li>
               <a href="{{ route('sale.index')}}">
                  <div class="parent-icon"><i class="bi bi-shop"></i></i></div>
                  <div class="menu-title">{!! @$menuModules['SALES']['menu_name'] ?? 'Sale' !!}</div>
               </a>
            </li>
           @endif

            <!-- Start of Incentive Master -->
            @if (in_array('INCENTIVE_SLAB', $modulePermissions) && in_array('incentive-slab-list', $authRolePermissions))
            <li>
               <a  href="{{ url('incentive-slabs') }}">
                  <div class="parent-icon">
                     <i class="bi bi-arrow-left-right"></i>
                  </div>
                  <div class="menu-title">{!! @$menuModules['INCENTIVE_SLAB']['menu_name'] ?? 'Incentive Master' !!}</div>
               </a>
            </li>
            @endif
            <!-- End of Incentive Master -->

            <!-- Start of Product Features -->
            @if (in_array('LICENSE_MANGEMENT', $modulePermissions) && in_array('license-management-list', $authRolePermissions))
            <li>
               <a  href="{{ route('license.dashboard') }}">
                  <div class="parent-icon">
                     <i class="bi bi-file-earmark-medical"></i>
                  </div>
                  <div class="menu-title">{!! @$menuModules['LICENSE_MANGEMENT']['menu_name'] ?? 'License Management' !!}</div>
               </a>
            </li>
            @endif
            <!-- End of Product Features -->

            @if (in_array('SETTINGS', $modulePermissions) && in_array('settings-list', $authRolePermissions))
            <li>
               <a  href="{{ url('master-settings') }}">
                  <div class="parent-icon"><i class="bi bi-{!! isset($module_icons) && isset($module_icons[6]) ? $module_icons[6]['icon'] : 'list' !!}"></i>
                  </div>
                  <div class="menu-title">{!! @$menuModules['SETTINGS']['menu_name'] ?? 'Settings' !!}</div>
               </a>
            </li>
            @endif

            @if (in_array('WEBSITE_MANAGEMENR', $modulePermissions) && in_array('website-management-list', $authRolePermissions))
            <li>
               <a  href="{{ url('sliders') }}">
                  <div class="parent-icon"><i class="bi bi-{!! isset($module_icons) && isset($module_icons[173]) ? $module_icons[173]['icon'] : 'list' !!}"></i>
                  </div>
                  <div class="menu-title">{!! @$menuModules['WEBSITE_MANAGEMENR']['menu_name'] ?? 'Website Management' !!}</div>
               </a>
            </li>
            @endif

            @if (in_array('LIBRARY MANAGEMENT', $modulePermissions) && in_array('library-settings-list', $authRolePermissions))
            <li>
               <a href="{{url('library/genres')}}">
                  <div class="parent-icon"><i class="bi bi-{!! isset($module_icons) && isset($module_icons[149]) ? $module_icons[149]['icon'] : 'list' !!}"></i>
                  </div>
                  <div class="menu-title">{!! @$menuModules['LIBRARY MANAGEMENT']['menu_name'] ?? 'Library Settings' !!}</div>
               </a>
            </li>
            @endif

            <!-- Start of Marketing -->
            @if (in_array('MARKETING', $modulePermissions) && in_array('marketing-list', $authRolePermissions))
            <li>
               <a  href="{{ url('marketing') }}">
                  <div class="parent-icon">
                     <i class="bi bi-graph-up-arrow"></i>
                  </div>
                  <div class="menu-title">{!! @$menuModules['MARKETING']['menu_name'] ?? 'Marketing' !!}</div>
               </a>
            </li>
            @endif

            <!-- End of Marketing -->
            <!-- Start of WorkSpace -->
            @if (in_array('Workspace', $modulePermissions) && in_array('workspace-list', $authRolePermissions))
            <li>
               <a href="{{url('projects')}}">
                  <div class="parent-icon"><i class="bi bi-{!! isset($module_icons) && isset($module_icons[197]) ? $module_icons[197]['icon'] : 'list' !!}"></i>
                  </div>
                  <div class="menu-title">{!! @$menuModules['Workspace']['menu_name'] ?? 'WorkSpace' !!}</div>
               </a>
            </li>
            @endif
            <!-- End of WorkSpace -->

            <!-- Start of Human Resource -->
            @if (in_array('HUMAN_RESOURCE', $modulePermissions) && in_array('human-resource-list', $authRolePermissions))
            <li>
               <a href="{{url('employee')}}">
                  <div class="parent-icon"><i class="bi bi-{!! isset($module_icons) && isset($module_icons[211]) ? $module_icons[211]['icon'] : 'list' !!}"></i>
                  </div>
                  <div class="menu-title">{!! @$menuModules['HUMAN_RESOURCE']['menu_name'] ?? 'Human Resource' !!}</div>
               </a>
            </li>
            @endif
            <!-- End of WorkSpace -->

            @if (in_array('API_MANAGEMENT', $modulePermissions) && in_array('api-management-list', $authRolePermissions))
            <li>
               <a href="{{url('api-management')}}">
                  <div class="parent-icon"><i class="bi bi-{!! isset($module_icons) && isset($module_icons[149]) ? $module_icons[149]['icon'] : 'list' !!}"></i>
                  </div>
                  <div class="menu-title">{!! @$menuModules['API_MANAGEMENT']['menu_name'] ?? 'API Management' !!}</div>
               </a>
            </li>
            @endif
            --}}

            <!-- <li>
               <a href="{{route('inventory-stock.index')}}">
                  <div class="parent-icon"><i class="bi bi-{!! isset($module_icons) && isset($module_icons[149]) ? $module_icons[149]['icon'] : 'list' !!}"></i>
                  </div>
                  <div class="menu-title">{!! 'Inventory & Stocks' !!}</div>
               </a>
            </li> -->

                </ul>
                <!--end navigation-->
            </aside>
            <!--end sidebar -->

            <!--start content-->
            <main class="page-content" style="margin-top:10px">
                @include('flash-message')
                @yield('pages')
            </main>
            <!--end page main-->

            <!--start overlay-->
            <div class="overlay nav-toggle-icon"></div>
            <!--end overlay-->

            <!--Start Back To Top Button-->
            <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
            <!--End Back To Top Button-->

            <!-- Modal -->
            <div class="modal fade" id="commonModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true"
                data-bs-backdrop="static" 
                data-bs-keyboard="false" >
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="commonModalLabel"></h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                        </div>
                        <div class="modal-footer text-center" style="justify-content: center;">
                            <button type="button" class="btn btn-primary save_button w-70"><i
                                    class="bx bx-save"></i> <span class="save_button_span"></span></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <!--plugins-->
        <script type="text/javascript" src="{{ asset('admin/js/jquery.min.js') }}"></script>


        
        <!-- Bootstrap bundle JS -->
        <script type="text/javascript" src="{{ asset('admin/js/bootstrap.bundle.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/js/moment.js') }}"></script>

        
        <script type="text/javascript" src="{{ asset('admin/plugins/simplebar/js/simplebar.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/plugins/metismenu/js/metisMenu.min.js') }}"></script>
        <!-- <script type="text/javascript" src="{{ asset('admin/plugins/perfect-scrollbar/js/perfect-scrollbar.js') }}"></script> -->
        <script type="text/javascript" src="{{ asset('admin/plugins/select2/js/select2.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/plugins/datetimepicker/js/picker.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/plugins/datetimepicker/js/picker.time.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/plugins/easyPieChart/jquery.easypiechart.js') }}"></script>
        <!-- <script type="text/javascript" src="{{ asset('admin/plugins/apexcharts-bundle/js/apexcharts.min.js') }}"></script> -->
        <script type="text/javascript" src="{{ asset('admin/plugins/peity/jquery.peity.min.js') }}"></script>
        <!--app-->
        <script type="text/javascript" src="{{ asset('admin/js/pace.min.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/js/app.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/js/script.js') }}"></script>
        <script type="text/javascript" src="{{ asset('admin/js/script.js') }}"></script>

        <!-- custom js -->
        <script type="text/javascript" src="{{ asset('admin/js/custom.js') }}"></script>

        <script src="{{ asset('admin/plugins/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('admin/plugins/datatables/dataTables.bootstrap4.min.js') }}"></script>

        <script type="text/javascript">
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        </script>
        <script type="text/javascript">
            $(document).ready(function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                    }
                });
                //Delay the action by 10000ms
                setTimeout(function() {
                    // Display the div containing the class "bottomdiv"
                    $(".fixed_contact_btn").show();
                    // $.switcher();
                }, 2000);
            });
        </script>
        <script type="text/javascript" src="{{ asset('admin/js/jquery.switcher.js') }}"></script>
        <script>
            $.switcher();
        </script>
        <script type="text/javascript">
            function toggle_div_fun(id) {
                var divelement = document.getElementById(id);
                if (divelement.style.display == 'none')
                    divelement.style.display = 'block';
                else
                    divelement.style.display = 'none';
            }
        </script>

        <script type="text/javascript" src="{{ asset('admin/js/jquery-ui.js') }}"></script>

        @yield('js')

        <script type="text/javascript">
            $(document).on('click', '.show-help-support', function(event) {
                event.preventDefault();
                $('#commonModalLabel').text('Module Information:');
                $('.save_button_span').text('Close:');
                var module_id = $(this).data('id');
                var url = `{!! route('modules.help-text', ':id') !!}`.replace(':id', module_id);

                $.ajax({
                    url: url,
                    success: function(data) {
                        $('#commonModal').find('.modal-body').html('');
                        $('#commonModal').find('.modal-body').html(data.data);
                    }
                })
            });
        </script>
        <script type="text/javascript">
            $(document).on('input', "#priority", function() {
                //const onlyNumbers = $(this).val().replace(/[^0-9]/g, '');
                $("#priority").val(onlyNumbers);
            });
            $(document).on('input', "[name='priority']", function() {
                //const onlyNumbers = $(this).val().replace(/[^0-9]/g, '');
                $("[name='priority']").val(onlyNumbers);
            });
            $('#commonModal').on('shown.bs.modal', function() {
                $(this).find('.modal-body').find(':input:visible:not([disabled]):first').focus();
            });
            $(document).on('change', "#user_financial_year", function() {
                $.ajax({
                        url: '{!! route('submit-user-financial-year') !!}',
                        data: {
                            _token: '{!! csrf_token() !!}',
                            financialyear: $(this).val()
                        },
                        type: 'POST',
                        success: function(response) {
                            if (response.success === true) {
                                toastr.success(response.message, 'Success.');
                            } else {
                                toastr.error(response.message, 'Error!');
                            }
                        }
                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        console.log('AJAX request failed:', textStatus, errorThrown);
                        toastr.error('An error occurred during the request.', 'Error!');

                        // hide modal
                        $('#commonModal').modal('hide');
                        $('#commonModal').find('.modal-body').html('');
                    });
            });


            $(document).on('click', '#create-documents-management', function() {
                $('#commonModalLabel').text('Add New Document');
                $('.save_button_span').text('Save Document');

                var account_id = $(this).data('account_id') != undefined ? $(this).data('account_id') : '';
                var voucher_type = $(this).data('voucher_type') != undefined ? $(this).data('voucher_type') : '';

                $.ajax({
                    url: "{!! route('documents-management.create') !!}?account=" + account_id + '&voucher=' + voucher_type,
                    success: function(data) {
                        $('#commonModal').find('.modal-body').html('');
                        $('#commonModal').find('.modal-body').html(data);

                        $('.single-select').select2({
                            dropdownParent: $('.modal'),
                            theme: 'bootstrap4',
                            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass(
                                'w-100') ? '100%' : 'style',
                            placeholder: $(this).data('placeholder'),
                            allowClear: Boolean($(this).data('allow-clear')),
                        });
                    }
                })
            });

            $(document).on('click', '.save_button', function(event) {
                event.preventDefault();

                if ($('#commonModal').find('form').hasClass('documents_management')) {
                    $('.error_priority').hide();
                    $('.error_attachment').hide();
                    $('.error_document_note').hide();

                    var error = 0;

                    if ($('#commonModal').find('form').find('input[name="attachment"]').val() == '' && !$(
                            '#commonModal').find('form').hasClass('edit')) {
                        $('.error_attachment').show();
                        error = 1;
                    }

                    if ($('#commonModal').find('form').find('input[name="priority"]').val().trim() == '') {
                        $('.error_priority').show();
                        error = 1;
                    }

                    if ($('#commonModal').find('form').find('[name="voucher_type"]').val() == '') {
                        $('.error_voucher_type').show();
                        error = 1;
                    }

                    if (error == 0) {
                        let formdata = new FormData($('#commonModal').find('form')[0]);

                        $.ajax({
                                url: $('#commonModal').find('form').attr('action'),
                                data: formdata,
                                processData: false,
                                contentType: false,
                                type: 'POST',
                                success: function(response) {
                                    if (response.success === true) {
                                        toastr.success(response.message, 'Success.');

                                        setTimeout(function() {
                                            location.reload();
                                        }, 2000);

                                        // hide modal
                                        $('#commonModal').modal('hide');
                                        $('#commonModal').find('.modal-body').html('');
                                    } else {
                                        toastr.error(response.message, 'Error!');
                                    }
                                }
                            })
                            .fail(function(jqXHR, textStatus, errorThrown) {
                                console.log('AJAX request failed:', textStatus, errorThrown);
                                toastr.error('An error occurred during the request.', 'Error!');

                                // hide modal
                                $('#commonModal').modal('hide');
                                $('#commonModal').find('.modal-body').html('');
                            });
                    }
                    error = 1;
                }
            })
        </script>
        <!-- Include this script at the end of your HTML file, just before the closing </body> tag -->
        <script>
            // $(document).on('keyup','.searchbar', function () {
            //     $(this).val();
            //     var input, filter, ul, li, a, i, txtValue;
            //     filter = $(this).val();
            //     ul = $("#metismenu");
            //     li = ul.find('li');

            //     // Loop through all list items, and hide those who don't match the search query
            //     for (i = 0; i < li.length; i++) {
            //         a = li[i].find("a");
            //         a = a.find(".menu-title");
            //         txtValue = a.textContent || a.innerText;
            //         if (txtValue.toUpperCase().indexOf(filter) > -1) {
            //         li[i].style.display = "";
            //         } else {
            //         li[i].style.display = "none";
            //         }
            //     }
            // });

            // $(document).on('keyup', '.searchbar', function () {
            //     var filter = $(this).val().toUpperCase();
            //     $("#metismenu").find('li').each(function () {
            //         var a = $(this).find("a .menu-title");
            //         var txtValue = a.text() || a.text();
            //         if (txtValue.toUpperCase().indexOf(filter) > -1) {
            //             $(this).show();
            //         } else {
            //             $(this).hide();
            //         }
            //     });
            // });

            // $(document).on('keyup', '.searchbar', function () {
            //     var filter = $(this).val().trim().toUpperCase(); // Get the value of the search bar and convert it to uppercase
            //     var ul = $("#menu");
            //     var li = ul.find('li');

            //     li.each(function () {
            //         var a = $(this).find("a");
            //         var txtValue = a.find(".menu-title").text().trim().toUpperCase(); // Get the text value of the menu item and convert it to uppercase

            //         // Show all list items if the filter is empty
            //         if (filter === "") {
            //             $(this).show();
            //             return;
            //         }

            //         if (txtValue.includes(filter)) { // Check if the menu item text contains the filter text
            //             $(this).show(); // Show the menu item if it matches the filter
            //         } else {
            //             $(this).hide(); // Hide the menu item if it doesn't match the filter
            //         }
            //     });
            // });
            $(document).on('keyup', '.sideMenusearchbar', function() {

                var filter = $('.sideMenusearchbar').val().trim().toUpperCase();

                var ul = $("#menu");
                var li = ul.find('li');

                li.each(function() {
                    var a = $(this).find("a");
                    var txtValue = a.find(".menu-title").text().trim().toUpperCase();

                    // Show all list items if the filter is empty
                    if (filter === "") {
                        $(this).show();
                        return;
                    }

                    if (txtValue.includes(filter)) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                });
            });
        </script>

    </body>

</html>
{{-- menu-title
metismenu --}}
