@extends('layouts.app') 
@section('title','Letter Heads') 
@section('pages') 
<style type="text/css">
    .clear {
        clear: both;
        margin-top: 20px;
    }

    .autocomplete {
        position: relative;
    }

    .autocomplete .searchResult {
        list-style: none;
        padding: 0px;
        width: 78%;
        position: absolute;
        margin: 0;
        margin-top: 40px;
        background: white;
        z-index: 15005;
    }

    .autocomplete .searchResult li {
        background: #F2F3F4;
        padding: 10px;
        margin-bottom: 1px;
        white-space: break-spaces;
    }

    .autocomplete .searchResult li:nth-child(even) {
        background: #E5E7E9;
        color: black;
    }

    .autocomplete .searchResult li:hover {
        cursor: pointer;
        background: #CACFD2;
    }

    .add_btn {
        height: 40px;
        width: 40px;
        font-size: 16px;
        border-radius: 0 3.5px 3.5px 0;
        padding: 0;
    }

    .select2-selection {
        height: 40px !important;
    }

    .flatpickr-calendar {
        width: 308px !important;
        font-size: 12px !important;
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/css/intlTelInput.css">
<!-- Include Flatpickr CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link rel="stylesheet" type="text/css" href="{{ asset('admin/plugins/datepicker/less/datepicker.less') }}">
<link href="{{ asset('admin/plugins/datepicker/css/datepicker.css') }}" rel="stylesheet" />
<!-- <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/css/bootstrap-datetimepicker.css" rel="stylesheet"> -->
<!-- <link rel="stylesheet" type="text/css" href="{{ asset('admin\plugins\datetimepickr_new\jquery.datetimepicker.min.css') }}"> -->
<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i> Letter Heads</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item active" aria-current="page">Edit Letter Head</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="{{route('letter-heads.index')}}" class="btn btn-info"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->
<div class="row auto">
    <div class="col-xl-12 mx-auto">
        <form class="row auto-width mt-0 edit_letter_head" id="edit_letter_head_form" action="{{ route('letter-heads-update' , $letter_heads->id)}}" method="post" enctype='multipart/form-data' style="padding: 0px 0px 0px 9px;"> @csrf <div class="col-md-12" style="padding: 0 0 0 9px;">
                <div class="card">
                    <div class="card-body g-3 row">
                        <h5 class="mb-0">Letter Head Settings</h5>
                        <hr class="mb-2">
                        {{-- Title--}}
                        <div class="col-md-2 col-sm-4 col-12">
                            <label for="title" class="form-label">Letter Head Title</label>
                            <input type="text" class="form-control" id="title" name="title" aria-describedby="inputGroupPrepend" placeholder="Letter Head Title" value="{{ $letter_heads->title ?? '' }}">
                        </div>
                        {{-- Voucher Type Code
                        <div class="col-md-2">
                            <label for="voucher_type_code" class="form-label">Voucher Type Code <span class="text-danger"><b>*</b></span></label>
                            <select class="form-control" name="voucher_type_code" id="voucher_type_code">
                                <option value="">Select Voucher Type Code</option>
                                @foreach($voucher_types as $voucher_type) 
                                    <option value="{{ $voucher_type->id }}" {{ $voucher_type->id == $letter_heads->voucher_type_code ? 'selected' : '' }}>
                                        {{ $voucher_type->name }}
                                    </option> 
                                @endforeach
                            </select>
                        </div> --}}

                        {{-- Content Alignment --}}
                        <div class="col-md-2">
                            <div>
                                <label for="content_alignment" class="form-label">Content Alignment</label>
                                <select class="form-control" name="content_alignment" id="content_alignment">
                                    <option value=''>Select Alignment</option>
                                    <option value="left" {{ $letter_heads->content_alignment == 'left' ? 'selected' : '' }}>Left</option>
                                    <option value="right" {{ $letter_heads->content_alignment == 'right' ? 'selected' : '' }}>Right</option>
                                    <option value="center" {{ $letter_heads->content_alignment == 'center' ? 'selected' : '' }}>Center</option>
                                </select>
                            </div>
                        </div>

                        {{-- Logo Position --}}
                        <div class="col-md-2">
                            <div>
                                <label for="logo_position" class="form-label">Logo Position</label>
                                <select class="form-control" name="logo_position" id="logo_position">
                                    <option value="">Select Logo Position</option>
                                    <option value="left" {{ $letter_heads->logo_position == 'left' ? 'selected' : '' }}>Left</option>
                                    <option value="right" {{ $letter_heads->logo_position == 'right' ? 'selected' : '' }}>Right</option>
                                    <option value="center" {{ $letter_heads->logo_position == 'center' ? 'selected' : '' }}>Center</option>
                                </select>
                            </div>
                        </div>

                        {{-- Companies --}}
                        <div class="col-md-2">
                            <label for="company_id" class="form-label">Companies <span class="text-danger"><b>*</b></span></label>
                            <select class="form-control" name="company_id" id="company_id">
                                <option value="">Select Companies</option> 
                                @foreach($companies as $company) 
                                    <option value="{{ $company->id }}" {{ $company->id == $letter_heads->company_id ? 'selected' : '' }}>
                                        {{ $company->name }}
                                    </option> 
                                @endforeach
                            </select>
                        </div>

                        {{-- Custom Logo url Status--}}
                        <div class="col-md-2">
                            <div class="form-check form-check-inline mt-2 text-center">
                                <label for="customLogoStatus" class="form-label mb-2">Custom Logo URL Status</label>
                                <br>
                                <input class="form-check-input customLogoStatus" type="checkbox" id="customLogoStatus"
                                    name="custom_logo_status" {{ $letter_heads->custom_logo_status == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        {{-- Custom Logo url--}}
                        <div class="col-md-2 col-12">
                            <label for="custom_logo_url" class="form-label">Custom Logo Url </label>
                            <input type="file" class="form-control" id="custom_logo_url" name="custom_logo_url">
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body g-3 row">
                        <h5 class="mb-0">Title Style Settings</h5>
                        <hr class="mb-2">
                        {{-- Font Color--}}
                        <div class="col-md-2 col-sm-4 col-12">
                            <label for="title_font_color" class="form-label">Font Color</label>
                            <input type="color" class="form-control title_font_color" id="title_font_color" name="title_font_color" aria-describedby="inputGroupPrepend" value="{{ $letter_heads->title_style['title_font_color'] ?? '#000000' }}">
                        </div>

                        {{-- BG Color --}}
                        <div class="col-md-2 col-sm-4 col-12">
                            <label for="title_background_color" class="form-label">BG Color</label>
                            <input type="color" class="form-control title_background_color" id="title_background_color" name="title_background_color" aria-describedby="inputGroupPrepend" value="{{ $letter_heads->title_style['title_background_color'] ?? '#FFFFFF' }}" placeholder="Background Color">
                        </div>

                        {{-- Text Decoration --}}
                        <div class="col-md-2 col-12">
                            <label for="title_text_decoration" class="form-label">Text Decoration</label>
                            <select id="title_text_decoration" name="title_text_decoration" class="form-control form-select">
                                <option value="none" {{ $letter_heads->title_style['title_text_decoration'] == 'none' ? 'selected' : '' }}>None</option>
                                <option value="underline" {{ $letter_heads->title_style['title_text_decoration'] == 'underline' ? 'selected' : '' }}>Underline</option>
                                <option value="overline" {{ $letter_heads->title_style['title_text_decoration'] == 'overline' ? 'selected' : '' }}>Overline</option>
                                <option value="line-through" {{ $letter_heads->title_style['title_text_decoration'] == 'line-through' ? 'selected' : '' }}>Line Through</option>
                                <option value="blink" {{ $letter_heads->title_style['title_text_decoration'] == 'blink' ? 'selected' : '' }}>Blink</option>
                            </select>
                        </div>

                        {{-- Font Family --}}
                        <div class="col-md-2 col-12">
                            <label for="title_font_family" class="form-label">Font Family</label>
                            <select id="title_font_family" name="title_font_family" class="form-control form-select">
                                @foreach ($fonts as $font)
                                    <option value="{{ $font->id }}" {{ $letter_heads->title_style['title_font_family'] == $font->id ? 'selected' : '' }}>{{ $font->font_name }}</option>
                                @endforeach
                            </select>
                        </div>

                        {{-- Font Size --}}
                        <div class="col-md-2 col-12">
                            <label for="title_font_size" class="form-label">Font Size</label>
                            <select id="title_font_size" name="title_font_size" class="form-control form-select">
                                @foreach ([10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20] as $size)
                                    <option value="{{ $size }}" {{ $letter_heads->title_style['title_font_size'] == $size ? 'selected' : '' }}>{{ $size }}px</option>
                                @endforeach
                            </select>
                        </div>

                        {{-- Font Style --}}
                        <div class="col-md-2 col-12">
                            <label for="title_font_style" class="form-label">Font Style</label>
                            <select id="title_font_style" name="title_font_style" class="form-control form-select">
                                <option value="normal" {{ $letter_heads->title_style['title_font_style'] == 'normal' ? 'selected' : '' }}>Normal</option>
                                <option value="italic" {{ $letter_heads->title_style['title_font_style'] == 'italic' ? 'selected' : '' }}>Italic</option>
                            </select>
                        </div>

                        {{-- Font Weight --}}
                        <div class="col-md-2 col-12">
                            <label for="title_font_weight" class="form-label">Font Weight</label>
                            <select id="title_font_weight" name="title_font_weight" class="form-control form-select">
                                <option value="normal" {{ $letter_heads->title_style['title_font_weight'] == 'normal' ? 'selected' : '' }}>Normal</option>
                                <option value="bold" {{ $letter_heads->title_style['title_font_weight'] == 'bold' ? 'selected' : '' }}>Bold</option>
                            </select>
                        </div>

                        {{-- Padding --}}
                        <div class="col-md-2 col-12">
                            <label for="title_font_padding" class="form-label">Padding (px)</label>
                            <input type="number" class="form-control" id="title_font_padding" name="title_font_padding" aria-describedby="inputGroupPrepend" value="{{ $letter_heads->title_style['title_font_padding'] ?? '' }}">
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body g-3 row">
                        <h5 class="mb-0">Sub Title Style Settings</h5>
                        <hr class="mb-2">
                        {{-- Font Color --}}
                        <div class="col-md-2 col-sm-4 col-12">
                            <label for="sub_title_font_color" class="form-label">Font Color</label>
                            <input type="color" class="form-control sub_title_font_color" id="sub_title_font_color" name="sub_title_font_color" aria-describedby="inputGroupPrepend" value="{{ $letter_heads->sub_title_style['sub_title_font_color'] ?? '#000000' }}">
                        </div>

                        {{-- BG Color --}}
                        <div class="col-md-2 col-sm-4 col-12">
                            <label for="sub_title_background_color" class="form-label">BG Color</label>
                            <input type="color" class="form-control sub_title_background_color" id="sub_title_background_color" name="sub_title_background_color" aria-describedby="inputGroupPrepend" value="{{ $letter_heads->sub_title_style['sub_title_background_color'] ?? '#FFFFFF' }}">
                        </div>

                        {{-- Text Decoration --}}
                        <div class="col-md-2 col-12">
                            <label for="sub_title_text_decoration" class="form-label">Text Decoration</label>
                            <select id="sub_title_text_decoration" name="sub_title_text_decoration" class="form-control form-select">
                                <option value="none" {{ $letter_heads->sub_title_style['sub_title_text_decoration'] == 'none' ? 'selected' : '' }}>None</option>
                                <option value="underline" {{ $letter_heads->sub_title_style['sub_title_text_decoration'] == 'underline' ? 'selected' : '' }}>Underline</option>
                                <option value="overline" {{ $letter_heads->sub_title_style['sub_title_text_decoration'] == 'overline' ? 'selected' : '' }}>Overline</option>
                                <option value="line-through" {{ $letter_heads->sub_title_style['sub_title_text_decoration'] == 'line-through' ? 'selected' : '' }}>Line Through</option>
                                <option value="blink" {{ $letter_heads->sub_title_style['sub_title_text_decoration'] == 'blink' ? 'selected' : '' }}>Blink</option>
                            </select>
                        </div>

                        {{-- Font Family --}}
                        <div class="col-md-2 col-12">
                            <label for="sub_title_font_family" class="form-label">Font Family</label>
                            <select id="sub_title_font_family" name="sub_title_font_family" class="form-control form-select">
                                @foreach ($fonts as $font)
                                    <option value="{{ $font->id }}" {{ $letter_heads->sub_title_style['sub_title_font_family'] == $font->id ? 'selected' : '' }}>{{ $font->font_name }}</option>
                                @endforeach
                            </select>
                        </div>

                        {{-- Font Size --}}
                        <div class="col-md-2 col-12">
                            <label for="sub_title_font_size" class="form-label">Font Size (px)</label>
                            <select id="sub_title_font_size" name="sub_title_font_size" class="form-control form-select">
                                @foreach ([10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20] as $size)
                                    <option value="{{ $size }}" {{ $letter_heads->sub_title_style['sub_title_font_size'] == $size ? 'selected' : '' }}>{{ $size }}px</option>
                                @endforeach
                            </select>
                        </div>

                        {{-- Font Style --}}
                        <div class="col-md-2 col-12">
                            <label for="sub_title_font_style" class="form-label">Font Style</label>
                            <select id="sub_title_font_style" name="sub_title_font_style" class="form-control form-select">
                                <option value="normal" {{ $letter_heads->sub_title_style['sub_title_font_style'] == 'normal' ? 'selected' : '' }}>Normal</option>
                                <option value="italic" {{ $letter_heads->sub_title_style['sub_title_font_style'] == 'italic' ? 'selected' : '' }}>Italic</option>
                            </select>
                        </div>

                        {{-- Font Weight --}}
                        <div class="col-md-2 col-12">
                            <label for="sub_title_font_weight" class="form-label">Font Weight</label>
                            <select id="sub_title_font_weight" name="sub_title_font_weight" class="form-control form-select">
                                <option value="normal" {{ $letter_heads->sub_title_style['sub_title_font_weight'] == 'normal' ? 'selected' : '' }}>Normal</option>
                                <option value="bold" {{ $letter_heads->sub_title_style['sub_title_font_weight'] == 'bold' ? 'selected' : '' }}>Bold</option>
                            </select>
                        </div>

                        {{-- Padding --}}
                        <div class="col-md-2 col-12">
                            <label for="sub_title_font_padding" class="form-label">Padding (px)</label>
                            <input type="number" class="form-control" id="sub_title_font_padding" name="sub_title_font_padding" aria-describedby="inputGroupPrepend" value="{{ $letter_heads->sub_title_style['sub_title_font_padding'] ?? '' }}">
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body g-3 row">
                        <h5 class="mb-0">Full Width Letter Head Settings</h5>
                        <hr class="mb-2">
                        {{-- Height --}}
                        <div class="col-md-2 col-12">
                            <label for="image_height" class="form-label">Height (px)</label>
                            <input type="number" class="form-control name" id="image_height" name="image_height" aria-describedby="inputGroupPrepend" value="{{ $letter_heads->image_style['image_height'] ?? '' }}">
                        </div>

                        {{-- Width --}}
                        <div class="col-md-2 col-12">
                            <label for="image_width" class="form-label">Width (px)</label>
                            <input type="number" class="form-control name" id="image_width" name="image_width" aria-describedby="inputGroupPrepend" value="{{ $letter_heads->image_style['image_width'] ?? '' }}">
                        </div>

                        {{-- Margin --}}
                        <div class="col-md-2 col-12">
                            <label for="image_margin" class="form-label">Margin (px)</label>
                            <input type="number" class="form-control name" id="image_margin" name="image_margin" aria-describedby="inputGroupPrepend" value="{{ $letter_heads->image_style['image_margin'] ?? '' }}">
                        </div>

                        {{-- Padding --}}
                        <div class="col-md-2 col-12">
                            <label for="image_padding" class="form-label">Padding (px)</label>
                            <input type="number" class="form-control name" id="image_padding" name="image_padding" aria-describedby="inputGroupPrepend" value="{{ $letter_heads->image_style['image_padding'] ?? '' }}">
                        </div>

                        {{-- Image url--}}
                        <div class="col-md-2 col-12">
                            <label for="image_url" class="form-label">Full Width Image </label>
                            <input type="file" class="form-control" id="image_url" name="image_url">
                        </div>

                    </div>
                    <div class="card-body g-3 row">
                        <div class="col-12" align="center">
                            <div class="d-grid gap-2 with-50">
                                <button class="btn btn-primary save_button" type="submit"><i class="bx bx-save"></i> Update Letter Head</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div> @endsection @section('js') <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/12.1.10/js/intlTelInput.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script type="text/javascript" src="{{ asset('admin/plugins/datepicker/js/bootstrap-datepicker.js') }}"></script>
<!-- Include Flatpickr JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
    $(document).on('click', '.save_button', function(e) {
        var error = 0;
        if (error == 0) {
            let formdata = new FormData($('#edit_letter_head_form')[0]);
            $.ajax({
                url: $('#edit_letter_head_form').attr('action'),
                data: formdata,
                processData: false,
                contentType: false,
                type: 'POST',
                success: function(response) {
                    if (response.success === true) {
                        toastr.success(response.message, 'Success.');
                        console.log('Updated');
                        setTimeout(function() {
                            window.location.href = "{{ route('letter-heads.index') }}";
                        }, 2000);
                    } else {
                        // Handle failure case
                        toastr.error(response.message, 'Error.');
                    }
                }
            }).fail(function(jqXHR, textStatus, errorThrown) {
                console.log('AJAX request failed:', textStatus, errorThrown);
                toastr.error('An error occurred during the request.', 'Error!');
            });
        }
    })
</script>
@endsection