@extends('layouts.app')
@section('title','Book Language')
@section('pages')


<!--breadcrumb-->
<div class="page-breadcrumb d-flex align-items-center mb-3 px-3 px-md-0">
    <div class="breadcrumb-title pe-3"><i class="bi bi-list"></i>Language</div>
    <div class="ps-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 p-0">
                
                <li class="breadcrumb-item active" aria-current="page">Edit Language</li>
            </ol>
        </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
            <a href="javascript:history.back()" class="btn btn-outline-secondary"><i class="bx bx-arrow-back ms-0 me-1"></i>Back</a>
        </div>
    </div>
</div>
<!--end breadcrumb-->


<div class="row auto">
  <div class="col-xl-12 mx-auto">
    <div class=" shadow-none radius-5 min-height">
      <div class="">
        <div class="">
          <form class="g-3 row auto-width" action="{{route('book-languages.update',$booklanguages->id)}}" class="ajaxformfileupload" method="POST" enctype='multipart/form-data'>
            <!-- For validation comment on -->
            @csrf
            @method('PUT')
            <div class="col-md-6 col-sm-12">
              <div class="card">
                <div class="card-body">
                  <div class="g-3 row">
                    <h5 class="mb-0">Book Language</h5>
                    <hr class="mb-0">
                    <div class="col-md-12">
                     <label for="fname" class="form-label">Language Name <span class="text-danger"><b>*</b></span></label>
                     <div class="input-group has-validation"> <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-people"></i></span>
                      <input type="text" class="form-control" name="lang_name" id="fname" placeholder="Language Name" value="{{$booklanguages->lang_name}}" required="">
                      @if ($errors->has('lang_name'))
                      <span class="text-danger">{{ $errors->first('lang_name') }}</span>
                      @endif
                    </div>	
                  </div>	
                  <div class="col-md-12">
                   <label for="lang_code" class="form-label">Language Code <span class="text-danger"><b>*</b></span></label>
                   <div class="input-group has-validation"> <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-code"></i></span>
                    <input type="text" class="form-control" name="lang_code" id="lang_code" placeholder="Language Code" value="{{$booklanguages->lang_code}}" required="">
                    @if ($errors->has('lang_code'))
                    <span class="text-danger">{{ $errors->first('lang_code') }}</span>
                    @endif
                  </div>	
                </div>					
                <div class="col-12" align="center">
                  <div class="d-grid gap-2 with-50">
                    <button class="btn btn-primary"  type="submit"><i class="bx bx-save"></i> Save Data</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-sm-12">
          <div class="card">
            <div class="card-body">
              <div class="g-3 row">
                <h5 class="mb-0">Book Language</h5>
                <hr class="mb-0">
                 <div class="col-md-12">
                  <label for="cover_image_small" class="form-label">Cover Small Image (Size 200 KB)</label>
                  <input type="file" class="form-control" name="cover_image_small" id="cover_image_small" placeholder="cover_image_small">
                  @if ($errors->has('cover_image_small'))
                  <span class="text-danger">{{ $errors->first('cover_image_small') }}</span>
                  @endif
                </div>  
                <div class="col-md-12">
                  <label for="cover_image_large" class="form-label">Cover Large Image (Size 200 KB)</label>
                  <input type="file" class="form-control" name="cover_image_large" id="cover_image_large" placeholder="cover_image_large">
                  @if ($errors->has('cover_image_large'))
                  <span class="text-danger">{{ $errors->first('cover_image_large') }}</span>
                  @endif
                </div>  
               
                <div class="col-md-6">
                  <div class="form-check form-switch form-switch-lg">
                    <input class="btn-lg form-check-input" type="checkbox" id="flexSwitchCheckDefault" name="isfeatured"  @if($booklanguages->isfeatured=='1'){{'checked'}}@endif> Is Featured
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-check form-switch form-switch-lg">
                    <input class="btn-lg form-check-input" type="checkbox" id="flexSwitchCheckDefault" name="website_view"  @if($booklanguages->website_view=='1'){{'checked'}}@endif> Website View
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>

      </div>
    </div>
    <!--end row-->
    @endsection